/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.VjoMethodControlFlowTable;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.InvalidIdentifierNameWithKeywordRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.MethodAndReturnFlowRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.TypeCheckUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPreAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jst.IInferred;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstName;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.declaration.JstVariantType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IStmt;

public class VjoJstMethodValidator
extends VjoSemanticValidator
implements IVjoValidationPreAllChildrenListener,
IVjoValidationPostAllChildrenListener {
    private static List<Class<? extends IJstNode>> s_targetTypes = new ArrayList<Class<? extends IJstNode>>();
    private static final String[] VJO_KEYWORDS;
    private static final String[] VJO_KEYWORDS_4_ETYPE;

    static {
        s_targetTypes.add(JstMethod.class);
        VJO_KEYWORDS = new String[]{"vj$", "base", "_getBase", "constructs"};
        VJO_KEYWORDS_4_ETYPE = new String[]{"vj$", "base", "_getBase", "name", "ordinal", "values", "constructs"};
    }

    @Override
    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
        return s_targetTypes;
    }

    @Override
    public void onPreAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof JstMethod)) {
            return;
        }
        this.validateBefore(ctx, (JstMethod)jstNode);
    }

    @Override
    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof JstMethod)) {
            return;
        }
        this.validateAfter((JstMethod)jstNode, ctx);
    }

    protected void validateAfter(JstMethod jstMethod, VjoValidationCtx ctx) {
        if (jstMethod.isAbstract() || jstMethod.getOwnerType() != null && (jstMethod.getOwnerType().isInterface() || jstMethod.getOwnerType().isOType())) {
            JstBlock blk;
            if (jstMethod.isFinal()) {
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstMethod, ctx.getGroupId(), new String[]{jstMethod.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_OR_PROPERTY_SHOULD_NOT_BE_BOTH_FINAL_AND_ABSTRACT, ruleCtx);
            }
            if ((blk = jstMethod.getBlock()) != null && blk.getStmts().size() > 0) {
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstMethod.getName(), ctx.getGroupId(), new String[]{jstMethod.getOwnerType().getName(), jstMethod.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ABSTRACT_MEMBER_SHOULD_NOT_HAVE_DEFINITION, ruleCtx);
            }
            return;
        }
        String[] arguments = new String[2];
        arguments[0] = jstMethod.getName() != null && jstMethod.getName().getName() != null ? jstMethod.getName().getName() : "NULL";
        MethodAndReturnFlowRuleCtx ruleCtx = new MethodAndReturnFlowRuleCtx((IJstNode)jstMethod.getName(), ctx.getGroupId(), arguments, (IJstMethod)jstMethod, ctx.getMethodControlFlowTable());
        if (jstMethod.getBlock() == null) {
            return;
        }
        VjoMethodControlFlowTable flowTable = ctx.getMethodControlFlowTable();
        if (flowTable != null && jstMethod.getRtnType() != null && !"void".equals(jstMethod.getRtnType().getSimpleName()) && !jstMethod.isReturnTypeOptional()) {
            List<IStmt> rtnStmts = flowTable.lookUpStmt((IJstMethod)jstMethod);
            boolean allReturned = rtnStmts.size() > 0;
            for (IStmt stmt : rtnStmts) {
                if (stmt != null) continue;
                allReturned = false;
                break;
            }
            if (!allReturned) {
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().NONE_VOID_METHOD_SHOULD_HAVE_RETURN, ruleCtx);
            }
        }
    }

    protected void validateBefore(VjoValidationCtx ctx, JstMethod jstMethod) {
        if (jstMethod.getName() != null) {
            String jstMethodName = jstMethod.getName().getName();
            InvalidIdentifierNameWithKeywordRuleCtx ruleCtx = new InvalidIdentifierNameWithKeywordRuleCtx((IJstNode)jstMethod.getName(), ctx.getGroupId(), new String[]{jstMethodName, jstMethodName}, jstMethodName, jstMethod.getOwnerType() != null && jstMethod.getOwnerType().isEnum());
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().INVALID_IDENTIFIER_WITH_KEYWORD, ruleCtx);
        }
        if (jstMethod.isStatic()) {
            for (JstArg arg : jstMethod.getArgs()) {
                if (!(arg.getType() instanceof JstParamType)) continue;
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)arg, ctx.getGroupId(), new String[]{arg.getType().getAlias()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().STATIC_REFERENCE_TO_NON_STATIC_TYPE, ruleCtx);
            }
        }
        if (jstMethod.getModifiers().isAbstract()) {
            BaseVjoSemanticRuleCtx ruleCtx;
            if (jstMethod.getModifiers().isStatic()) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstMethod.getName(), ctx.getGroupId(), new String[]{jstMethod.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_OR_PROPERTY_SHOULD_NOT_BE_BOTH_STATIC_AND_ABSTRACT, ruleCtx);
            }
            if (jstMethod.getModifiers().isPrivate()) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstMethod.getName(), ctx.getGroupId(), new String[]{jstMethod.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_OR_PROPERTY_SHOULD_NOT_BE_BOTH_PRIVATE_AND_ABSTRACT, ruleCtx);
            }
        }
        if (!jstMethod.isDispatcher()) {
            this.validateMethod(ctx, jstMethod);
        } else {
            for (IJstMethod mtd : jstMethod.getOverloaded()) {
                this.validateMethod(ctx, (JstMethod)mtd);
            }
            this.validateOverloading(ctx, (IJstMethod)jstMethod, jstMethod.getOverloaded());
        }
    }

    private void validateMethod(VjoValidationCtx ctx, JstMethod jstMethod) {
        IJstType rtnType;
        List parameters = jstMethod.getArgs();
        if (parameters != null && parameters.size() > 0) {
            int it = 0;
            int len = parameters.size();
            while (it < len) {
                JstArg argument = (JstArg)parameters.get(it);
                if (it < len - 1) {
                    argument.isVariable();
                }
                for (IJstType argType : argument.getTypes()) {
                    BaseVjoSemanticRuleCtx ruleCtx;
                    if (TypeCheckUtil.isVoid(argType)) {
                        ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)argument, ctx.getGroupId(), new String[]{argument.getName(), jstMethod.getName().getName()});
                        this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_ARGS_TYPE_SHOULD_NOT_BE_VOID, ruleCtx);
                    }
                    if (argType instanceof JstMixedType) {
                        JstMixedType mixedType = (JstMixedType)argType;
                        for (IJstType type : mixedType.getMixedTypes()) {
                            if (this.getKnownType(ctx, (IJstType)jstMethod.getOwnerType(), type) != null) continue;
                            if (!ctx.getMissingImportTypes().contains(type)) {
                                ctx.addMissingImportType(type);
                            }
                            BaseVjoSemanticRuleCtx ruleCtx2 = new BaseVjoSemanticRuleCtx((IJstNode)argument, ctx.getGroupId(), new String[]{type.getName()});
                            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().UNKNOWN_TYPE_MISSING_IMPORT, ruleCtx2);
                        }
                        continue;
                    }
                    if (this.getKnownType(ctx, (IJstType)jstMethod.getOwnerType(), argType) == null) {
                        if (!ctx.getMissingImportTypes().contains(argType)) {
                            ctx.addMissingImportType(argType);
                        }
                        ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)argument, ctx.getGroupId(), new String[]{argType.getName()});
                        this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().UNKNOWN_TYPE_MISSING_IMPORT, ruleCtx);
                        continue;
                    }
                    if (argType == null || !(argType instanceof JstTypeWithArgs)) continue;
                    this.validateJstWithArgs((IJstType)jstMethod.getOwnerType(), (IJstNode)argument, argument.getName(), ctx, (JstTypeWithArgs)argType);
                }
                List<IJstNode> scopedVars = ctx.getMethodControlFlowTable().lookUpScopedVars((IJstMethod)jstMethod);
                String lhsName = argument.getName();
                if (lhsName != null) {
                    boolean addScopedVar = true;
                    for (IJstNode scopedVar : scopedVars) {
                        if (scopedVar == null) continue;
                        String scopedVarName = null;
                        if (scopedVar instanceof JstIdentifier) {
                            scopedVarName = ((JstIdentifier)scopedVar).getName();
                        } else if (scopedVar instanceof JstVar) {
                            scopedVarName = ((JstVar)scopedVar).getName();
                        } else if (scopedVar instanceof JstArg) {
                            scopedVarName = ((JstArg)scopedVar).getName();
                        } else if (scopedVar instanceof JstName) {
                            scopedVarName = ((JstName)scopedVar).getName();
                        }
                        if (!lhsName.equals(scopedVarName)) continue;
                        BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)argument, ctx.getGroupId(), new String[]{argument.getName()});
                        this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().VARIABLE_ALREADY_DEFINED, ruleCtx);
                        addScopedVar = false;
                        break;
                    }
                    if (addScopedVar) {
                        ctx.getMethodControlFlowTable().addScopedVar((IJstMethod)jstMethod, (IJstNode)argument);
                    }
                }
                ++it;
            }
        }
        if ((rtnType = jstMethod.getRtnType()) instanceof JstVariantType) {
            this.validateReturnType(ctx, (IJstMethod)jstMethod, (JstVariantType)rtnType);
        } else if (rtnType instanceof JstMixedType) {
            this.validateReturnType(ctx, (IJstMethod)jstMethod, (JstMixedType)rtnType);
        } else {
            this.validateReturnType(ctx, (IJstMethod)jstMethod, rtnType);
        }
    }

    private void validateReturnType(VjoValidationCtx ctx, IJstMethod jstMethod, JstVariantType rtnType) {
        for (IJstType type : rtnType.getVariantTypes()) {
            this.validateReturnType(ctx, jstMethod, type);
        }
    }

    private void validateReturnType(VjoValidationCtx ctx, IJstMethod jstMethod, JstMixedType rtnType) {
        for (IJstType type : rtnType.getMixedTypes()) {
            this.validateReturnType(ctx, jstMethod, type);
        }
    }

    private void validateReturnType(VjoValidationCtx ctx, IJstMethod jstMethod, IJstType rtnType) {
        if (rtnType != null && !(rtnType instanceof IInferred)) {
            if (this.getKnownType(ctx, jstMethod.getOwnerType(), rtnType) == null && rtnType.getPackage().getName() == "" && !"void".equals(rtnType.getName())) {
                if (!ctx.getMissingImportTypes().contains(rtnType)) {
                    ctx.addMissingImportType(rtnType);
                }
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstMethod.getName(), ctx.getGroupId(), new String[]{rtnType.getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().UNKNOWN_TYPE_MISSING_IMPORT, ruleCtx);
            }
            if (rtnType != null && rtnType instanceof JstTypeWithArgs) {
                this.validateJstWithArgs(jstMethod.getOwnerType(), (IJstNode)jstMethod.getName(), jstMethod.getName().getName(), ctx, (JstTypeWithArgs)rtnType);
            }
        }
    }

    protected String[] getVjoKeywords(IJstMethod jstMethod) {
        return jstMethod.getOwnerType() != null && jstMethod.getOwnerType().isEnum() ? VJO_KEYWORDS_4_ETYPE : VJO_KEYWORDS;
    }

    private void validateOverloading(VjoValidationCtx ctx, IJstMethod hostMtd, List<IJstMethod> overloads) {
        int len = overloads.size();
        if (len > 1) {
            int out = 0;
            while (out < len) {
                IJstMethod outMtd = overloads.get(out);
                int in = out + 1;
                while (in < len) {
                    ArrayList<JstArg> toParameters;
                    ArrayList<JstArg> fromParameters;
                    IJstMethod inMtd = overloads.get(in);
                    if (outMtd != inMtd && outMtd.getOwnerType() == inMtd.getOwnerType() && this.checkAmbiguityBetween(fromParameters = new ArrayList<JstArg>(outMtd.getArgs()), toParameters = new ArrayList<JstArg>(inMtd.getArgs()), outMtd.getRtnType(), inMtd.getRtnType())) {
                        BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)hostMtd.getName(), ctx.getGroupId(), new String[]{hostMtd.getName().getName()});
                        this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OVERLOAD_METHOD_SHOULD_NOT_OVERLAP, ruleCtx);
                        return;
                    }
                    ++in;
                }
                ++out;
            }
        }
    }

    public boolean checkAmbiguityBetween(List<JstArg> selfParameters, List<JstArg> otherParameters, IJstType selfRtnType, IJstType otherRtnType) {
        if (selfParameters.size() == 0 && otherParameters.size() == 0) {
            return true;
        }
        if (selfParameters.size() == 0 && otherParameters.size() > 0) {
            return otherParameters.get(0).isVariable();
        }
        if (selfParameters.size() > 0 && otherParameters.size() == 0) {
            return selfParameters.get(0).isVariable();
        }
        JstArg selfParameter = selfParameters.remove(0);
        JstArg otherParameter = otherParameters.remove(0);
        if (selfParameter.isVariable() && otherParameter.isVariable()) {
            return selfRtnType != otherRtnType;
        }
        if (this.typeEquals(selfParameter.getType(), otherParameter.getType())) {
            return this.checkAmbiguityBetween(selfParameters, otherParameters, selfRtnType, otherRtnType);
        }
        return false;
    }

    private boolean typeEquals(IJstType a, IJstType b) {
        if (a == null || b == null || a.getName() == null || b.getName() == null) {
            return false;
        }
        return a.getName().equals(b.getName());
    }
}

