/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.InvalidIdentifierNameWithKeywordRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.TypeCheckUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPreAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jst.IInferred;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.SynthOlType;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.meta.BaseJsCommentMetaNode;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;

public class VjoJstPropertyValidator
extends VjoSemanticValidator
implements IVjoValidationPreAllChildrenListener,
IVjoValidationPostAllChildrenListener {
    private static List<Class<? extends IJstNode>> s_targetTypes = new ArrayList<Class<? extends IJstNode>>();

    static {
        s_targetTypes.add(JstProperty.class);
    }

    @Override
    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
        return s_targetTypes;
    }

    @Override
    public void onPreAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof IJstProperty)) {
            return;
        }
        IJstProperty jstProperty = (IJstProperty)jstNode;
        if (jstProperty.getName() != null) {
            String jstPropertyName = jstProperty.getName().getName();
            InvalidIdentifierNameWithKeywordRuleCtx idRuleCtx = new InvalidIdentifierNameWithKeywordRuleCtx((IJstNode)jstProperty.getName(), ctx.getGroupId(), new String[]{jstPropertyName, jstPropertyName}, jstPropertyName, jstProperty.getOwnerType() != null && jstProperty.getOwnerType().isEnum());
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().INVALID_IDENTIFIER_WITH_KEYWORD, idRuleCtx);
        }
        if (jstProperty.getModifiers().isAbstract()) {
            BaseVjoSemanticRuleCtx ruleCtx;
            if (jstProperty.getModifiers().isStatic()) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstProperty.getName(), ctx.getGroupId(), new String[]{jstProperty.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_OR_PROPERTY_SHOULD_NOT_BE_BOTH_STATIC_AND_ABSTRACT, ruleCtx);
            }
            if (jstProperty.getModifiers().isPrivate()) {
                ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstProperty.getName(), ctx.getGroupId(), new String[]{jstProperty.getName().getName()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_OR_PROPERTY_SHOULD_NOT_BE_BOTH_PRIVATE_AND_ABSTRACT, ruleCtx);
            }
        }
        IJstType ownerType = jstProperty.getOwnerType();
        if (!jstProperty.isStatic() && ownerType.isClass() && jstProperty.getName() != null) {
            String propertyName = jstProperty.getName().getName();
            IJstType extType = ownerType.getExtend();
            if (propertyName != null) {
                while (extType != null) {
                    if (extType.getProperty(propertyName, false, false) != null) {
                        BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstProperty.getName(), ctx.getGroupId(), new String[]{propertyName, extType.getName()});
                        this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().PROPERTY_SHOULD_NOT_HIDE_PARENT_PROPERTY, ruleCtx);
                        break;
                    }
                    extType = extType.getExtend();
                }
            }
        }
    }

    @Override
    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof IJstProperty)) {
            return;
        }
        IJstProperty jstProperty = (IJstProperty)jstNode;
        IJstType jstType = ctx.getScope().getClosestTypeScopeNode();
        this.validatePropertyType(ctx, jstProperty, jstType);
        IExpr initExpr = jstProperty.getInitializer();
        if (initExpr != null) {
            this.validatePropertyExpr(ctx, jstProperty, initExpr);
        } else if (!jstType.getEnumValues().contains(jstProperty) && jstProperty.getValue() != null && jstProperty.getValue() instanceof IExpr) {
            this.validatePropertyExpr(ctx, jstProperty, (IExpr)jstProperty.getValue());
        }
    }

    private void validatePropertyExpr(VjoValidationCtx ctx, IJstProperty jstProperty, IExpr propertyExpr) {
        if (jstProperty == null || propertyExpr == null) {
            return;
        }
        IJstType initExprValue = propertyExpr.getResultType();
        if (initExprValue != null) {
            if (!"Object".equals(initExprValue.getName()) || !(propertyExpr instanceof SimpleLiteral)) {
                ctx.getPropertyStatesTable().assign(jstProperty);
            }
            if (jstProperty.getOwnerType() != null && jstProperty.getOwnerType().getAllPossibleProperties(jstProperty.isStatic(), true).contains(jstProperty)) {
                this.validatePropertyExprInitialization(ctx, jstProperty, propertyExpr);
            }
            if (jstProperty.getType() != null && !TypeCheckUtil.isAssignable(jstProperty.getType(), initExprValue)) {
                String[] arguments = new String[]{jstProperty.getType().getSimpleName(), initExprValue.getSimpleName(), propertyExpr.toExprText()};
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)propertyExpr, ctx.getGroupId(), arguments);
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ASSIGNABLE, ruleCtx);
                return;
            }
        }
    }

    private boolean validatePropertyExprInitialization(VjoValidationCtx ctx, IJstProperty property, IExpr propertyExpr) {
        if (propertyExpr == null) {
            return true;
        }
        ArrayList<IExpr> subExprs = new ArrayList<IExpr>();
        for (IJstNode child : propertyExpr.getChildren()) {
            if (child == null || !(child instanceof IExpr) || child instanceof BaseJsCommentMetaNode) continue;
            subExprs.add((IExpr)child);
        }
        for (IExpr subExpr : subExprs) {
            if (this.validatePropertyExprInitialization(ctx, property, subExpr)) continue;
            return false;
        }
        IJstType propertyExprResultType = propertyExpr.getResultType();
        if (!this.isNative(propertyExprResultType) || propertyExprResultType == null) {
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)property, ctx.getGroupId(), new String[]{property.getName().getName(), propertyExprResultType != null ? propertyExprResultType.getName() : property.getInitializer().toExprText()});
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().CANNOT_USE_UNINTIALIZED_TYPE, ruleCtx);
            return false;
        }
        return true;
    }

    private boolean isNative(IJstType propertyExprResultType) {
        if (propertyExprResultType instanceof SynthOlType) {
            return true;
        }
        if (propertyExprResultType instanceof JstArrayInitializer || propertyExprResultType instanceof JstArray) {
            return true;
        }
        if (propertyExprResultType == null || propertyExprResultType.getPackage() == null) {
            return false;
        }
        String groupName = propertyExprResultType.getPackage().getGroupName();
        return groupName.equals("JsNativeGlobal") || groupName.equals("JsBrowserLib") || groupName.equals("JsNativeLib") || groupName.equals("VjoSelfDescribed") || groupName.equals("JavaPrimitive");
    }

    protected void validatePropertyType(VjoValidationCtx ctx, IJstProperty jstProperty, IJstType jstType) {
        IJstType propertyJstType = jstProperty.getType();
        if (!(jstType.isEnum() && jstType.getEnumValues().contains(jstProperty) || !(propertyJstType instanceof IInferred))) {
            return;
        }
        this.validateComplexType(ctx, (IJstNode)jstProperty, jstProperty.getName().getName(), propertyJstType);
    }
}

