/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstDoc;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstName;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;

public class JstMethod
extends BaseJstNode
implements IJstMethod {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY = "";
    private JstName m_name;
    private JstModifiers m_modifiers;
    private List<JstArg> m_args;
    private IJstTypeReference m_rtnType;
    private JstBlock m_block;
    private Map<String, IJstType> m_varTypes;
    private Map<String, JstParamType> m_paramTypes;
    private boolean m_isConstructor = false;
    private boolean m_isDuplicate = false;
    private boolean m_hasAnnotation = false;
    private boolean m_typeFactoryEnabled = false;
    private boolean m_funcArgMetaExtensionEnabled = false;
    private String m_surffix;
    private IJstDoc m_doc;
    private JstFunctionRefType m_oType;
    private List<IJstMethod> m_overloaded;
    private boolean m_returnOptional;
    public static final String OVLD = "_ovld";

    public JstMethod(JstArg ... args) {
        this((JstName)null, new JstModifiers(), (IJstType)null, args);
    }

    public JstMethod(String name, JstArg ... args) {
        this(name, new JstModifiers(), (IJstType)null, args);
    }

    public JstMethod(String name, JstModifiers modifiers, JstArg ... args) {
        this(name, modifiers, (IJstType)null, args);
    }

    public JstMethod(String name, IJstType rtnType, JstArg ... args) {
        this(name, new JstModifiers(), rtnType, args);
    }

    public JstMethod(String name, JstModifiers modifiers, IJstType rtnType, JstArg ... args) {
        this(new JstName(name), modifiers, rtnType, args);
    }

    public JstMethod(JstName name, JstModifiers modifiers, IJstType rtnType, JstArg ... args) {
        this.setName(name);
        this.m_modifiers = modifiers;
        if (rtnType != null) {
            this.m_rtnType = new JstTypeReference(rtnType);
            this.addChild(this.m_rtnType);
        }
        if (args != null && args.length > 0) {
            this.m_args = new ArrayList<JstArg>(args.length);
            JstArg[] jstArgArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                JstArg p = jstArgArray[n2];
                this.addArg(p);
                ++n2;
            }
        }
    }

    @Override
    public JstName getName() {
        return this.m_name;
    }

    @Override
    public List<JstArg> getArgs() {
        if (this.m_args == null) {
            return Collections.emptyList();
        }
        return this.m_args;
    }

    @Override
    public boolean isVarArgs() {
        if (this.getArgs().size() == 0) {
            return false;
        }
        List<JstArg> args = this.getArgs();
        return args.get(args.size() - 1).isVariable();
    }

    @Override
    public IJstType getRtnType() {
        return this.m_rtnType != null ? this.m_rtnType.getReferencedType() : null;
    }

    @Override
    public IJstTypeReference getRtnTypeRef() {
        return this.m_rtnType;
    }

    @Override
    public JstModifiers getModifiers() {
        return this.m_modifiers;
    }

    @Override
    public boolean isConstructor() {
        return this.m_isConstructor;
    }

    @Override
    public boolean isPublic() {
        return this.m_modifiers.isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.m_modifiers.isProtected();
    }

    @Override
    public boolean isInternal() {
        return this.m_modifiers.isInternal();
    }

    @Override
    public boolean isPrivate() {
        return this.m_modifiers.isPrivate();
    }

    @Override
    public boolean isStatic() {
        return this.m_modifiers.isStatic();
    }

    @Override
    public boolean isFinal() {
        return this.m_modifiers.isFinal();
    }

    @Override
    public boolean isAbstract() {
        return this.m_modifiers.isAbstract();
    }

    @Override
    public JstBlock getBlock() {
        return this.getBlock(false);
    }

    @Override
    public boolean isDispatcher() {
        return this.m_overloaded != null && this.m_overloaded.size() > 0;
    }

    @Override
    public List<IJstMethod> getOverloaded() {
        if (this.m_overloaded == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_overloaded);
    }

    @Override
    public String getOriginalName() {
        if (this.getName() == null || this.getName().getName() == null) {
            return null;
        }
        String name = this.getName().getName();
        if (this.m_surffix == null) {
            return name;
        }
        if (name.indexOf(this.m_surffix) != -1) {
            return name.substring(0, name.indexOf(this.m_surffix));
        }
        return name;
    }

    @Override
    public boolean isParamName(String name) {
        return name != null && this.getParamNames().contains(name);
    }

    @Override
    public synchronized List<String> getParamNames() {
        if (this.m_paramTypes == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.m_paramTypes.keySet());
        return list;
    }

    @Override
    public synchronized List<JstParamType> getParamTypes() {
        if (this.m_paramTypes == null) {
            return Collections.emptyList();
        }
        ArrayList<JstParamType> list = new ArrayList<JstParamType>();
        list.addAll(this.m_paramTypes.values());
        return list;
    }

    public JstMethod setName(JstName name) {
        this.m_name = name;
        this.removeNameNode();
        this.addChild(name);
        return this;
    }

    private void removeNameNode() {
        for (BaseJstNode node : this.getChildren()) {
            if (!(node instanceof JstName)) continue;
            this.removeChild(node);
            break;
        }
    }

    public JstMethod setName(String name) {
        return this.setName(new JstName(name));
    }

    public JstMethod addArg(JstArg arg) {
        assert (arg != null) : "arg is null";
        if (this.m_args == null) {
            this.m_args = new ArrayList<JstArg>(2);
        }
        this.m_args.add(arg);
        this.addChild(arg);
        return this;
    }

    public JstMethod removeArgs() {
        if (this.m_args != null) {
            this.removeChildren(this.m_args);
            this.m_args.clear();
        }
        return this;
    }

    public JstMethod setRtnType(IJstType rtnType) {
        if (this.m_rtnType != null) {
            this.removeChild(this.m_rtnType);
            this.m_rtnType = null;
        }
        if (rtnType != null) {
            this.m_rtnType = new JstTypeReference(rtnType);
            this.addChild(this.m_rtnType);
        }
        return this;
    }

    public JstMethod setReturnOptional(boolean isReturnOptional) {
        this.m_returnOptional = isReturnOptional;
        return this;
    }

    @Override
    public boolean isReturnTypeOptional() {
        return this.m_returnOptional;
    }

    public JstMethod setRtnRefType(IJstTypeReference rtnType) {
        if (this.m_rtnType != null) {
            this.removeChild(this.m_rtnType);
            this.m_rtnType = null;
        }
        if (rtnType != null) {
            this.m_rtnType = rtnType;
            this.addChild(this.m_rtnType);
        }
        return this;
    }

    public JstMethod setBlock(JstBlock block) {
        this.removeChild(this.m_block);
        this.addChild(block);
        this.m_block = block;
        if (block == null) {
            this.removeChild(this.m_block);
        } else {
            this.addChild(block);
        }
        return this;
    }

    public JstBlock getBlock(boolean create) {
        if (this.m_block == null && create) {
            this.setBlock(new JstBlock());
        }
        return this.m_block;
    }

    public JstMethod addStmt(IStmt stmt) {
        assert (stmt != null) : "stmt cannot be null";
        this.getBlock(true).addStmt(stmt);
        return this;
    }

    public JstMethod addVarType(String name, IJstType type) {
        if (this.m_varTypes == null) {
            this.m_varTypes = new LinkedHashMap<String, IJstType>(2);
        }
        this.m_varTypes.put(name, type);
        return this;
    }

    public IJstType getVarType(String name) {
        if (this.m_varTypes == null) {
            return null;
        }
        return this.m_varTypes.get(name);
    }

    public String getAccessScope() {
        return this.m_modifiers.getAccessScope();
    }

    @Override
    public IJstDoc getDoc() {
        return this.m_doc;
    }

    public void setOType(JstFunctionRefType funcRef) {
        this.m_oType = funcRef;
        IJstMethod meth = funcRef.getMethodRef();
        JstTypeHelper.populateMethod(this, meth);
        for (IJstMethod over : meth.getOverloaded()) {
            JstMethod o = new JstMethod(this.getOriginalName(), new JstArg[0]);
            if (this.getModifiers().isPublic()) {
                o.getModifiers().setPublic();
            } else if (this.getModifiers().isPrivate()) {
                o.getModifiers().setPrivate();
            } else if (this.getModifiers().isProtected()) {
                o.getModifiers().setProtected();
            }
            o.getModifiers().setStatic(this.getModifiers().isStatic());
            JstTypeHelper.populateMethod(o, over);
            this.addOverloaded(o);
        }
    }

    public JstFunctionRefType getOType() {
        return this.m_oType;
    }

    public void setDoc(IJstDoc jstDoc) {
        this.m_doc = jstDoc;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb;
        Z z = new Z();
        if (this.m_name != null) {
            z.format("m_name", this.m_name == null ? null : this.m_name.getName());
        }
        if (this.m_modifiers != null) {
            z.format("m_modifiers", (Object)this.m_modifiers);
        }
        if (this.m_args != null && this.m_args.size() > 0) {
            sb = new StringBuilder("(");
            for (JstArg jstArg : this.m_args) {
                if (jstArg.getType() == null) continue;
                sb.append(jstArg.getType().getName()).append(" ").append(jstArg.getName()).append(",");
            }
            sb.append(")");
            z.format("m_args", (Object)sb.toString());
        }
        if (this.m_varTypes != null && this.m_varTypes.size() > 0) {
            sb = new StringBuilder();
            for (Map.Entry entry : this.m_varTypes.entrySet()) {
                sb.append("\n\t").append((String)entry.getKey()).append(" ").append(((IJstType)entry.getValue()).getName());
            }
            z.format("m_varTypes", (Object)sb.toString());
        }
        if (this.getRtnType() != null) {
            z.format("m_rtnType", (Object)this.getRtnType().getName());
        }
        if (this.m_overloaded != null && this.m_overloaded.size() > 0) {
            for (IJstMethod overloadedMth : this.m_overloaded) {
                z.format("overloaded", (Object)overloadedMth.toString());
            }
        }
        return z.toString();
    }

    public JstMethod setIsConstructor(boolean isConstructor) {
        this.m_isConstructor = isConstructor;
        return this;
    }

    public JstMethod addOverloaded(JstMethod jstMethod) {
        if (this.m_overloaded == null) {
            this.m_overloaded = new ArrayList<IJstMethod>();
        }
        this.m_overloaded.add(jstMethod);
        return this;
    }

    public JstMethod setOverloaded(List<IJstMethod> jstMethods) {
        if (jstMethods != null) {
            this.m_overloaded = new ArrayList<IJstMethod>();
            this.m_overloaded.addAll(jstMethods);
        } else {
            this.m_overloaded = jstMethods;
        }
        return this;
    }

    public String getSurffix() {
        return this.m_surffix;
    }

    public void setSurffix(String surffix) {
        this.m_surffix = surffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JstParamType addParam(String paramName) {
        if (paramName == null) {
            return null;
        }
        JstMethod jstMethod = this;
        synchronized (jstMethod) {
            JstParamType pType;
            if (this.m_paramTypes == null) {
                this.m_paramTypes = new LinkedHashMap<String, JstParamType>();
            }
            if ((pType = this.m_paramTypes.get(paramName)) != null) {
                return pType;
            }
            pType = new JstParamType(paramName);
            this.m_paramTypes.put(paramName, pType);
            return pType;
        }
    }

    public synchronized JstParamType getParamType(String name) {
        if (this.m_paramTypes == null) {
            return null;
        }
        return this.m_paramTypes.get(name);
    }

    @Override
    public String getParamsDecoration() {
        if (this.getParamNames().isEmpty()) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder("<");
        int i = 0;
        for (JstParamType p : this.getParamTypes()) {
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(p.getSimpleName());
            if (p.getBounds().isEmpty()) continue;
            IJstType bType = p.getBounds().get(0);
            sb.append(" extends ").append(bType.getSimpleName());
            if (!(bType instanceof JstTypeWithArgs)) continue;
            sb.append(((JstTypeWithArgs)bType).getArgsDecoration());
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public boolean isOType() {
        return this.m_oType != null;
    }

    @Override
    public boolean isDuplicate() {
        return this.m_isDuplicate;
    }

    public void setIsDuplicate(boolean isDuplicate) {
        this.m_isDuplicate = isDuplicate;
    }

    @Override
    public boolean isTypeFactoryEnabled() {
        return this.m_typeFactoryEnabled;
    }

    public void setTypeFactoryEnabled(boolean set) {
        this.m_typeFactoryEnabled = set;
    }

    @Override
    public boolean isFuncArgMetaExtensionEnabled() {
        return this.m_funcArgMetaExtensionEnabled;
    }

    public void setFuncArgMetaExtensionEnabled(boolean set) {
        this.m_funcArgMetaExtensionEnabled = set;
    }

    public void updateArgType(int index, IJstType newType) {
        JstArg arg = this.m_args.get(index);
        IJstType type = arg.getType();
        if (type == null) {
            return;
        }
        arg.updateType(type.getName(), newType);
    }

    public static String getOverloadSuffix(IJstType type) {
        if (type == null) {
            return null;
        }
        return "_" + type.getSimpleName() + OVLD;
    }

    @Override
    public boolean hasJsAnnotation() {
        return this.m_hasAnnotation;
    }

    public void setHasJsAnnotation(boolean hasAnnotation) {
        this.m_hasAnnotation = hasAnnotation;
    }
}

