/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class CastExpr
extends BaseJstNode
implements IExpr {
    private static final long serialVersionUID = 1L;
    private IExpr m_expr;
    private IJstType m_castTo;

    public CastExpr(IExpr expr) {
        if (expr == null) {
            throw new AssertionError((Object)"expr cannot be null");
        }
        this.m_expr = expr;
        this.addChild(expr);
    }

    public CastExpr(IExpr expr, IJstType castTo) {
        this(expr);
        if (castTo == null) {
            throw new AssertionError((Object)"castTo cannot be null");
        }
        this.m_castTo = castTo;
        this.addChild(new JstTypeReference(castTo));
    }

    @Override
    public String toExprText() {
        return this.m_expr.toExprText();
    }

    @Override
    public IJstType getResultType() {
        return this.m_castTo != null ? this.m_castTo : this.m_expr.getResultType();
    }

    @Override
    public JstSource getSource() {
        return super.getSource() != null ? super.getSource() : this.m_expr.getSource();
    }

    public IExpr getExpr() {
        return this.m_expr;
    }

    public IJstType getCastToType() {
        return this.m_castTo;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }
}

