/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstResultTypeModifier;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.ArithExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;

public class InfixExpr
extends ArithExpr
implements IJstResultTypeModifier {
    private static final long serialVersionUID = 1L;
    private IExpr m_left;
    private IExpr m_right;
    private final Operator m_op;
    private IJstType m_type;

    public InfixExpr(IExpr left, IExpr right, Operator op) {
        if (op == null) {
            throw new RuntimeException("Operator can't be null");
        }
        this.m_left = left;
        this.m_right = right;
        this.m_op = op;
        this.addChild(left);
        this.addChild(right);
    }

    @Override
    public IJstType getResultType() {
        if (this.m_type == null) {
            IJstType leftType;
            boolean useRight = true;
            if (this.m_op == Operator.CONDITIONAL_OR) {
                leftType = JstTypeHelper.getExprType(this.m_left);
                IJstType rightType = JstTypeHelper.getExprType(this.m_right);
                if (rightType == leftType || leftType == null) {
                    this.m_type = rightType;
                } else if (rightType == null) {
                    this.m_type = leftType;
                    useRight = false;
                } else if (leftType.getName().equals(rightType.getName())) {
                    this.m_type = rightType;
                }
            } else {
                leftType = this.m_left.getResultType();
                IJstType rightType = this.m_right.getResultType();
                if (leftType == null) {
                    this.m_type = rightType;
                } else if (rightType == null) {
                    this.m_type = leftType;
                    useRight = false;
                } else if (DataTypeHelper.canPromote(leftType, rightType)) {
                    this.m_type = rightType;
                } else {
                    this.m_type = leftType;
                    useRight = false;
                }
            }
            if (this.m_op == Operator.PLUS && this.m_type != null && !"String".equals(this.m_type.getName()) || this.m_op == Operator.MINUS) {
                JstType nativeNumber = JstCache.getInstance().getType("Number");
                if (nativeNumber != null) {
                    if (this.m_type != null && this.m_type != nativeNumber && this.m_type.getExtend() != nativeNumber) {
                        this.m_type = nativeNumber;
                    }
                } else {
                    this.m_type = JstTypeHelper.getPrimitiveType(useRight ? this.m_right : this.m_left);
                }
            }
            if (this.m_op == Operator.CONDITIONAL_AND || this.m_op == Operator.CONDITIONAL_OR) {
                JstType nativeBoolean = JstCache.getInstance().getType("PrimitiveBoolean");
                if (nativeBoolean != null) {
                    if (this.m_type != null && this.m_type != nativeBoolean && this.m_type.getExtend() != nativeBoolean) {
                        this.m_type = nativeBoolean;
                    }
                } else {
                    this.m_type = JstTypeHelper.getPrimitiveType(useRight ? this.m_right : this.m_left);
                }
            }
        }
        return this.m_type;
    }

    @Override
    public String toExprText() {
        StringBuilder sb = new StringBuilder();
        if (this.m_left != null) {
            sb.append(this.m_left.toExprText());
        }
        if (this.m_op.equals(Operator.IN)) {
            sb.append(" ");
        }
        sb.append(this.m_op.toString());
        if (this.m_op.equals(Operator.IN)) {
            sb.append(" ");
        }
        if (this.m_right != null) {
            sb.append(this.m_right.toExprText());
        }
        return sb.toString();
    }

    @Override
    public String toStmtText() {
        return String.valueOf(this.toExprText()) + ";";
    }

    public IExpr getLeft() {
        return this.m_left;
    }

    public IExpr getRight() {
        return this.m_right;
    }

    public void setLeft(IExpr e) {
        this.removeChild(this.m_left);
        this.m_left = e;
        this.addChild(this.m_left);
    }

    public void setRight(IExpr e) {
        this.removeChild(this.m_right);
        this.m_right = e;
        this.addChild(this.m_right);
    }

    public Operator getOperator() {
        return this.m_op;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }

    @Override
    public void setType(IJstType type) {
        this.m_type = type;
    }

    public static class Operator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String token;
        public static final Operator TIMES = new Operator("*");
        public static final Operator DIVIDE = new Operator("/");
        public static final Operator REMAINDER = new Operator("%");
        public static final Operator PLUS = new Operator("+");
        public static final Operator MINUS = new Operator("-");
        public static final Operator LEFT_SHIFT = new Operator("<<");
        public static final Operator RIGHT_SHIFT_SIGNED = new Operator(">>");
        public static final Operator RIGHT_SHIFT_UNSIGNED = new Operator(">>>");
        public static final Operator LESS = new Operator("<");
        public static final Operator GREATER = new Operator(">");
        public static final Operator LESS_EQUALS = new Operator("<=");
        public static final Operator GREATER_EQUALS = new Operator(">=");
        public static final Operator EXACTLY_EQUALS = new Operator("===");
        public static final Operator NOT_EXACTLY_EQUALS = new Operator("!==");
        public static final Operator EQUALS = new Operator("==");
        public static final Operator NOT_EQUALS = new Operator("!=");
        public static final Operator XOR = new Operator("^");
        public static final Operator OR = new Operator("|");
        public static final Operator AND = new Operator("&");
        public static final Operator CONDITIONAL_OR = new Operator("||");
        public static final Operator CONDITIONAL_AND = new Operator("&&");
        public static final Operator IN = new Operator("in");
        private static final Map<String, Operator> CODES = new HashMap<String, Operator>(20);

        static {
            Operator[] ops = new Operator[]{TIMES, DIVIDE, REMAINDER, PLUS, MINUS, LEFT_SHIFT, RIGHT_SHIFT_SIGNED, RIGHT_SHIFT_UNSIGNED, LESS, GREATER, LESS_EQUALS, GREATER_EQUALS, EXACTLY_EQUALS, NOT_EXACTLY_EQUALS, EQUALS, NOT_EQUALS, XOR, OR, AND, CONDITIONAL_OR, CONDITIONAL_AND, IN};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return CODES.get(token);
        }
    }
}

