/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstResultTypeModifier;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstInferredRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstInferredType;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstArrayInitializer
extends BaseJstNode
implements IExpr,
IJstResultTypeModifier {
    private static final long serialVersionUID = 1L;
    private List<IExpr> m_exprs;
    private IJstType m_type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IExpr e) {
        assert (e != null) : "e cannot be null";
        JstArrayInitializer jstArrayInitializer = this;
        synchronized (jstArrayInitializer) {
            if (this.m_exprs == null) {
                this.m_exprs = new ArrayList<IExpr>();
            }
            this.m_exprs.add(e);
        }
        this.addChild(e);
        if (this.m_type == null && e != null && e.getResultType() != null) {
            this.m_type = JstFactory.getInstance().createJstArrayType(this.getInferredComponentType(e), false);
        }
    }

    private IJstType getInferredComponentType(IExpr e) {
        IJstType resultType = e.getResultType();
        if (resultType instanceof IJstRefType) {
            return new JstInferredRefType((IJstRefType)resultType);
        }
        return new JstInferredType(resultType);
    }

    @Override
    public IJstType getResultType() {
        return this.m_type;
    }

    @Override
    public String toExprText() {
        StringBuilder sb = new StringBuilder("[");
        if (this.m_exprs != null && !this.m_exprs.isEmpty()) {
            int i = 0;
            while (i < this.m_exprs.size()) {
                if (i > 0) {
                    sb.append(",");
                }
                if (this.m_exprs.get(i) != null) {
                    sb.append(this.m_exprs.get(i).toExprText());
                }
                ++i;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }

    public void setType(JstArray type) {
        this.m_type = type;
    }

    public List<IExpr> getExprs() {
        if (this.m_exprs == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_exprs;
    }

    public void setExprs(List<IExpr> exprs) {
        for (IExpr expr : this.m_exprs) {
            this.removeChild(expr);
        }
        if (exprs.size() > 0) {
            this.m_exprs = new ArrayList<IExpr>();
            for (IExpr expr : exprs) {
                this.m_exprs.add(expr);
                this.addChild(expr);
            }
        }
    }

    @Override
    public void setType(IJstType type) {
        if (type instanceof JstArray) {
            this.m_type = (JstArray)type;
        }
    }
}

