/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IInitializer;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstInitializer
extends BaseJstNode
implements IInitializer {
    private static final long serialVersionUID = 1L;
    private List<AssignExpr> m_assignments = new ArrayList<AssignExpr>();

    public JstInitializer() {
    }

    public JstInitializer(ILHS lhs, IExpr expr) {
        this.addAssignment(lhs, expr);
    }

    @Override
    public IJstType getType() {
        if (this.m_assignments.size() > 0) {
            return this.m_assignments.get(0).getResultType();
        }
        return null;
    }

    @Override
    public List<AssignExpr> getAssignments() {
        return Collections.unmodifiableList(this.m_assignments);
    }

    @Override
    public String toText() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.m_assignments.size()) {
            if (i > 0) {
                sb.append(",");
            }
            AssignExpr assignExpr = this.m_assignments.get(i);
            sb.append(assignExpr.getLHS().toLHSText());
            if (assignExpr.getExpr() != null) {
                sb.append(assignExpr.getOprator().toString());
                sb.append(assignExpr.getExpr().toExprText());
            }
            ++i;
        }
        return sb.toString();
    }

    public void addAssignment(ILHS lhs, IExpr expr) {
        this.addAssignment(new AssignExpr(lhs, expr));
    }

    public void addAssignment(AssignExpr assignment) {
        this.m_assignments.add(assignment);
        this.addChild(assignment);
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toText();
    }
}

