/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstResultTypeModifier;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.ArithExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;

public class PrefixExpr
extends ArithExpr
implements IJstResultTypeModifier {
    private static final long serialVersionUID = 1L;
    private IExpr m_term;
    private Operator m_op;
    private IJstType m_type;
    private boolean m_isFirstTerm = true;

    public PrefixExpr(IExpr term, Operator op) {
        assert (term != null) : "term cannot be null";
        assert (op != null) : "op cannot be null";
        this.m_term = term;
        this.m_op = op;
        this.addChild(term);
    }

    @Override
    public IJstType getResultType() {
        if (this.m_type == null) {
            this.m_type = this.m_term.getResultType();
            if (this.m_op == Operator.INCREMENT || this.m_op == Operator.DECREMENT) {
                JstType nativeNumber = JstCache.getInstance().getType("Number");
                if (nativeNumber != null) {
                    if (this.m_type != null && this.m_type != nativeNumber && this.m_type.getExtend() != nativeNumber) {
                        this.m_type = nativeNumber;
                    }
                } else {
                    this.m_type = JstTypeHelper.getPrimitiveType(this.m_term);
                }
            } else if (this.m_op == Operator.NOT) {
                JstType nativeBoolean = JstCache.getInstance().getType("PrimitiveBoolean");
                if (nativeBoolean != null) {
                    if (this.m_type != null && this.m_type != nativeBoolean && this.m_type.getExtend() != nativeBoolean) {
                        this.m_type = nativeBoolean;
                    }
                } else {
                    this.m_type = JstTypeHelper.getPrimitiveType(this.m_term);
                }
            }
        }
        return this.m_type;
    }

    @Override
    public String toExprText() {
        StringBuilder sb = new StringBuilder();
        if (!this.m_isFirstTerm) {
            sb.append(" ");
        }
        sb.append(this.m_op.toString());
        if (this.m_term != null) {
            sb.append(this.m_term.toExprText());
        }
        return sb.toString();
    }

    @Override
    public String toStmtText() {
        return String.valueOf(this.toExprText()) + ";";
    }

    public void setOperand(IExpr operand) {
        this.removeChild(this.m_term);
        this.m_term = operand;
        this.addChild(this.m_term);
    }

    public IExpr getIdentifier() {
        return this.m_term;
    }

    public Operator getOperator() {
        return this.m_op;
    }

    public boolean isFirstTerm() {
        return this.m_isFirstTerm;
    }

    public void setIsFirstTerm(boolean isFirstTerm) {
        this.m_isFirstTerm = isFirstTerm;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }

    @Override
    public void setType(IJstType type) {
        this.m_type = type;
    }

    public static class Operator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String token;
        public static final Operator INCREMENT = new Operator("++");
        public static final Operator DECREMENT = new Operator("--");
        public static final Operator PLUS = new Operator("+");
        public static final Operator MINUS = new Operator("-");
        public static final Operator COMPLEMENT = new Operator("~");
        public static final Operator NOT = new Operator("!");
        public static final Operator TYPEOF = new Operator("typeof ");
        public static final Operator DELETE = new Operator("delete ");
        public static final Operator VOID = new Operator("void ");
        private static final Map<String, Operator> CODES = new HashMap<String, Operator>(20);

        static {
            Operator[] ops = new Operator[]{INCREMENT, DECREMENT, PLUS, MINUS, COMPLEMENT, NOT, TYPEOF, DELETE, VOID};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return CODES.get(token);
        }
    }
}

