/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.stmt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.token.IBoolExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IInitializer;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class ForStmt
extends BlockStmt
implements IStmt {
    private static final long serialVersionUID = 1L;
    private IInitializer m_initializers;
    private IBoolExpr m_condition;
    private List<IExpr> m_updaters = new ArrayList<IExpr>(1);

    public ForStmt setInitializer(IInitializer initializers) {
        this.removeChild(this.m_initializers);
        this.addChild(initializers);
        this.m_initializers = initializers;
        return this;
    }

    public IInitializer getInitializers() {
        return this.m_initializers;
    }

    public ForStmt setCondition(IBoolExpr condition) {
        assert (condition != null) : "condition cannot be null";
        this.removeChild(this.m_condition);
        this.addChild(condition);
        this.m_condition = condition;
        return this;
    }

    public IBoolExpr getCondition() {
        return this.m_condition;
    }

    public ForStmt addUpdater(IExpr updater) {
        assert (updater != null) : "updater cannot be null";
        this.m_updaters.add(updater);
        this.addChild(updater);
        return this;
    }

    public List<IExpr> getUpdaters() {
        return Collections.unmodifiableList(this.m_updaters);
    }

    public ForStmt addStmt(IStmt stmt) {
        assert (stmt != null) : "stmt cannot be null";
        this.getBody().addStmt(stmt);
        return this;
    }

    @Override
    public String toStmtText() {
        StringBuilder sb = new StringBuilder("for (");
        if (this.m_initializers != null) {
            sb.append(this.m_initializers.toText());
        }
        sb.append(";");
        if (this.m_condition != null) {
            sb.append(this.m_condition.toBoolExprText());
        }
        sb.append(";");
        int i = 0;
        while (i < this.m_updaters.size()) {
            IExpr updater = this.m_updaters.get(i);
            sb.append(updater.toExprText());
            if (i < this.m_updaters.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")");
        sb.append(this.getBody().toBlockText());
        return sb.toString();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return this.toStmtText();
    }
}

