/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.stmt;

import org.eclipse.vjet.dsf.jst.stmt.JstStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class LabeledStmt
extends JstStmt
implements IStmt {
    private static final long serialVersionUID = 1L;
    private JstIdentifier m_identifier;
    private IStmt m_stmt;

    public LabeledStmt(JstIdentifier identifier) {
        this(identifier, null);
    }

    public LabeledStmt(JstIdentifier identifier, IStmt stmt) {
        assert (identifier != null) : "identifier cannot be null";
        assert (stmt != null) : "stmt cannot be null";
        this.m_identifier = identifier;
        this.addChild(identifier);
        this.setStmt(stmt);
    }

    @Override
    public String toStmtText() {
        return String.valueOf(this.m_identifier.toSimpleTermText()) + ":\n" + this.m_stmt.toString();
    }

    public JstIdentifier getLabel() {
        return this.m_identifier;
    }

    public void setStmt(IStmt stmt) {
        this.m_stmt = stmt;
        this.addChild(stmt);
    }

    public IStmt getStmt() {
        return this.m_stmt;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toStmtText();
    }
}

