/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.term;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.term.JstLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public final class ArrayLiteral
extends JstLiteral {
    private static final long serialVersionUID = 1L;
    private List<IExpr> m_values = new ArrayList<IExpr>(2);

    public ArrayLiteral() {
        this.m_jstType = JstCache.getInstance().getType("Array");
    }

    @Override
    public String toValueText() {
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        while (i < this.m_values.size()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.m_values.get(i).toExprText());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toSimpleTermText() {
        return this.toValueText();
    }

    @Override
    public String toExprText() {
        return this.toValueText();
    }

    public ArrayLiteral add(JstLiteral value) {
        assert (value != null) : "value cannot be null";
        this.m_values.add(value);
        this.addChild(value);
        return this;
    }

    public Iterator<IExpr> getValues() {
        return this.m_values.iterator();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toValueText();
    }
}

