/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;

public class JstRefTypeDependencyCollector {
    public static Map<String, IJstTypeReference> getDependency(IJstType jstType) {
        if (jstType == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, IJstTypeReference> map = new LinkedHashMap<String, IJstTypeReference>();
        if (jstType.getName() != null) {
            JstRefTypeDependencyCollector.addToDependency(jstType.getImportsRef(), map);
            JstRefTypeDependencyCollector.addToDependency(jstType.getExtendRef(), map);
            JstRefTypeDependencyCollector.addToDependency(jstType.getExtendsRef(), map);
            JstRefTypeDependencyCollector.addToDependency(jstType.getSatisfiesRef(), map);
            JstRefTypeDependencyCollector.addToDependency(jstType.getExpectsRef(), map);
            JstRefTypeDependencyCollector.addToDependency(jstType.getInactiveImportsRef(), map);
            JstRefTypeDependencyCollector.addToDependency(jstType.getMixinsRef(), map);
        }
        return map;
    }

    private static void addToDependency(IJstTypeReference dependency, Map<String, IJstTypeReference> map) {
        if (dependency != null) {
            map.put(dependency.getRootType().getName(), dependency);
        }
    }

    private static void addToDependency(List<? extends IJstTypeReference> dependencies, Map<String, IJstTypeReference> map) {
        if (dependencies != null) {
            Iterator<? extends IJstTypeReference> iterator = dependencies.iterator();
            while (iterator.hasNext()) {
                IJstTypeReference t;
                IJstTypeReference dependency = t = iterator.next();
                map.put(dependency.getReferencedType().getName(), dependency);
            }
        }
    }
}

