/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.event.dispatch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.ts.TypeSpaceConfig;
import org.eclipse.vjet.dsf.ts.event.ISourceEvent;
import org.eclipse.vjet.dsf.ts.event.ISourceEventCallback;
import org.eclipse.vjet.dsf.ts.event.ISourceEventListener;
import org.eclipse.vjet.dsf.ts.event.dispatch.IEventDispatcher;
import org.eclipse.vjet.dsf.ts.event.dispatch.IEventListenerHandle;

public class SourceEventDispatcher
implements IEventDispatcher<ISourceEvent<IEventListenerHandle>, ISourceEventListener, IEventListenerHandle, ISourceEventCallback> {
    private List<ISourceEventListener> m_srcEventListeners = new ArrayList<ISourceEventListener>();
    private boolean m_synchronous_events = false;

    @Override
    public synchronized void addListener(ISourceEventListener listener) {
        this.m_srcEventListeners.add(listener);
    }

    @Override
    public synchronized void removeListener(ISourceEventListener listener) {
        this.m_srcEventListeners.remove(listener);
    }

    @Override
    public void dispatch(ISourceEvent event) {
        for (ISourceEventListener listener : this.getListeners(true)) {
            if (!event.isAppropriateListener(listener)) continue;
            event.dispatch(listener);
        }
    }

    @Override
    public IEventListenerHandle dispatch(ISourceEvent<IEventListenerHandle> event, ISourceEventCallback callback) {
        for (ISourceEventListener listener : this.getListeners(true)) {
            if (!event.isAppropriateListener(listener)) continue;
            this.run(event, listener, callback);
        }
        return null;
    }

    private synchronized List<ISourceEventListener> getListeners(boolean readOnly) {
        if (readOnly) {
            return Collections.unmodifiableList(this.m_srcEventListeners);
        }
        return this.m_srcEventListeners;
    }

    private IEventListenerHandle run(final ISourceEvent<IEventListenerHandle> event, final ISourceEventListener listener, final ISourceEventCallback callback) {
        final IEventListenerHandle.Default handle = new IEventListenerHandle.Default();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    event.dispatch(listener, handle, callback);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.m_synchronous_events) {
            r.run();
        } else {
            Thread t = new Thread(r);
            t.start();
        }
        return handle;
    }

    public void setConfig(TypeSpaceConfig config) {
        this.m_synchronous_events = config.isSynchronousEvents();
    }
}

