/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.ts.index.IDependencyIndexNode;

public class DependencyIndexNode<D>
implements IDependencyIndexNode<D> {
    private final String m_name;
    private List<D> m_dependents;

    public DependencyIndexNode(String name) {
        assert (name != null) : "name cannot be null";
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public synchronized List<D> getDependents() {
        if (this.m_dependents == null || this.m_dependents.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_dependents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependent(D dependent) {
        if (dependent == null) {
            return;
        }
        DependencyIndexNode dependencyIndexNode = this;
        synchronized (dependencyIndexNode) {
            if (this.m_dependents == null) {
                this.m_dependents = new ArrayList<D>();
            }
            this.m_dependents.add(dependent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependents(List<D> dependents) {
        if (dependents == null || dependents.isEmpty()) {
            return;
        }
        DependencyIndexNode dependencyIndexNode = this;
        synchronized (dependencyIndexNode) {
            if (this.m_dependents == null) {
                this.m_dependents = new ArrayList<D>();
            }
            this.m_dependents.addAll(dependents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDependent(D dependent) {
        if (dependent == null || this.m_dependents == null) {
            return;
        }
        DependencyIndexNode dependencyIndexNode = this;
        synchronized (dependencyIndexNode) {
            this.m_dependents.remove(dependent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDependents(List<D> dependents) {
        if (dependents == null || this.m_dependents == null) {
            return;
        }
        DependencyIndexNode dependencyIndexNode = this;
        synchronized (dependencyIndexNode) {
            for (D d : dependents) {
                this.m_dependents.remove(d);
            }
        }
    }

    public String toString() {
        Z z = new Z();
        z.format((Object)("Node: " + this.m_name));
        if (this.m_dependents != null) {
            z.format((Object)"   Dependents:");
            for (D d : this.m_dependents) {
                z.format((Object)("   - " + d.toString()));
            }
        }
        return z.toString();
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        DependencyIndexNode that = (DependencyIndexNode)o;
        if (this.getName() == null && that.getName() != null) {
            return false;
        }
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        String name = this.getName();
        return name == null ? 0 : name.hashCode();
    }
}

