/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.exceptions;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.vjet.dsf.common.exceptions.BaseException;
import org.eclipse.vjet.dsf.common.exceptions.BaseRuntimeException;
import org.eclipse.vjet.dsf.util.JdkUtil;

public final class ExceptionUtilities {
    private ExceptionUtilities() {
    }

    public static void printRecursiveStackTrace(Throwable t, PrintStream ps, Set visited) {
        if (visited == null) {
            visited = new HashSet<Throwable>();
        }
        visited.add(t);
        Throwable chained_t = ExceptionUtilities.getChainedException(t, visited);
        if (chained_t != null) {
            if (chained_t instanceof BaseException) {
                ((BaseException)chained_t).printStackTrace(ps, visited);
            } else if (chained_t instanceof BaseRuntimeException) {
                ((BaseRuntimeException)chained_t).printStackTrace(ps, visited);
            } else {
                ExceptionUtilities.printRecursiveStackTrace(chained_t, ps, visited);
            }
        }
        t.printStackTrace(ps);
    }

    private static Throwable getChainedException(Throwable t, Set visited) {
        Throwable result = null;
        try {
            Method[] meths = t.getClass().getMethods();
            int i = 0;
            while (i < meths.length) {
                Method m = meths[i];
                if (m.getParameterTypes().length <= 0) {
                    Class<?> c = m.getReturnType();
                    if (JdkUtil.forceInit(Throwable.class).isAssignableFrom(c) && !m.getName().equals("fillInStackTrace")) {
                        Throwable r = null;
                        try {
                            r = (Throwable)m.invoke((Object)t, null);
                        }
                        catch (Exception exception) {}
                        if (r != null && !visited.contains(r)) {
                            result = r;
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return result;
    }
}

