/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace;

import java.io.StringWriter;
import org.eclipse.vjet.dsf.common.trace.IDsfTracer;
import org.eclipse.vjet.dsf.common.trace.ITraceWriter;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.common.xml.XmlStreamWriter;

public class XmlTraceWriter
implements ITraceWriter {
    private static final String TAG_CALL = "Call";
    private static final String TAG_LOOP = "Loop";
    private static final String TAG_STEP = "Step";
    private static final String TAG_MSG = "Msg";
    private static final String ATTR_CLASS = "cls";
    private static final String ATTR_METHOD = "mtd";
    private static final String ATTR_GROUP = "grp";
    private static final String ATTR_STATUS = "exit_status";
    private static final String ATTR_IN_MSG = "in";
    private static final String ATTR_EXIT_MSG = "exit_msg";
    private IXmlStreamWriter m_xmlWriter = new XmlStreamWriter(new StringWriter(1024), new IIndenter.Pretty());

    public XmlTraceWriter() {
        this.m_xmlWriter.writeStartElement("V4Trace");
    }

    @Override
    public void handleEnterMethod(int depth, String className, String methodName) {
        this.startEnterTag(className, methodName);
    }

    @Override
    public void handleEnterMethod(int depth, String className, String methodName, String msg) {
        this.startEnterTag(className, methodName);
        if (msg != null && msg.length() > 0) {
            this.m_xmlWriter.writeAttribute(ATTR_IN_MSG, msg);
        }
    }

    @Override
    public void handleExitMethod(int depth, String className, String methodName) {
        this.endEnterTag();
    }

    @Override
    public void handleExitMethod(int depth, String className, String methodName, IDsfTracer.ExitStatus status) {
        if (status != null) {
            this.m_xmlWriter.writeAttribute(ATTR_STATUS, status.toString());
        }
        this.m_xmlWriter.writeEndElement();
    }

    @Override
    public void handleExitMethod(int depth, String className, String methodName, String msg) {
        if (msg != null) {
            this.m_xmlWriter.writeAttribute(ATTR_EXIT_MSG, msg);
        }
        this.m_xmlWriter.writeEndElement();
    }

    @Override
    public void handleExitMethod(int depth, String className, String methodName, IDsfTracer.ExitStatus status, String msg) {
        if (status != null) {
            this.m_xmlWriter.writeAttribute(ATTR_STATUS, status.toString());
        }
        if (msg != null) {
            this.m_xmlWriter.writeAttribute(ATTR_EXIT_MSG, msg);
        }
        this.m_xmlWriter.writeEndElement();
    }

    public void handleObject(int depth, Class objType) {
        this.m_xmlWriter.writeStartElement(objType.getSimpleName());
        this.m_xmlWriter.writeEndElement();
    }

    @Override
    public void handleStartCall(int depth, String className, String methodName) {
        this.startCallTag(className, methodName);
    }

    @Override
    public void handleStartCall(int depth, String className, String methodName, String msg) {
        this.startCallTag(className, methodName);
        if (msg != null) {
            this.m_xmlWriter.writeAttribute(ATTR_IN_MSG, msg);
        }
    }

    @Override
    public void handleEndCall(int depth, String className, String methodName, String msg) {
        if (msg != null) {
            this.m_xmlWriter.writeAttribute(ATTR_EXIT_MSG, msg);
        }
        this.m_xmlWriter.writeEndElement();
    }

    @Override
    public void handleEndCall(int depth, String className, String methodName) {
        this.endCallTag();
    }

    @Override
    public void handleStartLoop(int depth, String group) {
        this.startLoopTag(group);
    }

    @Override
    public void handleLoopStep(int depth, String msg) {
        this.m_xmlWriter.writeStartElement(TAG_STEP);
        this.m_xmlWriter.writeCharacters(msg);
    }

    @Override
    public void handleEndLoop(int depth, String group) {
        this.endLoopTag();
    }

    @Override
    public void handleMsg(int depth, String msg) {
        this.m_xmlWriter.writeStartElement(TAG_MSG);
        this.m_xmlWriter.writeCharacters(msg);
    }

    @Override
    public void reset() {
        this.m_xmlWriter = null;
    }

    public String toString() {
        return this.m_xmlWriter.toString();
    }

    private void startEnterTag(String className, String methodName) {
        this.m_xmlWriter.writeStartElement(className);
        this.m_xmlWriter.writeAttribute(ATTR_METHOD, methodName);
    }

    private void endEnterTag() {
        this.m_xmlWriter.writeEndElement();
    }

    private void startCallTag(String className, String methodName) {
        this.m_xmlWriter.writeStartElement(TAG_CALL);
        if (className != null) {
            this.m_xmlWriter.writeAttribute(ATTR_CLASS, className);
        }
        if (methodName != null) {
            this.m_xmlWriter.writeAttribute(ATTR_METHOD, methodName);
        }
    }

    private void endCallTag() {
        this.m_xmlWriter.writeEndElement();
    }

    private void startLoopTag(String group) {
        this.m_xmlWriter.writeStartElement(TAG_LOOP);
        this.m_xmlWriter.writeAttribute(ATTR_GROUP, group);
    }

    private void endLoopTag() {
        this.m_xmlWriter.writeEndElement();
    }
}

