/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.event.TraceEvent;
import org.eclipse.vjet.dsf.common.trace.event.TraceType;
import org.eclipse.vjet.dsf.common.trace.handler.HandlerId;
import org.eclipse.vjet.dsf.common.trace.handler.ITraceEventHandler;
import org.eclipse.vjet.dsf.common.trace.introspect.DefaultTraceIntrospector;
import org.eclipse.vjet.dsf.common.trace.introspect.ITraceObjectIntrospector;
import org.eclipse.vjet.dsf.common.tracer.TraceUtil;

public class TraceConsoleHandler
implements ITraceEventHandler {
    private static final String ENTER_COLON = "Enter: ";
    private static final String EXIT_COLON = "Exit: ";
    private static final String EXIT = "Exit";
    private static final String CALL_COLON = "Call: ";
    private static final String END_CALL_COLON = "End Call: ";
    private static final String END_CALL = "End Call";
    private static final String LOOP_COLON = "Loop: ";
    private static final String LOOP_STEP = "Step: ";
    private static final String END_LOOP = "End Loop";
    private static final String DOT = ".";
    private static final String TAB = "\t";
    private HandlerId m_handlerId;
    private final Map<Class, ITraceObjectIntrospector> m_inspectors = new HashMap<Class, ITraceObjectIntrospector>(10);
    private DefaultTraceIntrospector m_defaultIntrospector;
    private int m_traceDepth = -1;
    private ListOrderedMap m_stackLabels = new ListOrderedMap();
    private boolean m_active = true;
    private static final String TAG_MSG = "Msg";
    private static final String TAG_LOOP = "Loop";
    private static final String TAG_CALL = "Call";
    private static final String ATTR_METHOD = "mtd";
    private static final String ATTR_OBJ = "obj";

    public TraceConsoleHandler(HandlerId handlerId) {
        if (handlerId == null) {
            DsfExceptionHelper.chuck("handlerId is null");
        }
        this.m_handlerId = handlerId;
    }

    @Override
    public HandlerId getId() {
        return this.m_handlerId;
    }

    @Override
    public void handle(TraceEvent event) {
        TraceType type = event.getType();
        if (TraceType.ENTER_METHOD.equals(type)) {
            this.traceEnterMethod(event);
        } else if (TraceType.EXIT_METHOD.equals(type)) {
            this.traceExitMethod(event);
        }
    }

    @Override
    public void close() {
    }

    private void traceEnterMethod(TraceEvent event) {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        Object caller = event.getSource();
        String clsName = TraceUtil.getClassName(caller);
        String methodName = TraceUtil.getMethodName(caller, t);
        this.push(String.valueOf(clsName) + DOT + methodName);
        this.write(String.valueOf(this.getPadding(this.m_traceDepth)) + ENTER_COLON + clsName + DOT + methodName);
    }

    private void traceExitMethod(TraceEvent event) {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        Object caller = event.getSource();
        String clsName = TraceUtil.getClassName(caller);
        String methodName = TraceUtil.getMethodName(caller, t);
        this.pop(String.valueOf(clsName) + DOT + methodName);
        this.write(String.valueOf(this.getPadding(this.m_traceDepth)) + EXIT);
    }

    private void push(String label) {
        if (label == null || label.trim().length() == 0) {
            DsfExceptionHelper.chuck("label is null");
        }
        ++this.m_traceDepth;
        this.m_stackLabels.put((Object)this.m_traceDepth, (Object)label);
    }

    private void pop(String label) {
        if (this.m_stackLabels.remove(this.m_stackLabels.lastKey()) != null) {
            --this.m_traceDepth;
        }
    }

    private String getPadding(int depth) {
        StringBuffer padding = new StringBuffer();
        int i = 0;
        while (i < depth) {
            padding.append(TAB);
            ++i;
        }
        return padding.toString();
    }

    private void write(String text) {
        System.out.println(text);
    }
}

