/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderHelper {
    private static ThreadLocal<WrappedDocumentBuilderFactory> s_tl_factory = new ThreadLocal<WrappedDocumentBuilderFactory>(){

        @Override
        protected WrappedDocumentBuilderFactory initialValue() {
            return new WrappedDocumentBuilderFactory(DocumentBuilderFactory.newInstance());
        }
    };
    private static final boolean allowsSets = false;
    private static ThreadLocal<WrappedDocumentBuilder> s_tl_builder = new ThreadLocal();

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return s_tl_factory.get();
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return DocumentBuilderHelper.getDocumentBuilder(DocumentBuilderHelper.getDocumentBuilderFactory());
    }

    public static DocumentBuilder getDocumentBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
        WrappedDocumentBuilder builder = s_tl_builder.get();
        if (builder == null) {
            builder = new WrappedDocumentBuilder(factory.newDocumentBuilder());
            s_tl_builder.set(builder);
        }
        return builder;
    }

    private static void checkSets() {
        throw new UnsupportedOperationException();
    }

    private static class WrappedDocumentBuilder
    extends DocumentBuilder {
        private DocumentBuilder m_builder;

        private WrappedDocumentBuilder(DocumentBuilder builder) {
            this.m_builder = builder;
        }

        @Override
        public DOMImplementation getDOMImplementation() {
            return this.m_builder.getDOMImplementation();
        }

        @Override
        public Schema getSchema() {
            return this.m_builder.getSchema();
        }

        @Override
        public boolean isNamespaceAware() {
            return this.m_builder.isNamespaceAware();
        }

        @Override
        public boolean isValidating() {
            return this.m_builder.isValidating();
        }

        @Override
        public boolean isXIncludeAware() {
            return this.m_builder.isXIncludeAware();
        }

        @Override
        public Document newDocument() {
            return this.m_builder.newDocument();
        }

        @Override
        public Document parse(File f) throws SAXException, IOException {
            return this.m_builder.parse(f);
        }

        @Override
        public Document parse(InputSource is) throws SAXException, IOException {
            return this.m_builder.parse(is);
        }

        @Override
        public Document parse(InputStream is, String systemId) throws SAXException, IOException {
            return this.m_builder.parse(is, systemId);
        }

        @Override
        public Document parse(InputStream is) throws SAXException, IOException {
            return this.m_builder.parse(is);
        }

        @Override
        public Document parse(String uri) throws SAXException, IOException {
            return this.m_builder.parse(uri);
        }

        @Override
        public void reset() {
            this.m_builder.reset();
        }

        @Override
        public void setEntityResolver(EntityResolver er) {
            DocumentBuilderHelper.checkSets();
            this.m_builder.setEntityResolver(er);
        }

        @Override
        public void setErrorHandler(ErrorHandler eh) {
            DocumentBuilderHelper.checkSets();
            this.m_builder.setErrorHandler(eh);
        }
    }

    private static class WrappedDocumentBuilderFactory
    extends DocumentBuilderFactory {
        private DocumentBuilderFactory m_factory;

        private WrappedDocumentBuilderFactory(DocumentBuilderFactory factory) {
            this.m_factory = factory;
        }

        @Override
        public Object getAttribute(String name) throws IllegalArgumentException {
            return this.m_factory.getAttribute(name);
        }

        @Override
        public boolean getFeature(String name) throws ParserConfigurationException {
            return this.m_factory.getFeature(name);
        }

        @Override
        public Schema getSchema() {
            return this.m_factory.getSchema();
        }

        @Override
        public boolean isCoalescing() {
            return this.m_factory.isCoalescing();
        }

        @Override
        public boolean isExpandEntityReferences() {
            return this.m_factory.isExpandEntityReferences();
        }

        @Override
        public boolean isIgnoringComments() {
            return this.m_factory.isIgnoringComments();
        }

        @Override
        public boolean isIgnoringElementContentWhitespace() {
            return this.m_factory.isIgnoringElementContentWhitespace();
        }

        @Override
        public boolean isNamespaceAware() {
            return this.m_factory.isNamespaceAware();
        }

        @Override
        public boolean isValidating() {
            return this.m_factory.isValidating();
        }

        @Override
        public boolean isXIncludeAware() {
            return this.m_factory.isXIncludeAware();
        }

        @Override
        public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
            return this.m_factory.newDocumentBuilder();
        }

        @Override
        public void setAttribute(String name, Object value) throws IllegalArgumentException {
            DocumentBuilderHelper.checkSets();
            this.m_factory.setAttribute(name, value);
        }

        @Override
        public void setCoalescing(boolean coalescing) {
            DocumentBuilderHelper.checkSets();
            this.m_factory.setCoalescing(coalescing);
        }

        @Override
        public void setExpandEntityReferences(boolean expandEntityRef) {
            DocumentBuilderHelper.checkSets();
            this.m_factory.setExpandEntityReferences(expandEntityRef);
        }

        @Override
        public void setFeature(String name, boolean value) throws ParserConfigurationException {
            DocumentBuilderHelper.checkSets();
            this.m_factory.setFeature(name, value);
        }

        @Override
        public void setIgnoringComments(boolean ignoreComments) {
            DocumentBuilderHelper.checkSets();
            this.m_factory.setIgnoringComments(ignoreComments);
        }

        @Override
        public void setIgnoringElementContentWhitespace(boolean whitespace) {
            DocumentBuilderHelper.checkSets();
            this.m_factory.setIgnoringElementContentWhitespace(whitespace);
        }

        @Override
        public void setNamespaceAware(boolean awareness) {
            DocumentBuilderHelper.checkSets();
            this.m_factory.setNamespaceAware(awareness);
        }

        @Override
        public void setSchema(Schema schema) {
            DocumentBuilderHelper.checkSets();
            this.m_factory.setSchema(schema);
        }

        @Override
        public void setValidating(boolean validating) {
            DocumentBuilderHelper.checkSets();
            this.m_factory.setValidating(validating);
        }

        @Override
        public void setXIncludeAware(boolean state) {
            DocumentBuilderHelper.checkSets();
            this.m_factory.setXIncludeAware(state);
        }
    }
}

