/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.json;

import java.text.ParseException;
import org.eclipse.vjet.dsf.json.JsonArray;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.json.JsonTokener;

public class CdlConvertor {
    private static String getValue(JsonTokener x) throws ParseException {
        char c;
        while ((c = x.next()) <= ' ' && c != '\u0000') {
        }
        switch (c) {
            case '\u0000': {
                return null;
            }
            case '\"': 
            case '\'': {
                return x.nextString(c);
            }
            case ',': {
                x.back();
                return "";
            }
        }
        x.back();
        return x.nextTo(',');
    }

    public static JsonArray rowToJSONArray(JsonTokener x) throws ParseException {
        char c;
        JsonArray ja = new JsonArray();
        block0: while (true) {
            String value;
            if ((value = CdlConvertor.getValue(x)) == null) {
                return null;
            }
            ja.put(value);
            do {
                if ((c = x.next()) == ',') continue block0;
            } while (c == ' ');
            break;
        }
        if (c == '\n' || c == '\r' || c == '\u0000') {
            return ja;
        }
        throw x.syntaxError("Bad character '" + c + "' (" + c + ").");
    }

    public static JsonObject rowToJSONObject(JsonArray names, JsonTokener x) throws ParseException {
        JsonArray ja = CdlConvertor.rowToJSONArray(x);
        return ja != null ? ja.toJSONObject(names) : null;
    }

    public static JsonArray toJSONArray(String string) throws ParseException {
        return CdlConvertor.toJSONArray(new JsonTokener(string));
    }

    public static JsonArray toJSONArray(JsonTokener x) throws ParseException {
        return CdlConvertor.toJSONArray(CdlConvertor.rowToJSONArray(x), x);
    }

    public static JsonArray toJSONArray(JsonArray names, String string) throws ParseException {
        return CdlConvertor.toJSONArray(names, new JsonTokener(string));
    }

    public static JsonArray toJSONArray(JsonArray names, JsonTokener x) throws ParseException {
        JsonObject jo;
        if (names == null || names.length() == 0) {
            return null;
        }
        JsonArray ja = new JsonArray();
        while ((jo = CdlConvertor.rowToJSONObject(names, x)) != null) {
            ja.put(jo);
        }
        if (ja.length() == 0) {
            return null;
        }
        return ja;
    }

    public static String rowToString(JsonArray ja) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ja.length()) {
            Object o;
            if (i > 0) {
                sb.append(',');
            }
            if ((o = ja.opt(i)) != null) {
                String s = o.toString();
                if (s.indexOf(44) >= 0) {
                    if (s.indexOf(34) >= 0) {
                        sb.append('\'');
                        sb.append(s);
                        sb.append('\'');
                    } else {
                        sb.append('\"');
                        sb.append(s);
                        sb.append('\"');
                    }
                } else {
                    sb.append(s);
                }
            }
            ++i;
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String toString(JsonArray ja) {
        JsonArray names;
        JsonObject jo = ja.optJSONObject(0);
        if (jo != null && (names = jo.names()) != null) {
            return String.valueOf(CdlConvertor.rowToString(names)) + CdlConvertor.toString(names, ja);
        }
        return null;
    }

    public static String toString(JsonArray names, JsonArray ja) {
        if (names == null || names.length() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ja.length()) {
            JsonObject jo = ja.optJSONObject(i);
            if (jo != null) {
                sb.append(CdlConvertor.rowToString(jo.toJSONArray(names)));
            }
            ++i;
        }
        return sb.toString();
    }
}

