/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.json;

import java.text.ParseException;
import java.util.HashMap;
import org.eclipse.vjet.dsf.json.JsonTokener;
import org.eclipse.vjet.dsf.json.XmlConvertor;

public class XmlTokener
extends JsonTokener {
    public static final HashMap<String, Character> entity = new HashMap(8);

    static {
        entity.put("amp", XmlConvertor.AMP);
        entity.put("apos", XmlConvertor.APOS);
        entity.put("gt", XmlConvertor.GT);
        entity.put("lt", XmlConvertor.LT);
        entity.put("quot", XmlConvertor.QUOT);
    }

    public XmlTokener(String s) {
        super(s);
    }

    public Object nextContent() throws ParseException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        if (c == '\u0000') {
            return null;
        }
        if (c == '<') {
            return XmlConvertor.LT;
        }
        StringBuffer sb = new StringBuffer();
        while (true) {
            if (c == '<' || c == '\u0000') {
                this.back();
                return sb.toString().trim();
            }
            if (c == '&') {
                sb.append(this.nextEntity(c));
            } else {
                sb.append(c);
            }
            c = this.next();
        }
    }

    public Object nextEntity(char a) throws ParseException {
        char c;
        StringBuffer sb = new StringBuffer();
        while (Character.isLetter(c = this.next())) {
            sb.append(Character.toLowerCase(c));
        }
        if (c != ';') {
            throw this.syntaxError("Missing ';' in XML entity: &" + sb);
        }
        String s = sb.toString();
        Character e = entity.get(s);
        return e != null ? e : String.valueOf(a) + s + ";";
    }

    public Object nextMeta() throws ParseException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Misshaped meta tag.");
            }
            case '<': {
                return XmlConvertor.LT;
            }
            case '>': {
                return XmlConvertor.GT;
            }
            case '/': {
                return XmlConvertor.SLASH;
            }
            case '=': {
                return XmlConvertor.EQ;
            }
            case '!': {
                return XmlConvertor.BANG;
            }
            case '?': {
                return XmlConvertor.QUEST;
            }
            case '\"': 
            case '\'': {
                char q = c;
                do {
                    if ((c = this.next()) != '\u0000') continue;
                    throw this.syntaxError("Unterminated string.");
                } while (c != q);
                return Boolean.TRUE;
            }
        }
        while (!Character.isWhitespace(c = this.next())) {
            switch (c) {
                case '\u0000': 
                case '!': 
                case '\"': 
                case '\'': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': {
                    this.back();
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.TRUE;
    }

    public Object nextToken() throws ParseException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Misshaped element.");
            }
            case '<': {
                throw this.syntaxError("Misplaced '<'.");
            }
            case '>': {
                return XmlConvertor.GT;
            }
            case '/': {
                return XmlConvertor.SLASH;
            }
            case '=': {
                return XmlConvertor.EQ;
            }
            case '!': {
                return XmlConvertor.BANG;
            }
            case '?': {
                return XmlConvertor.QUEST;
            }
            case '\"': 
            case '\'': {
                char q = c;
                StringBuffer sb = new StringBuffer();
                while (true) {
                    if ((c = this.next()) == '\u0000') {
                        throw this.syntaxError("Unterminated string.");
                    }
                    if (c == q) {
                        return sb.toString();
                    }
                    if (c == '&') {
                        sb.append(this.nextEntity(c));
                        continue;
                    }
                    sb.append(c);
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        while (true) {
            sb.append(c);
            c = this.next();
            if (Character.isWhitespace(c)) {
                return sb.toString();
            }
            switch (c) {
                case '\u0000': 
                case '!': 
                case '/': 
                case '=': 
                case '>': 
                case '?': {
                    this.back();
                    return sb.toString();
                }
                case '\"': 
                case '\'': 
                case '<': {
                    throw this.syntaxError("Bad character in a name.");
                }
            }
        }
    }
}

