/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.resource.ResourceUtil;
import org.eclipse.vjet.dsf.jst.IJstSerializer;
import org.eclipse.vjet.dsf.jst.ts.util.ISdkEnvironment;
import org.eclipse.vjet.vjo.lib.IResourceResolver;

public class ResourceHelper
implements IResourceResolver {
    private static String JS_NATIVE_ANCHOR = "org.eclipse.vjet.jsnative.generated.JsNativeAnchor";
    private static String VJO_JAVA_LIB_ANCHOR = "org.eclipse.vjet.vjo.generated.JstLibAnchor";
    private static String VJO_LIB_ANCHOR = "org.eclipse.vjet.vjolib.generated.VjoLibAnchor";
    private static String JS_NATIVE_GLOBAL = String.valueOf(JS_NATIVE_ANCHOR) + "_GLOBAL";
    private static Map<String, Class> s_anchorClass = new HashMap<String, Class>();
    private static Map<String, String> s_jstLibFileName = new HashMap<String, String>();
    private static ISdkEnvironment s_sdkEnvironment;
    private static List<String> sdkLibs;
    private IJstSerializer m_jstSerializer = null;
    private static ResourceHelper s_instance;

    static {
        sdkLibs = new ArrayList<String>();
        s_instance = new ResourceHelper();
    }

    protected ResourceHelper() {
    }

    public static ResourceHelper getInstance() {
        return s_instance;
    }

    @Override
    public InputStream getJsNativeSerializedStream() {
        try {
            Class anchorClass = this.getAnchorClass(JS_NATIVE_ANCHOR);
            String jsNativeFile = this.getJsBrowserFileName();
            return ResourceUtil.getMandatoryResourceAsStream((Class)anchorClass, (String)jsNativeFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load JsNative resource", e);
        }
    }

    @Override
    public InputStream getJsNativeGlobalSerializedStream() {
        try {
            Class anchorClass = this.getAnchorClass(JS_NATIVE_ANCHOR);
            String jsNativeFile = this.getJsNativeGlobalObjectsFileName();
            return ResourceUtil.getMandatoryResourceAsStream((Class)anchorClass, (String)jsNativeFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load JsNative resource", e);
        }
    }

    @Override
    public InputStream getVjoJavaLibSerializedStream() {
        try {
            Class anchorClass = this.getAnchorClass(VJO_JAVA_LIB_ANCHOR);
            String jstFilename = this.getVjoJstLibFileName();
            return ResourceUtil.getMandatoryResourceAsStream((Class)anchorClass, (String)jstFilename);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load VjoJavaLib resource", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getAnchorClass(String className) {
        Map<String, Class> map;
        Class<?> anchor;
        block11: {
            anchor = s_anchorClass.get(className);
            try {
                if (s_sdkEnvironment == null) break block11;
                anchor = s_sdkEnvironment.getAnchorClass(className);
                sdkLibs.add(className);
                map = s_anchorClass;
                synchronized (map) {
                    s_anchorClass.put(className, anchor);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (anchor == null) {
            try {
                anchor = this.loadClass(className);
                map = s_anchorClass;
                synchronized (map) {
                    s_anchorClass.put(className, anchor);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(String.valueOf(className) + " class doesn't exist");
            }
        }
        return anchor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVjoJstLibFileName() {
        String name = s_jstLibFileName.get(VJO_JAVA_LIB_ANCHOR);
        if (name == null) {
            try {
                Field prefix = this.getAnchorClass(VJO_JAVA_LIB_ANCHOR).getDeclaredField("JST_LIB_FILE_NAME");
                name = prefix.get(null).toString();
                Map<String, String> map = s_jstLibFileName;
                synchronized (map) {
                    s_jstLibFileName.put(VJO_JAVA_LIB_ANCHOR, name);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVjoLibFileName() {
        String name = s_jstLibFileName.get(VJO_LIB_ANCHOR);
        if (name == null) {
            try {
                Field prefix = this.getAnchorClass(VJO_LIB_ANCHOR).getDeclaredField("VJO_API_FILE_NAME");
                name = prefix.get(null).toString();
                Map<String, String> map = s_jstLibFileName;
                synchronized (map) {
                    s_jstLibFileName.put(VJO_LIB_ANCHOR, name);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsBrowserFileName() {
        String name = s_jstLibFileName.get(JS_NATIVE_ANCHOR);
        if (name == null) {
            try {
                Field prefix = this.getAnchorClass(JS_NATIVE_ANCHOR).getDeclaredField("JS_NATIVE_PREFIX");
                Field suffix = this.getAnchorClass(JS_NATIVE_ANCHOR).getDeclaredField("JS_NATIVE_SER_FILE_SUFFIX");
                name = String.valueOf(prefix.get(null).toString()) + suffix.get(null).toString();
                Map<String, String> map = s_jstLibFileName;
                synchronized (map) {
                    s_jstLibFileName.put(JS_NATIVE_ANCHOR, name);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsNativeGlobalObjectsFileName() {
        String name = s_jstLibFileName.get(JS_NATIVE_GLOBAL);
        if (name == null) {
            try {
                Field prefix = this.getAnchorClass(JS_NATIVE_ANCHOR).getDeclaredField("JS_NATIVE_GLOBAL_PREFIX");
                Field suffix = this.getAnchorClass(JS_NATIVE_ANCHOR).getDeclaredField("JS_NATIVE_SER_FILE_SUFFIX");
                name = String.valueOf(prefix.get(null).toString()) + suffix.get(null).toString();
                Map<String, String> map = s_jstLibFileName;
                synchronized (map) {
                    s_jstLibFileName.put(JS_NATIVE_GLOBAL, name);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return name;
    }

    @Override
    public InputStream getVjoLibSerializedStream() {
        try {
            Class anchorClass = this.getAnchorClass(VJO_LIB_ANCHOR);
            String jstFilename = this.getVjoLibFileName();
            return ResourceUtil.getMandatoryResourceAsStream((Class)anchorClass, (String)jstFilename);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load VjoLib resource", e);
        }
    }

    @Override
    public IJstSerializer getJstSerializer() {
        return this.m_jstSerializer;
    }

    public void setJstSerializer(IJstSerializer jstSerializer) {
        this.m_jstSerializer = jstSerializer;
    }

    public ResourceHelper setSdkEnvironment(ISdkEnvironment environment) {
        s_sdkEnvironment = environment;
        return this;
    }

    public static boolean ifLibFromSdk(String className) {
        return sdkLibs.contains(className);
    }

    public static String getStringContent(URL url) {
        InputStream inputStream;
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(url.toExternalForm(), e);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        try {
            try {
                int numBytesXferred;
                while ((numBytesXferred = inputStream.read(buffer)) != -1) {
                    assert (numBytesXferred >= 0);
                    os.write(buffer, 0, numBytesXferred);
                }
            }
            finally {
                inputStream.close();
            }
            String scriptText = os.toString("utf-8");
            return scriptText;
        }
        catch (IOException e) {
            throw new RuntimeException("can not load '" + url.toExternalForm() + "'", e);
        }
    }

    protected Class<?> loadClass(String clsName) throws ClassNotFoundException {
        return Class.forName(clsName);
    }
}

