/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.mod.compiler.ISourceElementRequestor;
import org.eclipse.dltk.mod.compiler.problem.IProblemReporter;
import org.eclipse.dltk.mod.compiler.util.Util;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuffer;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.IOpenable;
import org.eclipse.dltk.mod.core.ISourceElementParser;
import org.eclipse.dltk.mod.core.ISourceElementParserExtension;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.SourceParserUtil;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.internal.core.AbstractSourceModule;
import org.eclipse.dltk.mod.internal.core.AccumulatingProblemReporter;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ExternalSourceModule;
import org.eclipse.dltk.mod.internal.core.ImportContainer;
import org.eclipse.dltk.mod.internal.core.JSSourceModuleElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.OpenableElementInfo;
import org.eclipse.dltk.mod.internal.core.ProjectFragment;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.StructureBuilder;
import org.eclipse.dltk.mod.internal.core.VjoSourceModuleStructureRequestor;
import org.eclipse.dltk.mod.utils.CorePrinter;
import org.eclipse.vjet.eclipse.core.IImportContainer;
import org.eclipse.vjet.eclipse.core.IJSSourceModule;

public class ExternalJSSourceModule
extends ExternalSourceModule
implements IJSSourceModule {
    private IStorage m_storage;

    public ExternalJSSourceModule(ScriptFolder parent, String name, WorkingCopyOwner owner, boolean readOnly, IStorage storage) {
        super(parent, name, owner, readOnly, storage);
        this.m_storage = storage;
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        try {
            IBuffer buffer;
            IStatus status;
            if (!this.isWorkingCopy() && !(status = this.validateSourceModule(underlyingResource)).isOK()) {
                throw this.newModelException(status);
            }
            if (this.preventReopen()) {
                throw this.newNotPresentException();
            }
            JSSourceModuleElementInfo moduleInfo = (JSSourceModuleElementInfo)info;
            if (this.hasBuffer() && (buffer = this.getBufferManager().getBuffer((IOpenable)this)) == null) {
                this.openBuffer(pm, moduleInfo);
            }
            VjoSourceModuleStructureRequestor requestor = new VjoSourceModuleStructureRequestor(this, moduleInfo, newElements);
            String natureId = this.getNatureId();
            if (natureId == null) {
                throw new ModelException((IModelStatus)new ModelStatus(983));
            }
            ISourceElementParser parser = this.getSourceElementParser(natureId);
            if (!this.isReadOnly() && parser instanceof ISourceElementParserExtension) {
                ((ISourceElementParserExtension)parser).setScriptProject(this.getScriptProject());
            }
            parser.setRequestor((ISourceElementRequestor)requestor);
            AccumulatingProblemReporter problemReporter = this.getAccumulatingProblemReporter();
            parser.setReporter((IProblemReporter)problemReporter);
            SourceParserUtil.parseSourceModule((ISourceModule)this, (ISourceElementParser)parser);
            if (problemReporter != null) {
                if (!problemReporter.hasErrors()) {
                    StructureBuilder.build((String)natureId, (ISourceModule)this, (AccumulatingProblemReporter)problemReporter);
                }
                problemReporter.reportToRequestor();
            }
            if (DLTKCore.DEBUG_PRINT_MODEL) {
                System.out.println("Source Module Debug print:");
                CorePrinter printer = new CorePrinter((OutputStream)System.out);
                this.printNode(printer);
                printer.flush();
            }
            if (underlyingResource == null) {
                underlyingResource = this.getResource();
            }
            if (underlyingResource != null) {
                moduleInfo.setTimestamp(((IFile)underlyingResource).getModificationStamp());
            }
            return moduleInfo.isStructureKnown();
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    protected Object createElementInfo() {
        return new JSSourceModuleElementInfo();
    }

    @Override
    public IImportContainer getImportContainer() {
        return new ImportContainer((AbstractSourceModule)this);
    }

    protected ISourceModule getOriginalSourceModule() {
        return new ExternalJSSourceModule((ScriptFolder)this.getParent(), this.getElementName(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, true, this.m_storage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char[] getBufferContent() throws ModelException {
        char[] cArray;
        IFileHandle file = EnvironmentPathUtils.getFile((IPath)this.getPath());
        InputStream stream = null;
        ProjectFragment projectFragment = this.getProjectFragment();
        boolean inProjectArchive = projectFragment.isArchive();
        try {
            char[] content;
            try {
                stream = file != null && file.exists() && !inProjectArchive ? new BufferedInputStream(file.openInputStream(null)) : new BufferedInputStream(this.m_storage.getContents());
            }
            catch (IOException e) {
                throw new ModelException((Throwable)e, 969);
            }
            catch (CoreException e) {
                throw new ModelException((Throwable)e, 969);
            }
            cArray = content = Util.getInputStreamAsCharArray((InputStream)stream, (int)-1, (String)"utf-8");
            if (stream == null) return cArray;
        }
        catch (IOException e) {
            try {
                throw new ModelException((Throwable)e, 985);
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return cArray;
        }
        catch (IOException iOException) {}
        return cArray;
    }

    protected IStorage getStorage() {
        return this.m_storage;
    }
}

