/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.validation.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.vjet.eclipse.core.validation.model.ValidatorDefinition;

public class ValidatorDefinitionFactory {
    public static final String VALIDATORS_EXTENSION_POINT = "org.eclipse.vjet.eclipse.core.validators";
    public static final String VALIDATOR_ELEMENT = "validator";
    private static List<ValidatorDefinition> validatorDefinitions;

    public static synchronized List<ValidatorDefinition> getValidatorDefinitions() {
        if (validatorDefinitions != null) {
            return validatorDefinitions;
        }
        validatorDefinitions = new ArrayList<ValidatorDefinition>();
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint(VALIDATORS_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (VALIDATOR_ELEMENT.equals(element.getName())) {
                    try {
                        ValidatorDefinition validatorDefinition = new ValidatorDefinition(element);
                        validatorDefinitions.add(validatorDefinition);
                    }
                    catch (CoreException e) {
                        DLTKCore.error((String)e.toString(), (Throwable)e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return validatorDefinitions;
    }

    public static ValidatorDefinition getValidatorDefinition(String validatorId) {
        for (ValidatorDefinition validator : ValidatorDefinitionFactory.getValidatorDefinitions()) {
            if (!validator.getID().equals(validatorId)) continue;
            return validator;
        }
        return null;
    }
}

