/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.ICalleeProcessor;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.internal.core.VjoCalleeAnalyzerVisitor;

public class VjoCalleeProcessor
implements ICalleeProcessor {
    protected static final int EXACT_RULE = 8;
    private IMethod method;

    public VjoCalleeProcessor(IMethod method, IProgressMonitor monitor, IDLTKSearchScope scope) {
        this.method = method;
    }

    public Map doOperation() {
        try {
            if (this.method.exists()) {
                IJstType jstType = this.getJstType(this.method);
                IJstMethod jstMethod = CodeassistUtils.getJstMethod(jstType, this.method);
                if (jstType != null && jstMethod != null) {
                    VjoCalleeAnalyzerVisitor visitor = new VjoCalleeAnalyzerVisitor(this.method, jstType, (IProgressMonitor)new NullProgressMonitor());
                    jstMethod.accept((IJstNodeVisitor)visitor);
                    return visitor.getCallees();
                }
            }
        }
        catch (Exception e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return new HashMap(0);
    }

    private IJstType getJstType(IMethod method2) throws ModelException {
        ISourceModule sourceModule = method2.getSourceModule();
        return ((IVjoSourceModule)sourceModule).getJstType();
    }
}

