/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.ui.adapters;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vjet.core.codegen.bootstrap.IJava2JsCodeGenInput;
import org.eclipse.vjet.eclipse.javalaunch.utils.SourcePathUtil;
import org.eclipse.vjet.eclipse.javatojs.ui.Java2JsPlugin;

public class Java2JsInput
implements IJava2JsCodeGenInput,
IAdaptable {
    public static final String CONFIG_FILE_NAME = "java2js.properties";
    private IResource resource;

    public Java2JsInput(IResource resource) {
        this.resource = resource;
    }

    public IResource getResource() {
        return this.resource;
    }

    public URL getJava2JsConfig() {
        IFile file = this.resource.getProject().getFile(CONFIG_FILE_NAME);
        if (file != null && file.exists()) {
            try {
                return file.getLocationURI().toURL();
            }
            catch (MalformedURLException e) {
                Java2JsPlugin.logException(e);
            }
        }
        return Java2JsPlugin.getDefault().getDefaultJava2JsConfig();
    }

    public Properties getJava2JsProperties() {
        IFile file = this.resource.getProject().getFile(CONFIG_FILE_NAME);
        if (file != null && file.exists()) {
            try {
                Properties properties = new Properties();
                properties.load(file.getContents());
                return properties;
            }
            catch (IOException e) {
                Java2JsPlugin.logException(e);
            }
            catch (CoreException e) {
                Java2JsPlugin.logException((Exception)((Object)e));
            }
        }
        return Java2JsPlugin.getDefault().getDefaultJava2JsConfigProperties();
    }

    public URL getProject() {
        URL url = null;
        try {
            url = this.resource.getProject().getLocationURI().toURL();
        }
        catch (MalformedURLException e) {
            Java2JsPlugin.logException(e);
        }
        return url;
    }

    public URL getUrl() {
        URL url = null;
        try {
            url = this.resource.getLocationURI().toURL();
        }
        catch (MalformedURLException e) {
            Java2JsPlugin.logException(e);
        }
        return url;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getJavaSourcePath() {
        try {
            return SourcePathUtil.getSourcePathString((IProject)this.resource.getProject());
        }
        catch (CoreException e) {
            Java2JsPlugin.logException((Exception)((Object)e));
            return null;
        }
    }
}

