/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.ui.commands.jar;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSigner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.vjet.eclipse.javatojs.ui.commands.jar.JarDictionaryUtil;

public class JarClassData {
    String m_zipEntryName;
    byte[] m_zipEntryData = null;
    CodeSigner[] m_codeSigners;
    URL m_baseUrl;

    public JarClassData(URL base, String zipEntryName, CodeSigner[] codeSigners) {
        this.m_zipEntryName = zipEntryName;
        this.m_codeSigners = codeSigners;
        this.m_baseUrl = base;
    }

    public URL getUrl() {
        try {
            String newUrl = "jar:" + this.m_baseUrl.toExternalForm() + "!/" + this.m_zipEntryName;
            URL url = new URL(newUrl);
            return url;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("name");
        }
    }

    public byte[] getZipEntryData() {
        return this.m_zipEntryData;
    }

    public void setZipEntryData(byte[] entryData) {
        this.m_zipEntryData = entryData;
    }

    public String getZipEntryName() {
        return this.m_zipEntryName;
    }

    public CodeSigner[] getCodeSigners() {
        return this.m_codeSigners;
    }

    public URL getCodeSourceURL() {
        return this.m_baseUrl;
    }

    public byte[] getBytes() throws IOException, ClassNotFoundException {
        if (this.m_zipEntryData != null) {
            return this.m_zipEntryData;
        }
        JarFile jarFile = new JarFile(this.m_baseUrl.getPath());
        JarEntry jarEntry = (JarEntry)jarFile.getEntry(this.m_zipEntryName);
        if (jarEntry == null) {
            throw new ClassNotFoundException(this.m_zipEntryName);
        }
        InputStream jarEntryStream = jarFile.getInputStream(jarEntry);
        this.m_zipEntryData = JarDictionaryUtil.getBytes(jarEntryStream, (int)jarEntry.getSize());
        jarEntryStream.close();
        jarFile.close();
        return this.m_zipEntryData;
    }
}

