/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.vjet.eclipse.core.ClassPathUtils;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.launching.VjetLaunchingPlugin;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;

public class LauncherUtil {
    public static final String TEMP_VJET_LAUNCH = "c:\\vjetl";
    public static final String EXCLAMATION_MARK = "!";
    public static final String SCHEME_FILE = "file";
    public static final String SCHEME_JAR = "jar";
    public static final String SCHEME_ZIP = "zip";

    private static void copyClasspathFiles(Set<String> classpath) {
        HashSet<String> libSet = new HashSet<String>(20000);
        System.out.println("Classpath:");
        try {
            File destDir = new File(TEMP_VJET_LAUNCH);
            destDir.mkdirs();
            for (String path : classpath) {
                System.out.println("\t" + path);
                File inputFile = new File(path);
                if (libSet.contains(inputFile.getName()) || !path.endsWith(".jar")) continue;
                LauncherUtil.copyFile(destDir, inputFile);
                libSet.add(inputFile.getName());
            }
        }
        catch (Exception e) {
            VjetPlugin.error((String)"Failed to copy the jars to destination : c:\\vjetl", (Throwable)e, (int)4);
        }
    }

    public static String[] getOptimizedClasspath(IJavaProject javaProject) {
        try {
            Set paths = ClassPathUtils.getProjectDependencyUrls((IJavaProject)javaProject);
            boolean isJava6 = LauncherUtil.isJava6Vm(null);
            if (!isJava6) {
                LauncherUtil.copyClasspathFiles(paths);
            }
            String[] optimizedClasspath = LauncherUtil.getOptimizedClasspath(paths, isJava6, TEMP_VJET_LAUNCH);
            return optimizedClasspath;
        }
        catch (CoreException e) {
            VjetPlugin.error((String)"Failed to get optimized class path ", (Throwable)e, (int)4);
            return new String[0];
        }
        catch (MalformedURLException e) {
            VjetPlugin.error((String)"Failed to get optimized class path ", (Throwable)e, (int)4);
            return new String[0];
        }
    }

    public static Set<String> getRawClasspath(IJavaProject javaProject) throws JavaModelException {
        LinkedHashMap<String, IJavaProject> transitiveClosureProjectList = new LinkedHashMap<String, IJavaProject>();
        LauncherUtil.getTransitiveClosureProjectDependnecyList(javaProject, transitiveClosureProjectList);
        LinkedHashSet<String> jars = new LinkedHashSet<String>();
        LauncherUtil.getProjectDependentJars(jars, javaProject.getRawClasspath());
        for (IJavaProject project : transitiveClosureProjectList.values()) {
            LauncherUtil.getProjectDependentJars(jars, project.getRawClasspath());
        }
        return jars;
    }

    public static String[] getOptimizedClasspath(Set<String> classpath, boolean isJava6, String rootDir) throws CoreException {
        StringBuilder m_vmArg = new StringBuilder(20000);
        try {
            if (isJava6) {
                LauncherUtil.getJava6Classpath(classpath, m_vmArg);
            } else {
                LauncherUtil.getJava5Classpath(classpath, rootDir, m_vmArg);
            }
        }
        catch (Exception e) {
            VjetPlugin.error((String)"Failed to get optimized class path", (Throwable)e, (int)4);
        }
        return m_vmArg.toString().split(";");
    }

    public static String getOptimizedClasspathArg(Set<String> classpath, boolean isJava6, String rootDir) throws CoreException {
        StringBuilder m_vmArg = new StringBuilder(20000);
        try {
            if (isJava6) {
                m_vmArg.append("-cp \"");
                LauncherUtil.getJava6Classpath(classpath, m_vmArg);
            } else {
                m_vmArg.append("-Djava.class.path=\"");
                LauncherUtil.getJava5Classpath(classpath, rootDir, m_vmArg);
            }
            m_vmArg.append("\"");
        }
        catch (Exception e) {
            VjetPlugin.error((String)"Failed to get optimized class path", (Throwable)e, (int)4);
        }
        return m_vmArg.toString();
    }

    public static void getTransitiveClosureProjectDependnecyList(IJavaProject javaProject, Map<String, IJavaProject> transitiveClosureProjectList) throws JavaModelException {
        IClasspathEntry[] classPathEntries = javaProject.getResolvedClasspath(true);
        if (classPathEntries != null) {
            IClasspathEntry[] iClasspathEntryArray = classPathEntries;
            int n = classPathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IResource classPathProject;
                IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
                if (classPathEntry.getEntryKind() == 2 && (classPathProject = ResourcesPlugin.getWorkspace().getRoot().findMember(classPathEntry.getPath())) != null && !transitiveClosureProjectList.containsKey(classPathProject.getName())) {
                    IJavaProject subJavaProject = LauncherUtil.getJavaProject(classPathProject);
                    transitiveClosureProjectList.put(classPathProject.getName(), subJavaProject);
                    LauncherUtil.getTransitiveClosureProjectDependnecyList(subJavaProject, transitiveClosureProjectList);
                }
                ++n2;
            }
        }
    }

    public static IJavaProject getJavaProject(IResource resource) {
        if (resource instanceof IProject) {
            return LauncherUtil.getJavaProject((IProject)resource);
        }
        return null;
    }

    public static IJavaProject getJavaProject(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return javaProject.exists() ? javaProject : null;
    }

    private static void getProjectDependentJars(Set<String> jars, IClasspathEntry[] classPathEntries) {
        if (classPathEntries != null) {
            IClasspathEntry[] iClasspathEntryArray = classPathEntries;
            int n = classPathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                String s;
                IPath path;
                IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
                if (!(classPathEntry.getEntryKind() != 1 && classPathEntry.getEntryKind() != 4 || (path = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classPathEntry).getPath()) == null || StringUtils.isBlankOrEmpty((String)(s = path.toString())))) {
                    jars.add(s);
                }
                ++n2;
            }
        }
    }

    private static void getJava6Classpath(Set<String> classpath, StringBuilder m_vmArg) {
        HashSet<String> parentFolders = new HashSet<String>(1000);
        for (String path : classpath) {
            File inputFile = new File(path);
            String classPathEntry = "";
            if (inputFile.isFile()) {
                File parentFolder = inputFile.getParentFile();
                if (parentFolders.contains(parentFolder.getAbsolutePath())) continue;
                classPathEntry = String.valueOf(parentFolder.getAbsolutePath()) + "\\*;";
                parentFolders.add(parentFolder.getAbsolutePath());
            } else {
                classPathEntry = String.valueOf(path) + ";";
            }
            m_vmArg.append(classPathEntry);
        }
    }

    private static void getJava5Classpath(Set<String> classpath, String rootDir, StringBuilder m_vmArg) {
        HashSet<String> libSet = new HashSet<String>(1000);
        for (String path : classpath) {
            File inputFile = new File(path);
            String classPathEntry = "";
            if (libSet.contains(inputFile.getName())) continue;
            if (path.contains(".jar")) {
                classPathEntry = String.valueOf(rootDir) + "\\" + inputFile.getName() + ";";
                libSet.add(inputFile.getName());
            } else {
                classPathEntry = String.valueOf(path) + ";";
            }
            m_vmArg.append(classPathEntry);
        }
    }

    private static void copyFile(File destDir, File inputFile) throws Exception {
        IFileSystem fs = EFS.getLocalFileSystem();
        File outputFile = new File(destDir, inputFile.getName());
        if (inputFile.lastModified() != outputFile.lastModified()) {
            long inputDateTime = inputFile.lastModified();
            IFileStore source = fs.getStore(inputFile.toURI());
            IFileStore dest = fs.getStore(outputFile.toURI());
            source.copy(dest, 2, (IProgressMonitor)new NullProgressMonitor());
            outputFile.setLastModified(inputDateTime);
        }
    }

    public static boolean isJava6Vm(ILaunchConfiguration configuration) throws CoreException {
        boolean isJava6 = false;
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.contains("1.6")) {
            isJava6 = true;
        }
        return isJava6;
    }

    public static ZipEntryStorage createZipEntryFile(final URI uri) throws ZipException, IOException {
        URI tempURI = uri;
        String schemeSpecificPart = null;
        while ((tempURI = URI.create(schemeSpecificPart = tempURI.getSchemeSpecificPart())).getScheme() != null) {
        }
        int pos = schemeSpecificPart.indexOf(EXCLAMATION_MARK);
        if (pos == -1) {
            return null;
        }
        String[] paths = schemeSpecificPart.split(EXCLAMATION_MARK);
        if (paths.length != 2) {
            return null;
        }
        File jarFile = new File(paths[0]);
        ZipEntry zipEntry = new ZipEntry(paths[1].substring(1));
        ZipFile zipFile = new ZipFile(jarFile);
        return new ZipEntryStorage(zipFile, zipEntry){

            public IPath getFullPath() {
                return new Path(uri.toString());
            }
        };
    }

    public static boolean isFileScheme(String scheme) {
        return SCHEME_FILE.equals(scheme);
    }

    public static boolean isZipScheme(String scheme) {
        return SCHEME_JAR.equals(scheme) || SCHEME_ZIP.equals(scheme);
    }

    public static String[] getOptimizedBuildpath(IScriptProject scriptProject) {
        try {
            Set urlsString = ClassPathUtils.getProjectDependencyUrls((IScriptProject)scriptProject);
            boolean isJava6 = LauncherUtil.isJava6Vm(null);
            if (!isJava6) {
                LauncherUtil.copyClasspathFiles(urlsString);
            }
            return LauncherUtil.getOptimizedClasspath(urlsString, isJava6, TEMP_VJET_LAUNCH);
        }
        catch (Exception e) {
            VjetLaunchingPlugin.error(e.getLocalizedMessage(), e);
            return new String[0];
        }
    }
}

