/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.compiler.env.CompilerSourceCode;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.mod.internal.ui.editor.semantic.highlighting.SemanticHighlightingPresenter;
import org.eclipse.dltk.mod.ui.editor.highlighting.HighlightedPosition;
import org.eclipse.dltk.mod.ui.editor.highlighting.HighlightingStyle;
import org.eclipse.dltk.mod.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.dltk.mod.ui.text.IColorManager;
import org.eclipse.dltk.mod.ui.text.IColorManagerExtension;
import org.eclipse.dltk.mod.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.mod.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.mod.ui.text.ScriptTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting.VjoSemanticHighlighting;
import org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting.VjoSemanticHighlightingReconciler;
import org.eclipse.vjet.eclipse.internal.ui.editor.semantic.highlighting.VjoSemanticHighlightings;

public class VjoSemanticHighlightingManager
implements IPropertyChangeListener {
    private SemanticHighlightingPresenter fPresenter;
    private VjoSemanticHighlightingReconciler fReconciler;
    private VjoSemanticHighlighting[] fSemanticHighlightings;
    private HighlightingStyle[] fHighlightings;
    private ScriptEditor fEditor;
    private ScriptSourceViewer fSourceViewer;
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private ScriptSourceViewerConfiguration fConfiguration;
    private ScriptPresentationReconciler fPresentationReconciler;
    private HighlightedRange[][] fHardcodedRanges;

    public void install(ScriptEditor editor, ScriptSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore) {
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        this.fColorManager = colorManager;
        this.fPreferenceStore = preferenceStore;
        ScriptTextTools textTools = this.getTextTools();
        if (textTools != null) {
            this.fSemanticHighlightings = (VjoSemanticHighlighting[])textTools.getSemanticHighlightings();
            this.fConfiguration = textTools.createSourceViewerConfiguraton(preferenceStore, (ITextEditor)editor);
        }
        if (this.fEditor != null) {
            Assert.isNotNull((Object)this.fConfiguration);
            IPresentationReconciler presReconciler = this.fConfiguration.getPresentationReconciler((ISourceViewer)sourceViewer);
            this.fPresentationReconciler = presReconciler instanceof ScriptPresentationReconciler ? (ScriptPresentationReconciler)presReconciler : null;
        } else {
            this.fConfiguration = null;
            this.fPresentationReconciler = null;
        }
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.isEnabled()) {
            this.enable();
        }
    }

    public void install(ScriptSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore) {
        this.install(null, sourceViewer, colorManager, preferenceStore);
    }

    public void install(ScriptSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore, HighlightedRange[][] hardcodedRanges) {
        this.fHardcodedRanges = hardcodedRanges;
        this.install(null, sourceViewer, colorManager, preferenceStore);
    }

    private void enable() {
        this.initializeHighlightings();
        this.fPresenter = new SemanticHighlightingPresenter();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        if (this.fEditor != null) {
            this.fReconciler = new VjoSemanticHighlightingReconciler();
            this.fReconciler.install(this.fEditor, (ISourceViewer)this.fSourceViewer, this.fPresenter, this.fSemanticHighlightings, this.fHighlightings);
        } else {
            this.fPresenter.updatePresentation(null, this.createHardcodedPositions(), new HighlightedPosition[0]);
        }
    }

    public HighlightingStyle getHighlighting(int pos) {
        return this.fHighlightings[pos];
    }

    public void uninstall() {
        this.disable();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
        this.fSemanticHighlightings = null;
        this.fEditor = null;
        this.fSourceViewer = null;
        this.fColorManager = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
        this.fHardcodedRanges = null;
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
        if (this.fHighlightings != null) {
            this.disposeHighlightings();
        }
    }

    private boolean isEnabled() {
        return VjoSemanticHighlightings.isEnabled(this.fPreferenceStore);
    }

    private void initializeHighlightings() {
        this.fSemanticHighlightings = VjoSemanticHighlightings.getSemanticHighlightings();
        this.fHighlightings = new HighlightingStyle[this.fSemanticHighlightings.length];
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            String underlineKey;
            String strikethroughKey;
            VjoSemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            String colorKey = VjoSemanticHighlightings.getColorPreferenceKey(semanticHighlighting);
            this.addColor(colorKey);
            String boldKey = VjoSemanticHighlightings.getBoldPreferenceKey(semanticHighlighting);
            int style = this.fPreferenceStore.getBoolean(boldKey) ? 1 : 0;
            String italicKey = VjoSemanticHighlightings.getItalicPreferenceKey(semanticHighlighting);
            if (this.fPreferenceStore.getBoolean(italicKey)) {
                style |= 2;
            }
            if (this.fPreferenceStore.getBoolean(strikethroughKey = VjoSemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting))) {
                style |= 0x20000000;
            }
            if (this.fPreferenceStore.getBoolean(underlineKey = VjoSemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting))) {
                style |= 0x40000000;
            }
            boolean isEnabled = this.fPreferenceStore.getBoolean(VjoSemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting));
            this.fHighlightings[i] = new HighlightingStyle(new TextAttribute(this.fColorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey)), null, style), isEnabled, (SemanticHighlighting)semanticHighlighting);
            ++i;
        }
    }

    protected ScriptTextTools getTextTools() {
        return this.fEditor != null ? this.fEditor.getTextTools() : null;
    }

    private void disposeHighlightings() {
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            this.removeColor(VjoSemanticHighlightings.getColorPreferenceKey(this.fSemanticHighlightings[i]));
            ++i;
        }
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.handlePropertyChangeEvent(event);
    }

    private HighlightedPosition[] createHardcodedPositions() {
        ArrayList<HighlightedPosition> positions = new ArrayList<HighlightedPosition>();
        int i = 0;
        while (i < this.fHardcodedRanges.length) {
            HighlightedRange range = null;
            HighlightingStyle hl = null;
            int j = 0;
            while (j < this.fHardcodedRanges[i].length) {
                hl = this.getHighlighting(this.fHardcodedRanges[i][j].getKey());
                if (hl.isEnabled()) {
                    range = this.fHardcodedRanges[i][j];
                    break;
                }
                ++j;
            }
            if (range != null) {
                positions.add(this.fPresenter.createHighlightedPosition(range.getOffset(), range.getLength(), hl));
            }
            ++i;
        }
        return positions.toArray(new HighlightedPosition[positions.size()]);
    }

    private HighlightingStyle getHighlighting(String key) {
        int i = 0;
        while (i < this.fSemanticHighlightings.length) {
            VjoSemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            if (key.equals(semanticHighlighting.getPreferenceKey())) {
                return this.fHighlightings[i];
            }
            ++i;
        }
        return null;
    }

    private void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fPreferenceStore == null) {
            return;
        }
        if (this.fConfiguration != null) {
            this.fConfiguration.handlePropertyChangeEvent(event);
        }
        if (VjoSemanticHighlightings.affectsEnablement(this.fPreferenceStore, event)) {
            if (this.isEnabled()) {
                this.enable();
            } else {
                this.disable();
            }
        }
        if (!this.isEnabled()) {
            return;
        }
        boolean refreshNeeded = false;
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            VjoSemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            String colorKey = VjoSemanticHighlightings.getColorPreferenceKey(semanticHighlighting);
            if (colorKey.equals(event.getProperty())) {
                this.adaptToTextForegroundChange(this.fHighlightings[i], event);
                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                refreshNeeded = true;
            } else {
                String boldKey = VjoSemanticHighlightings.getBoldPreferenceKey(semanticHighlighting);
                if (boldKey.equals(event.getProperty())) {
                    this.adaptToTextStyleChange(this.fHighlightings[i], event, 1);
                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                    refreshNeeded = true;
                } else {
                    String italicKey = VjoSemanticHighlightings.getItalicPreferenceKey(semanticHighlighting);
                    if (italicKey.equals(event.getProperty())) {
                        this.adaptToTextStyleChange(this.fHighlightings[i], event, 2);
                        this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                        refreshNeeded = true;
                    } else {
                        String strikethroughKey = VjoSemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting);
                        if (strikethroughKey.equals(event.getProperty())) {
                            this.adaptToTextStyleChange(this.fHighlightings[i], event, 0x20000000);
                            this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                            refreshNeeded = true;
                        } else {
                            String underlineKey = VjoSemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting);
                            if (underlineKey.equals(event.getProperty())) {
                                this.adaptToTextStyleChange(this.fHighlightings[i], event, 0x40000000);
                                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                refreshNeeded = true;
                            } else {
                                String enabledKey = VjoSemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting);
                                if (enabledKey.equals(event.getProperty())) {
                                    this.adaptToEnablementChange(this.fHighlightings[i], event);
                                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                    refreshNeeded = true;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (refreshNeeded && this.fReconciler != null) {
            this.fReconciler.refresh();
        }
    }

    private void adaptToEnablementChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        Object value = event.getNewValue();
        boolean eventValue = value instanceof Boolean ? (Boolean)value : "true".equals(value);
        highlighting.setEnabled(eventValue);
    }

    private void adaptToTextForegroundChange(HighlightingStyle highlighting, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            String property = event.getProperty();
            Color color = this.fColorManager.getColor(property);
            if ((color == null || !rgb.equals((Object)color.getRGB())) && this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)this.fColorManager;
                ext.unbindColor(property);
                ext.bindColor(property, rgb);
                color = this.fColorManager.getColor(property);
            }
            TextAttribute oldAttr = highlighting.getTextAttribute();
            highlighting.setTextAttribute(new TextAttribute(color, oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToTextStyleChange(HighlightingStyle highlighting, PropertyChangeEvent event, int styleAttribute) {
        boolean activeValue;
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        TextAttribute oldAttr = highlighting.getTextAttribute();
        boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            highlighting.setTextAttribute(new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
        }
    }

    private void addColor(String colorKey) {
        if (this.fColorManager != null && colorKey != null && this.fColorManager.getColor(colorKey) == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
            if (this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)this.fColorManager;
                ext.unbindColor(colorKey);
                ext.bindColor(colorKey, rgb);
            }
        }
    }

    private void removeColor(String colorKey) {
        if (this.fColorManager instanceof IColorManagerExtension) {
            ((IColorManagerExtension)this.fColorManager).unbindColor(colorKey);
        }
    }

    public VjoSemanticHighlightingReconciler getReconciler() {
        return this.fReconciler;
    }

    public static class HighlightedRange
    extends Region {
        private String fKey;

        public HighlightedRange(int offset, int length, String key) {
            super(offset, length);
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public boolean equals(Object o) {
            return super.equals(o) && o instanceof HighlightedRange && this.fKey.equals(((HighlightedRange)((Object)o)).getKey());
        }

        public int hashCode() {
            return super.hashCode() | this.fKey.hashCode();
        }
    }

    private static class SourceCode
    extends CompilerSourceCode {
        public SourceCode(String source) {
            super(source);
        }
    }
}

