/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.actions;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;
import org.eclipse.vjet.eclipse.ui.actions.nature.AddVjoNaturePolicyManager;
import org.eclipse.vjet.eclipse.ui.actions.nature.IAddVjoNaturePolicy;

public class AddVjoNatureAction
implements IExecutableExtension,
IObjectActionDelegate {
    ISelection selection;

    public void run(IAction action) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AddVjoNatureAction.this.doAddNature();
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            VjetUIPlugin.log((Exception)((Object)e));
        }
    }

    private void doAddNature() {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
        Object[] selectionElements = structuredSelection.toArray();
        int i = 0;
        while (i < selectionElements.length) {
            IAdaptable adaptable;
            IProject project;
            Object selectionElement = selectionElements[i];
            if (selectionElement instanceof IAdaptable && (project = (IProject)(adaptable = (IAdaptable)selectionElement).getAdapter(IProject.class)) != null) {
                IAddVjoNaturePolicy policy = AddVjoNaturePolicyManager.getInstance().getPolicy(project);
                policy.addVjoNature(project);
            }
            ++i;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        IAdaptable adaptable = (IAdaptable)((IStructuredSelection)selection).getFirstElement();
        if (adaptable == null) {
            return;
        }
        IProject project = (IProject)adaptable.getAdapter(IProject.class);
        boolean hasVJONature = this.hasVJONature(project);
        boolean hasVJOBuilder = this.hasVJOBuilder(project);
        if (hasVJONature && hasVJOBuilder) {
            action.setEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasVJONature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] buildCommands = description.getBuildSpec();
            int i = 0;
            while (true) {
                if (i >= buildCommands.length) {
                    return false;
                }
                if ("org.eclipse.vjet.eclipse.core.builder".equals(buildCommands[i].getBuilderName())) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean hasVJOBuilder(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            return description.hasNature("org.eclipse.vjet.core.nature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

