/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.vjet.eclipse.formatter.CodeFormatterUtil;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class JavaScriptFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
        if (document == null || partition == null) return;
        Map partitioners = null;
        try {
            try {
                TextEdit edit = CodeFormatterUtil.reformat((int)8, (String)document.get(), (int)partition.getOffset(), (int)partition.getLength(), (int)0, (String)TextUtilities.getDefaultLineDelimiter((IDocument)document), (Map)this.getPreferences());
                if (edit == null) return;
                if (edit.getChildrenSize() > 20) {
                    partitioners = TextUtilities.removeDocumentPartitioners((IDocument)document);
                }
                edit.apply(document);
                return;
            }
            catch (MalformedTreeException exception) {
                VjetUIPlugin.log((Exception)((Object)exception));
                if (partitioners == null) return;
                TextUtilities.addDocumentPartitioners((IDocument)document, partitioners);
                return;
            }
            catch (BadLocationException exception) {
                VjetUIPlugin.log((Exception)((Object)exception));
                if (partitioners == null) return;
                TextUtilities.addDocumentPartitioners((IDocument)document, partitioners);
                return;
            }
        }
        finally {
            if (partitioners != null) {
                TextUtilities.addDocumentPartitioners((IDocument)document, partitioners);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }
}

