/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.core.infer;

import java.util.ArrayList;
import org.eclipse.mod.wst.jsdt.core.infer.DefaultInferrenceProvider;
import org.eclipse.mod.wst.jsdt.core.infer.IInferenceFile;
import org.eclipse.mod.wst.jsdt.core.infer.InferEngine;
import org.eclipse.mod.wst.jsdt.core.infer.InferrenceProvider;
import org.eclipse.mod.wst.jsdt.core.infer.InferrenceSupportExtension;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;

public class InferrenceManagerDiet {
    public static final String EXTENSION_POINT = "inferrenceSupport";
    protected static final String TAG_INFERENCE_PROVIDER = "inferenceProvider";
    protected static final String ATTR_INFERENGINE_CLASS = "class";
    private static InferrenceManagerDiet instance = null;
    private InferrenceSupportExtension[] extensions;

    public static InferrenceManagerDiet getInstance() {
        if (instance == null) {
            instance = new InferrenceManagerDiet();
        }
        return instance;
    }

    public InferrenceProvider[] getInferenceProviders() {
        ArrayList<InferrenceProvider> extProviders = new ArrayList<InferrenceProvider>();
        extProviders.add(new DefaultInferrenceProvider());
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].inferProvider != null) {
                extProviders.add(this.extensions[i].inferProvider);
            }
            ++i;
        }
        return extProviders.toArray(new InferrenceProvider[extProviders.size()]);
    }

    public InferrenceProvider[] getInferenceProviders(IInferenceFile script) {
        InferrenceProvider[] inferenceProviders = this.getInferenceProviders();
        ArrayList<InferrenceProvider> extProviders = new ArrayList<InferrenceProvider>();
        int i = 0;
        while (i < inferenceProviders.length) {
            int applies = inferenceProviders[i].applysTo(script);
            switch (applies) {
                case 3: {
                    extProviders.add(inferenceProviders[i]);
                    break;
                }
                case 1: {
                    InferrenceProvider[] thisProvider = new InferrenceProvider[]{inferenceProviders[i]};
                    return thisProvider;
                }
            }
            ++i;
        }
        return extProviders.toArray(new InferrenceProvider[extProviders.size()]);
    }

    public InferEngine[] getInferenceEngines(CompilationUnitDeclaration script) {
        InferrenceProvider[] inferenceProviders = this.getInferenceProviders();
        if (inferenceProviders.length == 1) {
            return this.getSingleEngine(inferenceProviders[0]);
        }
        ArrayList<InferEngine> extEngines = new ArrayList<InferEngine>();
        int i = 0;
        while (i < inferenceProviders.length) {
            if (script.compilationResult != null && script.compilationResult.compilationUnit != null) {
                String inferenceID = script.compilationResult.compilationUnit.getInferenceID();
                if (inferenceProviders[i].getID().equals(inferenceID)) {
                    return this.getSingleEngine(inferenceProviders[i]);
                }
            }
            int applies = inferenceProviders[i].applysTo(script);
            switch (applies) {
                case 3: {
                    InferEngine eng = inferenceProviders[i].getInferEngine();
                    eng.appliesTo = 3;
                    eng.inferenceProvider = inferenceProviders[i];
                    extEngines.add(eng);
                    break;
                }
                case 1: {
                    return this.getSingleEngine(inferenceProviders[i]);
                }
            }
            ++i;
        }
        return extEngines.toArray(new InferEngine[extEngines.size()]);
    }

    private InferEngine[] getSingleEngine(InferrenceProvider provider) {
        InferEngine engine = provider.getInferEngine();
        engine.appliesTo = 1;
        engine.inferenceProvider = provider;
        InferEngine[] thisEngine = new InferEngine[]{engine};
        return thisEngine;
    }
}

