/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IBinaryExpression;
import org.eclipse.mod.wst.jsdt.core.ast.IExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;

public class BinaryExpression
extends OperatorExpression
implements IBinaryExpression {
    public Expression left;
    public Expression right;
    public Constant optimizedBooleanConstant;

    public BinaryExpression(Expression left, Expression right, int operator) {
        this.left = left;
        this.right = right;
        this.bits |= operator << 6;
        this.sourceStart = left.sourceStart;
        this.sourceEnd = right.sourceEnd;
    }

    public void computeConstant(BlockScope scope, int leftId, int rightId) {
        if (this.left.constant == null) {
            this.left.constant = Constant.NotAConstant;
        }
        if (this.right.constant == null) {
            this.left.constant = Constant.NotAConstant;
        }
        if (this.left.constant != Constant.NotAConstant && this.right.constant != Constant.NotAConstant) {
            try {
                this.constant = Constant.computeConstantOperation(this.left.constant, leftId, (this.bits & 0xFC0) >> 6, this.right.constant, rightId);
            }
            catch (Exception exception) {
                this.constant = Constant.NotAConstant;
            }
        } else {
            this.constant = Constant.NotAConstant;
            this.optimizedBooleanConstant(leftId, (this.bits & 0xFC0) >> 6, rightId);
        }
    }

    @Override
    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    @Override
    public boolean isCompactableOperation() {
        return true;
    }

    public void optimizedBooleanConstant(int leftId, int operator, int rightId) {
        switch (operator) {
            case 2: {
                if (leftId != 5 || rightId != 5) {
                    return;
                }
            }
            case 0: {
                Constant cst = this.left.optimizedBooleanConstant();
                if (cst != Constant.NotAConstant) {
                    if (!cst.booleanValue()) {
                        this.optimizedBooleanConstant = cst;
                        return;
                    }
                    cst = this.right.optimizedBooleanConstant();
                    if (cst != Constant.NotAConstant) {
                        this.optimizedBooleanConstant = cst;
                    }
                    return;
                }
                cst = this.right.optimizedBooleanConstant();
                if (cst != Constant.NotAConstant && !cst.booleanValue()) {
                    this.optimizedBooleanConstant = cst;
                }
                return;
            }
            case 3: {
                if (leftId != 5 || rightId != 5) {
                    return;
                }
            }
            case 1: {
                Constant cst = this.left.optimizedBooleanConstant();
                if (cst != Constant.NotAConstant) {
                    if (cst.booleanValue()) {
                        this.optimizedBooleanConstant = cst;
                        return;
                    }
                    cst = this.right.optimizedBooleanConstant();
                    if (cst != Constant.NotAConstant) {
                        this.optimizedBooleanConstant = cst;
                    }
                    return;
                }
                cst = this.right.optimizedBooleanConstant();
                if (cst == Constant.NotAConstant || !cst.booleanValue()) break;
                this.optimizedBooleanConstant = cst;
            }
        }
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.left.printExpression(indent, output).append(' ').append(this.operatorToString()).append(' ');
        return this.right.printExpression(0, output);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public int getASTType() {
        return 15;
    }

    public IExpression getLeft() {
        return this.left;
    }

    public IExpression getRight() {
        return this.right;
    }
}

