/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.lookup;

import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CaseStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.CompilationUnitBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeIds;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.ProblemReporter;

public abstract class Scope
implements TypeConstants,
TypeIds {
    public static final int BLOCK_SCOPE = 1;
    public static final int CLASS_SCOPE = 3;
    public static final int COMPILATION_UNIT_SCOPE = 4;
    public static final int METHOD_SCOPE = 2;
    public static final int WITH_SCOPE = 5;
    public static final int NOT_COMPATIBLE = -1;
    public static final int COMPATIBLE = 0;
    public static final int AUTOBOX_COMPATIBLE = 1;
    public static final int VARARGS_COMPATIBLE = 2;
    public static final int EQUAL_OR_MORE_SPECIFIC = -1;
    public static final int NOT_RELATED = 0;
    public static final int MORE_GENERIC = 1;
    public int kind;
    public Scope parent;

    public static int compareTypes(TypeBinding left, TypeBinding right) {
        if (left.isCompatibleWith(right)) {
            return -1;
        }
        if (right.isCompatibleWith(left)) {
            return 1;
        }
        return 0;
    }

    public static TypeBinding getBaseType(char[] name) {
        int length = name.length;
        if (length > 2 && length < 8) {
            switch (name[0]) {
                case 'i': {
                    if (length != 3 || name[1] != 'n' || name[2] != 't') break;
                    return TypeBinding.INT;
                }
                case 'v': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'i' || name[3] != 'd') break;
                    return TypeBinding.VOID;
                }
                case 'b': {
                    if (length != 7 || name[1] != 'o' || name[2] != 'o' || name[3] != 'l' || name[4] != 'e' || name[5] != 'a' || name[6] != 'n') break;
                    return TypeBinding.BOOLEAN;
                }
                case 'c': {
                    if (length != 4 || name[1] != 'h' || name[2] != 'a' || name[3] != 'r') break;
                    return TypeBinding.CHAR;
                }
                case 'd': {
                    if (length != 6 || name[1] != 'o' || name[2] != 'u' || name[3] != 'b' || name[4] != 'l' || name[5] != 'e') break;
                    return TypeBinding.DOUBLE;
                }
                case 'f': {
                    if (length != 5 || name[1] != 'l' || name[2] != 'o' || name[3] != 'a' || name[4] != 't') break;
                    return TypeBinding.FLOAT;
                }
                case 'l': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'n' || name[3] != 'g') break;
                    return TypeBinding.LONG;
                }
                case 's': {
                    if (length != 5 || name[1] != 'h' || name[2] != 'o' || name[3] != 'r' || name[4] != 't') break;
                    return TypeBinding.SHORT;
                }
            }
        }
        return null;
    }

    protected Scope(int kind, Scope parent) {
        this.kind = kind;
        this.parent = parent;
    }

    public ClassScope classScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final CompilationUnitScope compilationUnitScope() {
        Scope lastScope = null;
        Scope scope = this;
        do {
            lastScope = scope;
        } while ((scope = scope.parent) != null);
        return (CompilationUnitScope)lastScope;
    }

    public final CompilerOptions compilerOptions() {
        return this.compilationUnitScope().environment.globalOptions;
    }

    protected final MethodBinding computeCompatibleMethod(MethodBinding method, TypeBinding[] arguments, InvocationSite invocationSite) {
        TypeBinding[] parameters = method.parameters;
        if (parameters == arguments) {
            return method;
        }
        int argLength = arguments.length;
        int paramLength = parameters.length;
        boolean isVarArgs = method.isVarargs();
        if (!(argLength == paramLength || isVarArgs && argLength >= paramLength - 1)) {
            return null;
        }
        return null;
    }

    public final ClassScope enclosingClassScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final MethodScope enclosingMethodScope() {
        scope = this;
        if (!(scope instanceof MethodScope)) ** GOTO lbl6
        return (MethodScope)scope;
lbl-1000:
        // 1 sources

        {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
lbl6:
            // 2 sources

            ** while ((scope = scope.parent) != null)
        }
lbl7:
        // 1 sources

        return null;
    }

    public final CompilationUnitBinding enclosingCompilationUnit() {
        Scope scope = this;
        do {
            if (!(scope instanceof CompilationUnitScope)) continue;
            return ((CompilationUnitScope)scope).referenceContext.compilationUnitBinding;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public ReferenceContext enclosingReferenceContext() {
        Scope current = this;
        while ((current = current.parent) != null) {
            switch (current.kind) {
                case 2: {
                    return ((MethodScope)current).referenceContext;
                }
                case 3: {
                    return ((ClassScope)current).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)current).referenceContext;
                }
            }
        }
        return null;
    }

    public final LookupEnvironment environment() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).environment;
    }

    public MethodBinding findMethodForArray(ArrayBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        return null;
    }

    public Binding findBinding(char[] typeName, int mask, PackageBinding declarationPackage, PackageBinding invocationPackage, boolean searchEnvironment) {
        Binding typeBinding;
        this.compilationUnitScope().recordReference(declarationPackage.compoundName, typeName);
        Binding binding = typeBinding = searchEnvironment ? declarationPackage.getBinding(typeName, mask) : declarationPackage.getBinding0(typeName, mask);
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isValidBinding() && declarationPackage != invocationPackage && typeBinding instanceof ReferenceBinding && !((ReferenceBinding)typeBinding).canBeSeenBy(invocationPackage)) {
            return new ProblemReferenceBinding(typeName, (ReferenceBinding)typeBinding, 2);
        }
        return typeBinding;
    }

    public ReferenceBinding findType(char[] typeName, PackageBinding declarationPackage, PackageBinding invocationPackage) {
        return (ReferenceBinding)this.findBinding(typeName, 4, declarationPackage, invocationPackage, true);
    }

    public LocalVariableBinding findVariable(char[] variable) {
        return null;
    }

    public final PackageBinding getCurrentPackage() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).getDefaultPackage();
    }

    public CaseStatement innermostSwitchCase() {
        Scope scope = this;
        do {
            if (!(scope instanceof BlockScope)) continue;
            return ((BlockScope)scope).enclosingCase;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public boolean isBoxingCompatibleWith(TypeBinding expressionType, TypeBinding targetType) {
        LookupEnvironment environment = this.environment();
        if (environment.globalOptions.sourceLevel < 0x310000L || expressionType.isBaseType() == targetType.isBaseType()) {
            return false;
        }
        TypeBinding convertedType = environment.computeBoxingType(expressionType);
        return convertedType == targetType || convertedType.isCompatibleWith(targetType);
    }

    public final boolean isDefinedInField(FieldBinding field) {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            MethodScope methodScope = (MethodScope)scope;
            if (methodScope.initializedField != field) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideCase(CaseStatement caseStatement) {
        Scope scope = this;
        do {
            switch (scope.kind) {
                case 1: {
                    if (((BlockScope)scope).enclosingCase != caseStatement) break;
                    return true;
                }
            }
        } while ((scope = scope.parent) != null);
        return false;
    }

    public MethodScope methodScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final ClassScope outerMostClassScope() {
        ClassScope lastClassScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            lastClassScope = (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return lastClassScope;
    }

    public final MethodScope outerMostMethodScope() {
        MethodScope lastMethodScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            lastMethodScope = (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return lastMethodScope;
    }

    private int parameterCompatibilityLevel(TypeBinding arg, TypeBinding param, LookupEnvironment env) {
        TypeBinding convertedType;
        if (arg.isCompatibleWith(param)) {
            return 0;
        }
        if (arg.isBaseType() != param.isBaseType() && ((convertedType = env.computeBoxingType(arg)) == param || convertedType.isCompatibleWith(param))) {
            return 1;
        }
        return -1;
    }

    public abstract ProblemReporter problemReporter();

    public final CompilationUnitDeclaration referenceCompilationUnit() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).referenceContext;
    }

    public ReferenceContext referenceContext() {
        Scope current = this;
        do {
            switch (current.kind) {
                case 2: {
                    return ((MethodScope)current).referenceContext;
                }
                case 3: {
                    return ((ClassScope)current).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)current).referenceContext;
                }
            }
        } while ((current = current.parent) != null);
        return null;
    }

    int startIndex() {
        return 0;
    }
}

