/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.parser;

import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.RecoveredField;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.RecoveredInitializer;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.RecoveredMethod;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.RecoveredStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.TerminalTokens;

public class RecoveredType
extends RecoveredStatement
implements TerminalTokens {
    public TypeDeclaration typeDeclaration;
    public RecoveredType[] memberTypes;
    public int memberTypeCount;
    public RecoveredField[] fields;
    public int fieldCount;
    public RecoveredMethod[] methods;
    public int methodCount;
    public boolean preserveContent = false;
    public int bodyEnd;
    public int pendingTypeParametersStart;

    public RecoveredType(TypeDeclaration typeDeclaration, RecoveredElement parent, int bracketBalance) {
        super(typeDeclaration, parent, bracketBalance);
        this.typeDeclaration = typeDeclaration;
        if (typeDeclaration.allocation != null && typeDeclaration.allocation.type == null) {
            this.foundOpeningBrace = true;
        } else {
            boolean bl = this.foundOpeningBrace = !this.bodyStartsAtHeaderEnd();
        }
        if (this.foundOpeningBrace) {
            ++this.bracketBalance;
        }
        this.preserveContent = this.parser().methodRecoveryActivated || this.parser().statementRecoveryActivated;
    }

    @Override
    public RecoveredElement add(AbstractMethodDeclaration methodDeclaration, int bracketBalanceValue) {
        if (this.typeDeclaration.declarationSourceEnd != 0 && methodDeclaration.declarationSourceStart > this.typeDeclaration.declarationSourceEnd) {
            return this.parent.add(methodDeclaration, bracketBalanceValue);
        }
        if (this.methods == null) {
            this.methods = new RecoveredMethod[5];
            this.methodCount = 0;
        } else if (this.methodCount == this.methods.length) {
            this.methods = new RecoveredMethod[2 * this.methodCount];
            System.arraycopy(this.methods, 0, this.methods, 0, this.methodCount);
        }
        RecoveredMethod element = new RecoveredMethod(methodDeclaration, this, bracketBalanceValue, this.recoveringParser);
        this.methods[this.methodCount++] = element;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (methodDeclaration.declarationSourceEnd == 0) {
            return element;
        }
        return this;
    }

    @Override
    public RecoveredElement add(Block nestedBlockDeclaration, int bracketBalanceValue) {
        int modifiers = 0;
        if (this.parser().recoveredStaticInitializerStart != 0) {
            modifiers = 8;
        }
        return this.add(new Initializer(nestedBlockDeclaration, modifiers), bracketBalanceValue);
    }

    @Override
    public RecoveredElement add(FieldDeclaration fieldDeclaration, int bracketBalanceValue) {
        RecoveredField element;
        if (this.typeDeclaration.declarationSourceEnd != 0 && fieldDeclaration.declarationSourceStart > this.typeDeclaration.declarationSourceEnd) {
            return this.parent.add(fieldDeclaration, bracketBalanceValue);
        }
        if (this.fields == null) {
            this.fields = new RecoveredField[5];
            this.fieldCount = 0;
        } else if (this.fieldCount == this.fields.length) {
            this.fields = new RecoveredField[2 * this.fieldCount];
            System.arraycopy(this.fields, 0, this.fields, 0, this.fieldCount);
        }
        switch (fieldDeclaration.getKind()) {
            case 1: {
                element = new RecoveredField(fieldDeclaration, this, bracketBalanceValue);
                break;
            }
            case 2: {
                element = new RecoveredInitializer(fieldDeclaration, this, bracketBalanceValue);
                break;
            }
            default: {
                return this;
            }
        }
        this.fields[this.fieldCount++] = element;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (fieldDeclaration.declarationSourceEnd == 0) {
            return element;
        }
        return this;
    }

    @Override
    public RecoveredElement add(TypeDeclaration memberTypeDeclaration, int bracketBalanceValue) {
        if (this.typeDeclaration.declarationSourceEnd != 0 && memberTypeDeclaration.declarationSourceStart > this.typeDeclaration.declarationSourceEnd) {
            return this.parent.add(memberTypeDeclaration, bracketBalanceValue);
        }
        if ((memberTypeDeclaration.bits & 0x200) != 0) {
            if (this.methodCount > 0) {
                RecoveredMethod lastMethod = this.methods[this.methodCount - 1];
                lastMethod.methodDeclaration.bodyEnd = 0;
                lastMethod.methodDeclaration.declarationSourceEnd = 0;
                lastMethod.bracketBalance = lastMethod.bracketBalance + 1;
                return lastMethod.add(memberTypeDeclaration, bracketBalanceValue);
            }
            return this;
        }
        if (this.memberTypes == null) {
            this.memberTypes = new RecoveredType[5];
            this.memberTypeCount = 0;
        } else if (this.memberTypeCount == this.memberTypes.length) {
            this.memberTypes = new RecoveredType[2 * this.memberTypeCount];
            System.arraycopy(this.memberTypes, 0, this.memberTypes, 0, this.memberTypeCount);
        }
        RecoveredType element = new RecoveredType(memberTypeDeclaration, (RecoveredElement)this, bracketBalanceValue);
        this.memberTypes[this.memberTypeCount++] = element;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (memberTypeDeclaration.declarationSourceEnd == 0) {
            return element;
        }
        return this;
    }

    public int bodyEnd() {
        if (this.bodyEnd == 0) {
            return this.typeDeclaration.declarationSourceEnd;
        }
        return this.bodyEnd;
    }

    public boolean bodyStartsAtHeaderEnd() {
        if (this.typeDeclaration.superclass == null) {
            return this.typeDeclaration.bodyStart == this.typeDeclaration.sourceEnd + 1;
        }
        return this.typeDeclaration.bodyStart == this.typeDeclaration.superclass.sourceEnd + 1;
    }

    @Override
    public RecoveredType enclosingType() {
        RecoveredElement current = this.parent;
        while (current != null) {
            if (current instanceof RecoveredType) {
                return (RecoveredType)current;
            }
            current = current.parent;
        }
        return null;
    }

    public char[] name() {
        return this.typeDeclaration.name;
    }

    @Override
    public ASTNode parseTree() {
        return this.typeDeclaration;
    }

    @Override
    public int sourceEnd() {
        return this.typeDeclaration.declarationSourceEnd;
    }

    @Override
    public String toString(int tab) {
        int i;
        StringBuffer result = new StringBuffer(this.tabString(tab));
        result.append("Recovered type:\n");
        if ((this.typeDeclaration.bits & 0x200) != 0) {
            result.append(this.tabString(tab));
            result.append(" ");
        }
        this.typeDeclaration.print(tab + 1, result);
        if (this.memberTypes != null) {
            i = 0;
            while (i < this.memberTypeCount) {
                result.append("\n");
                result.append(this.memberTypes[i].toString(tab + 1));
                ++i;
            }
        }
        if (this.fields != null) {
            i = 0;
            while (i < this.fieldCount) {
                result.append("\n");
                result.append(this.fields[i].toString(tab + 1));
                ++i;
            }
        }
        if (this.methods != null) {
            i = 0;
            while (i < this.methodCount) {
                result.append("\n");
                result.append(this.methods[i].toString(tab + 1));
                ++i;
            }
        }
        return result.toString();
    }

    @Override
    public void updateBodyStart(int bodyStart) {
        this.foundOpeningBrace = true;
        this.typeDeclaration.bodyStart = bodyStart;
    }

    @Override
    public void updateFromParserState() {
        if (this.bodyStartsAtHeaderEnd() && this.typeDeclaration.allocation == null) {
            Parser parser = this.parser();
            if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                boolean canConsume;
                int length = parser.astLengthStack[parser.astLengthPtr];
                int astPtr = parser.astPtr - length;
                boolean bl = canConsume = astPtr >= 0;
                if (canConsume) {
                    if (!(parser.astStack[astPtr] instanceof TypeDeclaration)) {
                        canConsume = false;
                    }
                    int i = 1;
                    int max = length + 1;
                    while (i < max) {
                        if (!(parser.astStack[astPtr + i] instanceof TypeReference)) {
                            canConsume = false;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int braceStart, int braceEnd) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(braceStart, braceEnd);
            this.bodyEnd = braceStart - 1;
            return this.parent;
        }
        return this;
    }

    @Override
    public RecoveredElement updateOnOpeningBrace(int braceStart, int braceEnd) {
        if (this.bracketBalance == 0) {
            Parser parser = this.parser();
            switch (parser.lastIgnoredToken) {
                case -1: 
                case 6: 
                case 8: 
                case 20: 
                case 97: 
                case 101: {
                    if (parser.recoveredStaticInitializerStart == 0) break;
                }
                default: {
                    this.foundOpeningBrace = true;
                    this.bracketBalance = 1;
                }
            }
        }
        if (this.bracketBalance == 1) {
            Initializer init;
            Block block = new Block(0);
            Parser parser = this.parser();
            block.sourceStart = parser.scanner.startPosition;
            if (parser.recoveredStaticInitializerStart == 0) {
                init = new Initializer(block, 0);
            } else {
                init = new Initializer(block, 8);
                init.declarationSourceStart = parser.recoveredStaticInitializerStart;
            }
            init.bodyStart = parser.scanner.currentPosition;
            return this.add(init, 1);
        }
        return super.updateOnOpeningBrace(braceStart, braceEnd);
    }

    @Override
    public void updateSourceEndIfNecessary(int start, int end) {
        if (this.typeDeclaration.declarationSourceEnd == 0) {
            this.bodyEnd = 0;
            this.typeDeclaration.declarationSourceEnd = end;
            this.typeDeclaration.bodyEnd = end;
        }
    }
}

