/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.core.interpret;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.eclipse.mod.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.mod.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.mod.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.mod.wst.jsdt.internal.core.interpret.InterpretedScript;
import org.eclipse.mod.wst.jsdt.internal.core.interpret.InterpreterContext;
import org.eclipse.mod.wst.jsdt.internal.core.interpret.InterpreterEngine;
import org.eclipse.mod.wst.jsdt.internal.core.interpret.InterpreterResult;

public class Interpreter {
    public static InterpretedScript parseFile(String fileName) {
        File file = new File(fileName);
        InterpretedScript unit = null;
        if (file.exists()) {
            try {
                byte[] fileByteContent = Util.getFileByteContent(file);
                char[] chars = Util.bytesToChar(fileByteContent, "UTF-8");
                unit = Interpreter.parse(chars);
            }
            catch (IOException iOException) {}
        }
        return unit;
    }

    public static InterpretedScript parseString(String code) {
        char[] source = code.toCharArray();
        return Interpreter.parse(source);
    }

    private static InterpretedScript parse(char[] source) {
        Map options = new CompilerOptions().getMap();
        options.put("org.eclipse.mod.wst.jsdt.core.compiler.problem.unusedLocal", "ignore");
        options.put("org.eclipse.mod.wst.jsdt.core.compiler.compliance", "1.3");
        options.put("org.eclipse.mod.wst.jsdt.core.compiler.source", "1.3");
        options.put("org.eclipse.mod.wst.jsdt.core.compiler.codegen.targetPlatform", "1.1");
        CompilerOptions compilerOptions = new CompilerOptions(options);
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.exitAfterAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault())), true);
        CompilationUnit sourceUnit = new CompilationUnit(source, "interpreted", null);
        CompilationResult compilationUnitResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration parsedUnit = parser.parse(sourceUnit, compilationUnitResult);
        int[] lineEnds = parser.scanner.lineEnds;
        return new InterpretedScript(parsedUnit, lineEnds, parser.scanner.linePtr);
    }

    public static InterpreterResult interpret(CompilationUnitDeclaration ast, InterpreterContext context) {
        InterpreterEngine engine = new InterpreterEngine(context);
        return engine.interpret(ast);
    }
}

