/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import org.ccil.cowan.tagsoup.Parser;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.client.ScriptExecutor;
import org.eclipse.vjet.dsf.active.client.WindowFactory;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlBuilder;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlFrame;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlIFrame;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlScript;
import org.eclipse.vjet.dsf.active.dom.html.IDocListener;
import org.eclipse.vjet.dsf.common.StringUtils;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.js.ActiveJsExecutionControlCtx;
import org.eclipse.vjet.dsf.html.js.Encoding;
import org.eclipse.vjet.dsf.html.js.JSDebug;
import org.eclipse.vjet.dsf.html.js.URLUtil;
import org.eclipse.vjet.dsf.html.sax.AHtmlSchema;
import org.eclipse.vjet.dsf.jsnative.HtmlElement;
import org.eclipse.vjet.dsf.jsnative.Window;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class AHtmlParser
implements ContentHandler,
LexicalHandler,
IDocListener {
    static final String BODY = HtmlTypeEnum.BODY.getName();
    static final AHtmlSchema m_schema = new AHtmlSchema();
    private AWindow m_browserWindow = null;
    private AHtmlBuilder m_baseBuilder = null;
    private URL m_urlContext = null;
    private boolean m_isRoot = true;
    private boolean m_isInsideBody = false;
    private boolean m_isJavascript = false;
    private String m_javascriptSrc = null;
    private String m_theScript = null;
    private boolean m_isFrame = false;
    private String m_frameSrc = null;
    private int m_numOfNestedBodyTag = 0;
    private int m_encoding;
    private StringBuilder m_generatedContents = new StringBuilder();
    private int m_scriptIndex = 0;

    public AHtmlParser(AWindow browserWindow, boolean isRoot, int encoding) {
        if (browserWindow == null) {
            throw new IllegalArgumentException("browserWindow is null");
        }
        this.m_isRoot = isRoot;
        this.m_browserWindow = browserWindow;
        this.m_baseBuilder = browserWindow.getHtmlBuilder();
        this.m_encoding = encoding;
    }

    public static Window parse(String src, URL baseUrl) {
        return AHtmlParser.parse(src, baseUrl, 1);
    }

    public static Window parse(String src, URL baseUrl, Window window) {
        return AHtmlParser.parse(src, baseUrl, 1, window);
    }

    public static Window parse(String src, URL baseUrl, int encoding) {
        Window window = WindowFactory.createWindow();
        return AHtmlParser.parse(src, baseUrl, encoding, window);
    }

    public static Window parse(URL url) {
        return AHtmlParser.parse(url, (AWindow)WindowFactory.createWindow());
    }

    public static Window parse(URL url, AWindow window) {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        try {
            return AHtmlParser.parse(window, new InputSource(url.openStream()), url, 1);
        }
        catch (Exception e) {
            throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static Window parse(String src, URL baseUrl, int encoding, Window window) {
        if (src == null) {
            throw new IllegalArgumentException("html string is null");
        }
        StringReader sr = new StringReader(src);
        try {
            AHtmlParser.parse((AWindow)window, new InputSource(sr), baseUrl, encoding);
        }
        catch (Exception e) {
            throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
        }
        return window;
    }

    static AWindow parse(AWindow window, InputSource inputSource, URL urlContext, int encoding) throws SAXException, IOException {
        if (window.getURL() == null) {
            window.setURL(urlContext);
        }
        Parser parser = new Parser();
        parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", (Object)m_schema);
        AHtmlParser builder = new AHtmlParser(window, window.isRoot(), encoding);
        builder.setURLContext(urlContext);
        window.setRoot(false);
        parser.setContentHandler((ContentHandler)builder);
        try {
            if (encoding != 0) {
                inputSource.setEncoding(Encoding.JAVA_ENCODING[encoding]);
            }
            parser.parse(inputSource);
        }
        catch (Exception e) {
            throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
        }
        return window;
    }

    static AWindow parse(AWindow window, URL url, int encoding) throws SAXException, IOException {
        if (window.getURL() == null) {
            window.setURL(url);
        }
        Parser parser = new Parser();
        AHtmlParser builder = new AHtmlParser(window, window.isRoot(), encoding);
        builder.setURLContext(url);
        window.setRoot(false);
        parser.setContentHandler((ContentHandler)builder);
        URLConnection urlConn = url.openConnection();
        urlConn.setUseCaches(false);
        urlConn.setAllowUserInteraction(false);
        urlConn.setDoInput(true);
        urlConn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 4.0)");
        urlConn.setRequestProperty("Accept", "text/html, image/gif, image/jpeg, */*");
        urlConn.setRequestProperty("Accept-Language", "en-us");
        urlConn.connect();
        InputStream is = urlConn.getInputStream();
        parser.parse(new InputSource(is));
        return window;
    }

    public void setURLContext(URL u) {
        this.m_urlContext = u;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.m_isRoot) {
            this.m_baseBuilder.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.m_isRoot) {
            this.m_baseBuilder.endDocument();
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String s1 = localName.trim();
        if (!this.m_isRoot) {
            if (s1.equalsIgnoreCase(BODY) && !this.m_isInsideBody) {
                this.m_isInsideBody = true;
                return;
            }
            if (!this.m_isInsideBody) {
                return;
            }
            if (s1.equalsIgnoreCase(BODY)) {
                ++this.m_numOfNestedBodyTag;
            }
        }
        this.m_baseBuilder.startElement(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        localName = localName.trim();
        if (!this.m_isRoot) {
            if (localName.equalsIgnoreCase(BODY)) {
                if (this.m_numOfNestedBodyTag > 0) {
                    --this.m_numOfNestedBodyTag;
                } else {
                    this.m_isInsideBody = false;
                    return;
                }
            }
            if (!this.m_isInsideBody) {
                return;
            }
        }
        HtmlElement curElem = this.m_baseBuilder.getCurrentElement();
        if (HtmlTypeEnum.SCRIPT.getName().equalsIgnoreCase(curElem.getTagName())) {
            boolean dlcScriptToken;
            AHtmlScript htmlScript = (AHtmlScript)curElem;
            boolean bl = dlcScriptToken = htmlScript.getAttribute("dlc") != null && htmlScript.getAttribute("dlc").length() > 0;
            if (!dlcScriptToken) {
                this.m_isJavascript = true;
                if (htmlScript.getSrc() != null && htmlScript.getSrc().length() > 0) {
                    this.m_javascriptSrc = htmlScript.getSrc().trim();
                } else {
                    this.m_theScript = htmlScript.getText();
                }
            }
            ++this.m_scriptIndex;
        } else if (HtmlTypeEnum.FRAME.getName().equalsIgnoreCase(curElem.getTagName()) || HtmlTypeEnum.IFRAME.getName().equalsIgnoreCase(curElem.getTagName())) {
            this.m_isFrame = true;
            String src = null;
            src = HtmlTypeEnum.FRAME.getName().equalsIgnoreCase(curElem.getTagName()) ? ((AHtmlFrame)curElem).getSrc() : ((AHtmlIFrame)curElem).getSrc();
            if (src != null && src.length() > 0) {
                this.m_frameSrc = src.trim();
            }
        }
        if (this.m_isRoot || !this.m_isRoot && !this.m_isJavascript) {
            this.m_baseBuilder.endElement(namespaceURI, localName, qName);
        }
        if (this.m_isFrame && DapCtx.ctx().isWebMode()) {
            AHtmlElement htmlFrame;
            AWindow frameWindow = (AWindow)WindowFactory.createWindow(this.m_browserWindow);
            frameWindow.setName(curElem.getAttribute(EHtmlAttr.name.name()));
            if (this.m_frameSrc != null) {
                URL url;
                String pageUrl = null;
                if (this.m_urlContext != null) {
                    pageUrl = URLUtil.getBaseURL(this.m_urlContext.toString());
                }
                try {
                    try {
                        url = new URL(URLUtil.getAbsoluteURL(this.m_frameSrc, URLUtil.getBaseURL(pageUrl)));
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                        throw new SAXException(e);
                    }
                }
                finally {
                    this.m_isFrame = false;
                    this.m_frameSrc = null;
                }
                try {
                    try {
                        AHtmlParser.parse(frameWindow, new InputSource(url.openStream()), url, 1);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new SAXException(e);
                    }
                }
                finally {
                    this.m_isFrame = false;
                    this.m_frameSrc = null;
                }
            }
            this.m_isFrame = false;
            this.m_frameSrc = null;
            AHtmlDocument frameDoc = (AHtmlDocument)frameWindow.getDocument();
            if (HtmlTypeEnum.FRAME.getName().equalsIgnoreCase(curElem.getTagName())) {
                htmlFrame = (AHtmlFrame)curElem;
                AHtmlHelper.setContentDocument(htmlFrame, frameDoc);
            }
            if (HtmlTypeEnum.IFRAME.getName().equalsIgnoreCase(curElem.getTagName())) {
                htmlFrame = (AHtmlIFrame)curElem;
                AHtmlHelper.setContentDocument((AHtmlIFrame)htmlFrame, frameDoc);
            }
        }
        if (this.m_isJavascript && ActiveJsExecutionControlCtx.ctx().needExecuteJavaScript()) {
            block40: {
                if (this.m_javascriptSrc != null && this.m_javascriptSrc.length() > 0) {
                    String pageUrl = null;
                    if (this.m_urlContext != null) {
                        pageUrl = URLUtil.getBaseURL(this.m_urlContext.toString());
                    }
                    String url = URLUtil.getAbsoluteURL(this.m_javascriptSrc, URLUtil.getBaseURL(pageUrl));
                    try {
                        try {
                            InputStreamReader reader = null;
                            reader = this.m_encoding != 0 ? new InputStreamReader(new URL(url).openStream(), Encoding.JAVA_ENCODING[this.m_encoding]) : new InputStreamReader(new URL(url).openStream());
                            StringBuffer sb = new StringBuffer();
                            int c = 0;
                            while ((c = reader.read()) != -1) {
                                sb.append((char)c);
                            }
                            String scriptStr = sb.toString();
                            this.executeScript(scriptStr, url);
                            break block40;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            throw new SAXException(ex);
                        }
                    }
                    finally {
                        this.m_isJavascript = false;
                        this.m_javascriptSrc = null;
                        this.m_theScript = null;
                    }
                }
                if (this.m_theScript != null && this.m_theScript.trim().length() > 0) {
                    this.executeScript(this.m_theScript, this.getScriptId(this.m_urlContext == null ? null : this.m_urlContext.toExternalForm(), this.m_theScript));
                }
            }
            this.m_isJavascript = false;
            this.m_javascriptSrc = null;
            this.m_theScript = null;
        }
    }

    private String getScriptId(String pageUrl, String script) {
        String id = pageUrl == null ? "Annonymous" : pageUrl;
        return String.valueOf(id) + "#Script#" + this.m_scriptIndex + "#" + this.getLineNumber() + "#" + this.innerGetEmptyLineCount(script);
    }

    private int innerGetEmptyLineCount(String script) {
        List ss = StringUtils.splitStr((String)script, (char)'\n');
        Iterator it = ss.iterator();
        int i = 0;
        while (it.hasNext()) {
            String s = (String)it.next();
            if (s.trim().length() != 0) break;
            ++i;
        }
        return i;
    }

    private int getLineNumber() {
        if (this.m_baseBuilder.getDocumentLocator() == null) {
            return this.m_scriptIndex;
        }
        return this.m_baseBuilder.getDocumentLocator().getLineNumber();
    }

    private void executeScript(String scriptStr, String srcId) {
        IDocListener builderListener = this.m_browserWindow.getDocListener();
        boolean domChangeListenerEnabled = this.m_browserWindow.isDomChangeListenerEnabled();
        try {
            try {
                this.m_browserWindow.setDocListener(this);
                this.m_browserWindow.enableDomChangeListener(true);
                ScriptExecutor.executeScript(scriptStr, srcId, this.m_browserWindow);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.m_browserWindow.setDocListener(builderListener);
            this.m_browserWindow.enableDomChangeListener(domChangeListenerEnabled);
        }
    }

    @Override
    public void characters(char[] ac, int i, int j) throws SAXException {
        this.m_baseBuilder.characters(ac, i, j);
    }

    @Override
    public void ignorableWhitespace(char[] ac, int i, int j) throws SAXException {
        this.m_baseBuilder.ignorableWhitespace(ac, i, j);
    }

    @Override
    public void processingInstruction(String s, String s1) throws SAXException {
        this.m_baseBuilder.processingInstruction(s, s1);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_baseBuilder.setDocumentLocator(locator);
    }

    @Override
    public void doneDocumentWrite() {
        String newContent = this.m_browserWindow.getGeneratedContentFromScript();
        if (newContent.trim().length() == 0) {
            return;
        }
        boolean parseIt = this.m_generatedContents.length() == 0;
        this.m_generatedContents.append(newContent.trim());
        if (newContent.endsWith(">") || newContent.endsWith("\n")) {
            parseIt = true;
        } else if (newContent.startsWith("<") && !newContent.endsWith(">")) {
            parseIt = false;
        }
        if (parseIt) {
            String content = this.m_generatedContents.toString();
            String lowercaseContent = content.toLowerCase();
            if (lowercaseContent.startsWith("<script") && !lowercaseContent.endsWith("</script")) {
                return;
            }
            try {
                if (ActiveJsExecutionControlCtx.ctx().needParseGeneratedContent()) {
                    AHtmlParser.parse(this.m_browserWindow, new InputSource(new StringReader(content)), this.m_urlContext, this.m_encoding);
                }
            }
            catch (Exception ex) {
                JSDebug.println(ex.getMessage());
            }
            this.m_generatedContents.delete(0, this.m_generatedContents.length());
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_baseBuilder.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.m_baseBuilder.endPrefixMapping(prefix);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.m_baseBuilder.skippedEntity(name);
    }

    @Override
    public void comment(char[] text, int start, int length) throws SAXException {
        this.m_baseBuilder.comment(text, start, length);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_baseBuilder.endCDATA();
    }

    @Override
    public void endDTD() throws SAXException {
        this.m_baseBuilder.endDTD();
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.m_baseBuilder.endEntity(name);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_baseBuilder.startCDATA();
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.m_baseBuilder.startDTD(name, publicId, systemId);
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.m_baseBuilder.startEntity(name);
    }
}

