/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.vjet.dsf.active.dom.html.AAttr;
import org.eclipse.vjet.dsf.active.dom.html.ADocument;
import org.eclipse.vjet.dsf.active.dom.html.AElement;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.active.dom.html.AText;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.jsnative.Node;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AXmlParser {
    public static ADocument parse(byte[] data) {
        AXmlSaxHandler handler = new AXmlSaxHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(data), (DefaultHandler)handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handler.getDocument();
    }

    private static class AXmlSaxHandler
    extends DefaultHandler {
        private ADocument m_doc = new ADocument(new DDocument(), BrowserType.NONE);
        protected Stack<AElement> m_elemStack = new Stack();

        private AXmlSaxHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            AElement elem = new AElement(this.m_doc, new DElement(qName));
            if (this.m_elemStack.isEmpty()) {
                this.m_doc.appendChild(elem);
            } else {
                this.m_elemStack.peek().appendChild(elem);
            }
            this.m_elemStack.push(elem);
            if (attributes != null) {
                int i = 0;
                while (i < attributes.getLength()) {
                    AAttr attr = new AAttr(this.m_doc, new DAttr(attributes.getQName(i), attributes.getValue(i)));
                    elem.setAttributeNode(attr);
                    ++i;
                }
            }
        }

        @Override
        public void characters(char[] text, int start, int length) throws SAXException {
            String txt = new String(text, start, length);
            ANode child = (ANode)this.m_elemStack.peek().getLastChild();
            if (child instanceof AText) {
                ((AText)child).appendData(txt);
            } else {
                this.m_elemStack.peek().appendChild((Node)this.m_doc.createTextNode(txt));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.m_elemStack.isEmpty()) {
                this.m_elemStack.pop();
            }
        }

        private ADocument getDocument() {
            return this.m_doc;
        }
    }
}

