/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.active.dom.html.AAttr;
import org.eclipse.vjet.dsf.active.dom.html.ACDATASection;
import org.eclipse.vjet.dsf.active.dom.html.AComment;
import org.eclipse.vjet.dsf.active.dom.html.ADOMException;
import org.eclipse.vjet.dsf.active.dom.html.ADOMImplementation;
import org.eclipse.vjet.dsf.active.dom.html.ADocumentFragment;
import org.eclipse.vjet.dsf.active.dom.html.ADocumentType;
import org.eclipse.vjet.dsf.active.dom.html.AElement;
import org.eclipse.vjet.dsf.active.dom.html.AEntityReference;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlFactory;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.active.dom.html.ANodeList;
import org.eclipse.vjet.dsf.active.dom.html.AProcessingInstruction;
import org.eclipse.vjet.dsf.active.dom.html.AText;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DCDATASection;
import org.eclipse.vjet.dsf.dom.DComment;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DDocumentFragment;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DEntityReference;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DProcessingInstruction;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.jsnative.Attr;
import org.eclipse.vjet.dsf.jsnative.CDATASection;
import org.eclipse.vjet.dsf.jsnative.Comment;
import org.eclipse.vjet.dsf.jsnative.DOMConfiguration;
import org.eclipse.vjet.dsf.jsnative.DOMImplementation;
import org.eclipse.vjet.dsf.jsnative.Document;
import org.eclipse.vjet.dsf.jsnative.DocumentFragment;
import org.eclipse.vjet.dsf.jsnative.DocumentType;
import org.eclipse.vjet.dsf.jsnative.Element;
import org.eclipse.vjet.dsf.jsnative.EntityReference;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.HtmlElement;
import org.eclipse.vjet.dsf.jsnative.Node;
import org.eclipse.vjet.dsf.jsnative.NodeList;
import org.eclipse.vjet.dsf.jsnative.ProcessingInstruction;
import org.eclipse.vjet.dsf.jsnative.Text;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.w3c.dom.DOMException;

public class ADocument
extends ANode
implements Document {
    private static final long serialVersionUID = 1L;
    private Map<String, AHtmlElement> m_idToElement = new HashMap<String, AHtmlElement>();
    private Map<AHtmlElement, String> m_elementToId = new HashMap<AHtmlElement, String>();
    private DOMImplementation m_implementation = new ADOMImplementation();

    public ADocument(DDocument doc, BrowserType browserType) {
        super(null, (DNode)doc);
        this.setOwnerDocument(this);
        this.populateScriptable(ADocument.class, browserType);
    }

    public Element getDocumentElement() {
        NodeList nodes = this.getChildNodes();
        if (nodes.getLength() == 0) {
            return null;
        }
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    public Element createElement(String tagName) throws DOMException {
        try {
            return AHtmlFactory.createElement((HtmlDocument)((AHtmlDocument)this), tagName);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public Text createTextNode(String data) {
        return new AText(this, (DText)this.getDDocument().createTextNode(data));
    }

    public Element byId(String elementId) {
        return this.getElementById(elementId);
    }

    public Element getElementById(String elementId) {
        AHtmlElement element = this.m_idToElement.get(elementId);
        return element;
    }

    public NodeList byTag(String tagName) {
        return this.getElementsByTagName(tagName);
    }

    public NodeList getElementsByTagName(String tagName) {
        ANodeList answer = new ANodeList();
        this.getElementsByTagName(tagName, answer);
        return answer;
    }

    private void getElementsByTagName(String name, ANodeList answer) {
        boolean matchesAll = "*".equals(name);
        if (this.m_childNodes == null) {
            return;
        }
        for (ANode childx : this.m_childNodes) {
            if (!(childx instanceof AElement)) continue;
            AElement child = (AElement)childx;
            String childName = child.getNodeName();
            if (matchesAll || childName.equalsIgnoreCase(name)) {
                answer.add(child);
            }
            child.getElementsByTagName(name, answer);
        }
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        try {
            DNode dNode = (DNode)this.getDDocument().importNode((org.w3c.dom.Node)((ANode)importedNode).getDNode(), deep);
            HtmlElement newNode = AHtmlFactory.createElement((HtmlDocument)((AHtmlDocument)this), dNode);
            return newNode;
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public Node adoptNode(Node source) throws DOMException {
        try {
            DNode dNode = (DNode)this.getDDocument().adoptNode((org.w3c.dom.Node)((ANode)source).getDNode());
            HtmlElement newNode = AHtmlFactory.createElement((HtmlDocument)((AHtmlDocument)this), dNode);
            return newNode;
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public Attr createAttribute(String name) throws DOMException {
        if (name == null || name.length() == 0) {
            throw new ADOMException(new DOMException(5, "name is null or empty"));
        }
        try {
            return new AAttr((AHtmlDocument)this, (DAttr)this.getDDocument().createAttribute(name));
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        try {
            return new AAttr((AHtmlDocument)this, (DAttr)this.getDDocument().createAttributeNS(namespaceURI, qualifiedName));
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        try {
            return new ACDATASection((AHtmlDocument)this, (DCDATASection)this.getDDocument().createCDATASection(data));
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public Comment createComment(String data) {
        return new AComment((AHtmlDocument)this, (DComment)this.getDDocument().createComment(data));
    }

    public DocumentFragment createDocumentFragment() {
        return new ADocumentFragment((AHtmlDocument)this, (DDocumentFragment)this.getDDocument().createDocumentFragment());
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return new AElement((AHtmlDocument)this, (DElement)this.getDDocument().createElementNS(namespaceURI, qualifiedName));
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        if (name == null || name.length() == 0) {
            throw new ADOMException(new DOMException(5, "name is null or empty"));
        }
        return new AEntityReference((AHtmlDocument)this, (DEntityReference)this.getDDocument().createEntityReference(name));
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        try {
            return new AProcessingInstruction((AHtmlDocument)this, (DProcessingInstruction)this.getDDocument().createProcessingInstruction(target, data));
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public DocumentType getDoctype() {
        Node firstChild = this.getFirstChild();
        if (firstChild == null) {
            return null;
        }
        if (firstChild instanceof ADocumentType) {
            return (ADocumentType)firstChild;
        }
        return null;
    }

    public String getDocumentURI() {
        return this.getDDocument().getDocumentURI();
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public NodeList byTagNS(String namespaceURI, String localName) {
        return this.getElementsByTagNameNS(namespaceURI, localName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        ANodeList answer = new ANodeList();
        this.getElementByTagNameNS(localName, namespaceURI, answer);
        return answer;
    }

    void getElementByTagNameNS(String name, String nsUri, ANodeList answer) {
        if (this.m_childNodes == null) {
            return;
        }
        if (nsUri == null) {
            this.getElementsByTagName(name, answer);
            return;
        }
        if (name == null) {
            return;
        }
        boolean matchesAllName = "*".equals(name);
        boolean matchesAllUri = "*".equals(nsUri);
        for (ANode childx : this.m_childNodes) {
            if (!(childx instanceof AElement)) continue;
            if (matchesAllName) {
                if (matchesAllUri) {
                    answer.add(childx);
                } else if (nsUri.equals(childx.getNamespaceURI())) {
                    answer.add(childx);
                }
            } else if (childx.getLocalName() != null && childx.getLocalName().equals(name)) {
                if (matchesAllUri) {
                    answer.add(childx);
                } else if (nsUri.equals(childx.getNamespaceURI())) {
                    answer.add(childx);
                }
            }
            ((AElement)childx).getElementByTagNameNS(name, nsUri, answer);
        }
    }

    public DOMImplementation getImplementation() {
        return this.m_implementation;
    }

    public String getInputEncoding() {
        return this.getDDocument().getInputEncoding();
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public String getXmlEncoding() {
        return this.getDDocument().getXmlEncoding();
    }

    public boolean getXmlStandalone() {
        return false;
    }

    public String getXmlVersion() {
        return this.getDDocument().getXmlVersion();
    }

    public void normalizeDocument() {
        this.getDDocument().normalizeDocument();
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new ADOMException(new DOMException(9, "renameNode not supported"));
    }

    public void setDocumentURI(String documentURI) {
        try {
            this.getDDocument().setDocumentURI(documentURI);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        try {
            this.getDDocument().setStrictErrorChecking(strictErrorChecking);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        try {
            this.getDDocument().setXmlStandalone(xmlStandalone);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        try {
            this.getDDocument().setXmlVersion(xmlVersion);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    void putIdentifier(String id, AHtmlElement element) {
        AHtmlElement old = this.m_idToElement.get(id);
        if (old != null && old != element) {
            throw new ADOMException(new DOMException(16, "duplicate ID of " + id));
        }
        this.m_idToElement.put(id, element);
        this.m_elementToId.put(element, id);
    }

    void removeIdentifier(String id) {
        AHtmlElement element = this.m_idToElement.remove(id);
        if (element != null) {
            this.m_elementToId.remove(element);
        }
    }

    void removeIdentifiedElement(ANode node) {
        if (node instanceof AElement) {
            NodeList children;
            String id = this.m_elementToId.remove(node);
            if (id != null) {
                this.m_idToElement.remove(id);
            }
            if ((children = node.getChildNodes()) != null) {
                int i = 0;
                int l = children.getLength();
                while (i < l) {
                    Node child = children.item(i);
                    if (child instanceof ANode) {
                        this.removeIdentifiedElement((ANode)child);
                    }
                    ++i;
                }
            }
        }
    }

    private DDocument getDDocument() {
        return (DDocument)this.getDNode();
    }

    public String getLastModified() {
        return null;
    }

    public String getBgColor() {
        return null;
    }

    public String getAlinkColor() {
        return null;
    }

    public String getLinkColor() {
        return null;
    }

    public String getVlinkColor() {
        return null;
    }

    public String getProtocol() {
        return null;
    }

    public String getCookie() {
        return null;
    }

    public String getFgColor() {
        return null;
    }

    public String getReadyState() {
        return null;
    }

    public String getSecurity() {
        return null;
    }

    public void setBgColor(String value) {
    }

    public void setFgColor(String value) {
    }

    public void setLinkColor(String value) {
    }
}

