/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.active.client.ALocation;
import org.eclipse.vjet.dsf.active.client.ASelection;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.dom.html.ADOMException;
import org.eclipse.vjet.dsf.active.dom.html.ADocument;
import org.eclipse.vjet.dsf.active.dom.html.AElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlBody;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlCollection;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlForm;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHead;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHtml;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlType;
import org.eclipse.vjet.dsf.active.dom.html.AJavaScriptHandlerHolder;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.active.dom.html.ANodeList;
import org.eclipse.vjet.dsf.active.dom.html.AText;
import org.eclipse.vjet.dsf.active.dom.html.IDocListener;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.active.event.IDomChangeListener;
import org.eclipse.vjet.dsf.active.event.IDomEventBindingListener;
import org.eclipse.vjet.dsf.active.event.IDomEventPublisher;
import org.eclipse.vjet.dsf.active.event.IEventListenersCollector;
import org.eclipse.vjet.dsf.dap.event.AKeyEvent;
import org.eclipse.vjet.dsf.dap.event.AMouseEvent;
import org.eclipse.vjet.dsf.dap.proxy.NativeJsHelper;
import org.eclipse.vjet.dsf.dap.rt.DapEventEngine;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DHtml;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.jsnative.Document;
import org.eclipse.vjet.dsf.jsnative.HtmlBody;
import org.eclipse.vjet.dsf.jsnative.HtmlCollection;
import org.eclipse.vjet.dsf.jsnative.HtmlDOMImplementation;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.HtmlElement;
import org.eclipse.vjet.dsf.jsnative.HtmlHead;
import org.eclipse.vjet.dsf.jsnative.HtmlLink;
import org.eclipse.vjet.dsf.jsnative.HtmlStyle;
import org.eclipse.vjet.dsf.jsnative.Location;
import org.eclipse.vjet.dsf.jsnative.Node;
import org.eclipse.vjet.dsf.jsnative.NodeList;
import org.eclipse.vjet.dsf.jsnative.Range;
import org.eclipse.vjet.dsf.jsnative.Selection;
import org.eclipse.vjet.dsf.jsnative.StyleSheetList;
import org.eclipse.vjet.dsf.jsnative.Text;
import org.eclipse.vjet.dsf.jsnative.Window;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jsnative.events.DocumentEvent;
import org.eclipse.vjet.dsf.jsnative.events.Event;
import org.eclipse.vjet.dsf.jsnative.events.EventException;
import org.eclipse.vjet.dsf.jsnative.events.EventTarget;
import org.eclipse.vjet.dsf.liveconnect.client.NativeEvent;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.mozilla.mod.javascript.Undefined;
import org.w3c.dom.DOMException;

public class AHtmlDocument
extends ADocument
implements HtmlDocument,
DocumentEvent,
EventTarget,
IEventListenersCollector {
    private static final long serialVersionUID = 1L;
    private AHtmlCollection m_anchors;
    private AHtmlCollection m_applets;
    private AHtmlCollection m_forms;
    private AHtmlCollection m_frames;
    private AHtmlCollection m_images;
    private AHtmlCollection m_links;
    private StringBuilder m_buffer = new StringBuilder();
    private IDocListener m_docListener;
    private DHtmlDocument m_ddoc;
    private IDomEventBindingListener m_domEventBindingListener;
    private IDomEventPublisher m_eventDispatcher;
    private IBrowserBinding m_browserBinding;
    private Context m_cx = null;
    private Scriptable m_scope = null;
    private String m_cookie = null;
    private String m_domain = null;
    private String m_referrer = null;
    private String m_URL = null;
    private ALocation m_location;
    private final BrowserType m_browserType;
    private static final String EXEC_COMMAND_JS_METHOD_1 = "document.execCommand(\"{0}\",{1},\"{2}\")";
    private static final String EXEC_COMMAND_JS_METHOD_2 = "document.execCommand(\"{0}\",{1})";
    private ASelection m_selection;
    private static final String MOUSE_EVENTS = "MouseEvents";
    private static final String KEYBOARD_EVENTS = "KeyboardEvent";
    private static final String KEY_EVENTS = "KeyEvents";
    private AWindow m_window;
    private static final String LAST_MODIFIED_PROPERTY = "lastModified";
    private static final String BG_COLOR_PROPERTY = "bgColor";
    private static final String A_LINK_COLOR_PROPERTY = "alinkColor";
    private static final String V_LINK_COLOR_PROPERTY = "vlinkColor";
    private static final String LINK_COLOR_PROPERTY = "linkColor";
    private static final String PROTOCOL_PROPERTY = "protocol";
    private static final String COOKIE_PROPERTY = "cookie";
    private static final String DOMAIN_PROPERTY = "domain";
    private static final String REFERRER_PROPERTY = "referrer";
    private static final String URL_PROPERTY = "URL";
    private static final String FG_COLOR_PROPERTY = "fgColor";
    private static final String READY_STATE_PROPERTY = "readyState";
    private static final String SECURITY_PROPERTY = "security";
    private static final String URL_UNENCODED_PROPERTY = "URLUnencoded";
    private static final String COMPAT_MODE = "compatMode";
    private Map<String, List<AJavaScriptHandlerHolder>> m_listeners = null;
    private static final ArrayList<String> INVALID_EVENTS = new ArrayList();
    private Map<ANode, List<String>> m_deferedANodeEventMap = new LinkedHashMap<ANode, List<String>>();

    static {
        INVALID_EVENTS.add(NativeEvent.resize.toString());
        INVALID_EVENTS.add(NativeEvent.scroll.toString());
        INVALID_EVENTS.add(NativeEvent.load.toString());
        INVALID_EVENTS.add(NativeEvent.unload.toString());
    }

    public AHtmlDocument() {
        this(new DHtmlDocument(), BrowserType.IE_6P);
    }

    public AHtmlDocument(ALocation location, BrowserType browserType) {
        this(new DHtmlDocument(), location, browserType);
    }

    public AHtmlDocument(DHtmlDocument htmlDocument, BrowserType browserType) {
        this(htmlDocument, null, browserType);
    }

    public AHtmlDocument(DHtmlDocument htmlDocument, ALocation location, BrowserType browserType) {
        super((DDocument)htmlDocument, browserType);
        this.m_ddoc = htmlDocument;
        this.m_location = location;
        this.m_browserType = browserType;
        this.populateScriptable(AHtmlDocument.class, this.m_browserType);
    }

    public Event createEvent(String eventType) {
        if (eventType.equalsIgnoreCase(MOUSE_EVENTS)) {
            return new AMouseEvent();
        }
        if (eventType.equalsIgnoreCase(KEYBOARD_EVENTS) || eventType.equalsIgnoreCase(KEY_EVENTS)) {
            return new AKeyEvent();
        }
        return DapEventEngine.getInstance().createEvent(eventType);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        this.assertLegitimateChild((ANode)newChild);
        this.appendChild((ANode)newChild, true);
        this.onElementChange();
        return newChild;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        this.assertLegitimateChild((ANode)newChild);
        this.insertBefore((ANode)newChild, (ANode)refChild, true);
        this.onElementChange();
        return newChild;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.assertLegitimateChild((ANode)newChild);
        super.replaceChild(newChild, oldChild);
        this.onElementChange();
        return oldChild;
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        super.removeChild(oldChild);
        this.onElementChange();
        return oldChild;
    }

    public HtmlElement createElement(String tagName) throws DOMException {
        return (HtmlElement)super.createElement(tagName);
    }

    public HtmlElement getDocumentElement() {
        return (HtmlElement)super.getDocumentElement();
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    public void close() {
    }

    @Override
    public Text createTextNode(String data) {
        return new AText(this, (DText)this.getDDocument().createTextNode(data));
    }

    @Deprecated
    public <T extends HtmlElement> T createElement(AHtmlType<T> type) {
        return type.create(this);
    }

    public NodeList getAll() {
        return this.getElementsByTagName("*");
    }

    public HtmlCollection getAnchors() {
        AHtmlBody body = (AHtmlBody)this.getBody();
        if (body == null) {
            return AHtmlCollection.EMPTY_COLLECTION;
        }
        if (this.m_anchors == null) {
            this.m_anchors = new AHtmlCollection(body, 1);
        }
        return this.m_anchors;
    }

    public HtmlCollection getApplets() {
        AHtmlBody body = (AHtmlBody)this.getBody();
        if (body == null) {
            return AHtmlCollection.EMPTY_COLLECTION;
        }
        if (this.m_applets == null) {
            this.m_applets = new AHtmlCollection(body, 4);
        }
        return this.m_applets;
    }

    public HtmlBody getBody() {
        AHtmlHtml html = this.getHtml();
        if (html == null) {
            return null;
        }
        Node elem = html.getFirstChild();
        while (elem != null) {
            if (elem instanceof AHtmlBody) {
                return (AHtmlBody)elem;
            }
            elem = elem.getNextSibling();
        }
        return null;
    }

    @Override
    public String getCookie() {
        if (this.m_cookie == null) {
            this.m_cookie = this.getValue(COOKIE_PROPERTY, null);
        }
        return this.m_cookie;
    }

    public String getDomain() {
        if (this.m_domain == null) {
            this.m_domain = this.getValue(DOMAIN_PROPERTY, null);
        }
        return this.m_domain;
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
        this.setValue(DOMAIN_PROPERTY, domain);
    }

    public NodeList getElementsByName(String elementName) {
        AElement root = (AElement)this.getDocumentElement();
        if (root == null) {
            return new ANodeList();
        }
        ANodeList answer = new ANodeList();
        root.getElementsByName(elementName, answer);
        return answer;
    }

    public NodeList byName(String elementName) {
        return this.getElementsByName(elementName);
    }

    public HtmlCollection getForms() {
        AHtmlElement body = (AHtmlElement)this.getBody();
        if (body == null) {
            return AHtmlCollection.EMPTY_COLLECTION;
        }
        if (this.m_forms == null) {
            this.m_forms = new AHtmlCollection(body, 2);
        }
        return this.m_forms;
    }

    public Object get(String name, Scriptable start) {
        Object obj = super.get(name, start);
        if (obj == NOT_FOUND) {
            obj = this.findFormObject(name);
        }
        return obj;
    }

    public HtmlCollection getImages() {
        AHtmlElement body = (AHtmlElement)this.getBody();
        if (body == null) {
            return AHtmlCollection.EMPTY_COLLECTION;
        }
        if (this.m_images == null) {
            this.m_images = new AHtmlCollection(body, 3);
        }
        return this.m_images;
    }

    public HtmlCollection getLinks() {
        AHtmlElement body = (AHtmlElement)this.getBody();
        if (body == null) {
            return AHtmlCollection.EMPTY_COLLECTION;
        }
        if (this.m_links == null) {
            this.m_links = new AHtmlCollection(body, 5);
        }
        return this.m_links;
    }

    public Location getLocation() {
        return this.m_location;
    }

    public void setLocation(String url) {
        if (this.m_location != null) {
            try {
                this.m_location.getWindow().setURL(new URL(url));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (this.m_browserBinding != null) {
            this.m_browserBinding.setDocumentProperty("location", "\"" + url + "\"");
        }
    }

    public String getReferrer() {
        if (this.m_referrer == null) {
            this.m_referrer = this.getValue(REFERRER_PROPERTY, null);
        }
        return this.m_referrer;
    }

    public String getTitle() {
        AHtmlHead head = this.getHead();
        return head == null ? null : head.getTitle();
    }

    public void setTitle(String text) {
        AHtmlHead head = this.getHead();
        if (head == null) {
            AHtmlHtml html = this.getHtml();
            if (html == null) {
                DHtml htm = new DHtml(this.getDDocument());
                html = new AHtmlHtml(this, htm);
                this.appendChild(html);
            }
            head = new AHtmlHead(this, this.getDDocument().getHead());
            html.appendChild(head);
        }
        head.setTitle(text);
    }

    private AHtmlHead getHead() {
        AHtmlHtml html = this.getHtml();
        if (html == null) {
            return null;
        }
        Node elem = html.getFirstChild();
        while (elem != null) {
            if (elem instanceof AHtmlHead) {
                return (AHtmlHead)elem;
            }
            elem = elem.getNextSibling();
        }
        return null;
    }

    public String getURL() {
        if (this.m_URL == null) {
            this.m_URL = this.m_location != null ? this.m_location.getHref() : this.getValue(URL_PROPERTY, null);
        }
        return this.m_URL;
    }

    public void open() {
    }

    public void setBody(AHtmlElement body) {
        if (!AHtmlBody.class.isAssignableFrom(body.getClass())) {
            throw new ADOMException(new DOMException(17, "body is not AHtmlBody type"));
        }
        this.appendChild(body);
    }

    public void setCookie(String cookie) {
        this.m_cookie = cookie;
    }

    public void write(Object text) {
        this.writeToBuffer(NativeJsHelper.toString(text));
        this.callBuilderListener();
    }

    public void writeln(Object text) {
        this.writeToBuffer(NativeJsHelper.toString(text));
        this.m_buffer.append("\n");
        this.callBuilderListener();
    }

    public void setDocListener(IDocListener listener) {
        this.m_docListener = listener;
    }

    public IDocListener getDocListener() {
        return this.m_docListener;
    }

    public void setDomEventBindingListener(IDomEventBindingListener listener) {
        this.m_domEventBindingListener = listener;
    }

    public void setEventDispatcher(IDomEventPublisher eventDispatcher) {
        this.m_eventDispatcher = eventDispatcher;
    }

    public String getGeneratedContent() {
        String s = this.m_buffer.toString();
        this.m_buffer.delete(0, this.m_buffer.length());
        return s;
    }

    public Context getScriptContext() {
        return this.m_cx;
    }

    public void setScriptContext(Context cx) {
        this.m_cx = cx;
    }

    public Scriptable getScriptScope() {
        return this.m_scope;
    }

    public void setScriptScope(Scriptable scope) {
        this.m_scope = scope;
    }

    public void setBrowserBinding(IBrowserBinding binding) {
        this.m_browserBinding = binding;
    }

    protected AHtmlHtml getHtml() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof AHtmlHtml) {
                return (AHtmlHtml)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public BrowserType getBrowserType() {
        return this.m_browserType;
    }

    public IDomEventPublisher getEventDispatcher() {
        return this.m_eventDispatcher;
    }

    IDomChangeListener getDomListener() {
        if (this.m_window != null) {
            return this.m_window.getDomListener();
        }
        return null;
    }

    public IDomEventBindingListener getDomEventBindingListener() {
        return this.m_domEventBindingListener;
    }

    IBrowserBinding getBrowserBinding() {
        return this.m_browserBinding;
    }

    DHtmlDocument getDHtmlDocument() {
        return this.m_ddoc;
    }

    private void onElementChange() {
        IDomChangeListener listener = this.getDomListener();
        if (listener != null) {
            listener.onElementChange((BaseHtmlElement)this.getDNode());
        }
    }

    private Object findFormObject(String name) {
        HtmlCollection forms = this.getForms();
        int i = 0;
        while (i < forms.getLength()) {
            AHtmlForm form = (AHtmlForm)forms.item(i);
            if (name.equalsIgnoreCase(form.getName())) {
                return form;
            }
            ++i;
        }
        return NOT_FOUND;
    }

    public DHtmlDocument getDDocument() {
        return (DHtmlDocument)this.getDNode();
    }

    private void assertLegitimateChild(ANode child) {
        if (child == null) {
            return;
        }
        Class<?> newChildsClass = child.getClass();
        if (AHtmlHtml.class.isAssignableFrom(newChildsClass)) {
            return;
        }
        throw new ADOMException(new DOMException(16, "HtmlDocument children can be HtmlDocType(0..1), HtmlHtmlElement(0..1), ProcessingInstruction(0..n), Comment(0..n)"));
    }

    private void callBuilderListener() {
        if (this.m_docListener != null) {
            this.m_docListener.doneDocumentWrite();
        }
    }

    private void writeToBuffer(Object ... args) {
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null && !(o instanceof Undefined)) {
                this.m_buffer.append(this.toStringValue(o));
            }
            ++n2;
        }
    }

    @Override
    public String toString() {
        return this.getNodeName();
    }

    private String toStringValue(Object o) {
        if (o instanceof ScriptableObject) {
            o = ((ScriptableObject)o).getDefaultValue(null);
        }
        return o.toString();
    }

    private String getValue(String name, String fallback) {
        String value;
        if (this.m_browserBinding != null && (value = this.m_browserBinding.getDocumentProperty(name)) != null) {
            return value;
        }
        return fallback;
    }

    public HtmlCollection getFrames() {
        AHtmlElement body = (AHtmlElement)this.getBody();
        if (body == null) {
            return AHtmlCollection.EMPTY_COLLECTION;
        }
        if (this.m_frames == null) {
            this.m_frames = new AHtmlCollection(body, 9);
        }
        return this.m_frames;
    }

    public boolean execCommand(String command) {
        return this.execCommand(command, false, null);
    }

    public boolean execCommand(String command, boolean userInterface) {
        return this.execCommand(command, userInterface, null);
    }

    public boolean execCommand(String command, boolean userInterface, Object value) {
        String ret = "";
        if (this.m_browserBinding != null) {
            ret = value == null || value.toString().equals("undefined") ? this.m_browserBinding.executeJs(MessageFormat.format(EXEC_COMMAND_JS_METHOD_2, command, userInterface)) : this.m_browserBinding.executeJs(MessageFormat.format(EXEC_COMMAND_JS_METHOD_1, command, userInterface, value));
        }
        return ret.equalsIgnoreCase("true");
    }

    public Selection getSelection() {
        if (this.m_selection == null) {
            this.m_selection = new ASelection(this.m_browserType, this.m_browserBinding);
        }
        return this.m_selection;
    }

    public Window getDefaultView() {
        return this.m_window;
    }

    public Window getParentWindow() {
        return this.m_window;
    }

    @Override
    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return this.getClass().getName();
        }
        return null;
    }

    public AWindow getWindow() {
        return this.m_window;
    }

    public void setWindow(AWindow m_window) {
        this.m_window = m_window;
    }

    @Override
    public String getLastModified() {
        return this.getValue(LAST_MODIFIED_PROPERTY, null);
    }

    @Override
    public String getBgColor() {
        return this.getValue(BG_COLOR_PROPERTY, null);
    }

    @Override
    public String getAlinkColor() {
        return this.getValue(A_LINK_COLOR_PROPERTY, null);
    }

    @Override
    public String getLinkColor() {
        return this.getValue(LINK_COLOR_PROPERTY, null);
    }

    @Override
    public String getVlinkColor() {
        return this.getValue(V_LINK_COLOR_PROPERTY, null);
    }

    @Override
    public String getProtocol() {
        return this.getValue(PROTOCOL_PROPERTY, null);
    }

    @Override
    public String getFgColor() {
        return this.getValue(FG_COLOR_PROPERTY, null);
    }

    @Override
    public String getReadyState() {
        return this.getValue(READY_STATE_PROPERTY, null);
    }

    @Override
    public String getSecurity() {
        return this.getValue(SECURITY_PROPERTY, null);
    }

    public String getURLUnencoded() {
        return this.getValue(URL_UNENCODED_PROPERTY, null);
    }

    public void addEventListener(String type, Object listener, boolean useCapture) {
        if (this.isValidEvent(type)) {
            this.addListener(type, listener, useCapture, true, AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE.EXTERNAL);
        }
    }

    public void add(String type, Object listener, boolean useCapture) {
        this.addEventListener(type, listener, useCapture);
    }

    public void attachEvent(String type, Object listener) {
        if (this.isValidEvent(type)) {
            this.addListener(type, listener, false, true, AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE.EXTERNAL);
        }
    }

    @Override
    public void addListener(String type, Object listener, boolean useCapture, boolean bind, AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE handlerType) {
        type = AHtmlHelper.getCorrectType(type);
        AHtmlHelper.addEventHandlerListeners(this.getListeners(), type, listener, handlerType);
        IDomEventBindingListener evtBindingListener = this.getDomEventBindingListener();
        if (evtBindingListener != null && evtBindingListener.isEventBinding((org.w3c.dom.Node)this.getDDocument(), type) && bind) {
            evtBindingListener.eventBound((org.w3c.dom.Node)this.getDDocument(), type);
        }
    }

    @Override
    public void removeListener(String type, Object listener, boolean useCapture) {
        List<AJavaScriptHandlerHolder> lst;
        if (this.m_listeners != null && this.m_listeners.get(type) == null && (lst = this.m_listeners.get(type)) != null) {
            int i = 0;
            while (i < lst.size()) {
                if (lst.get(i).equals(listener)) {
                    lst.remove(i);
                }
                ++i;
            }
        }
    }

    @Override
    public Map<String, List<AJavaScriptHandlerHolder>> getListeners() {
        if (this.m_listeners == null) {
            this.m_listeners = new HashMap<String, List<AJavaScriptHandlerHolder>>();
        }
        return this.m_listeners;
    }

    public boolean dispatchEvent(Event evt) throws EventException {
        String evtType = AHtmlHelper.getCorrectType(evt.getType());
        return this.dispatchEvent(evtType, this);
    }

    public boolean fireEvent(String evtType) {
        evtType = AHtmlHelper.getCorrectType(evtType);
        return this.dispatchEvent(evtType, this);
    }

    public void removeEventListener(String type, Object listener, boolean useCapture) {
        type = AHtmlHelper.getCorrectType(type);
        this.removeListener(type, listener, useCapture);
    }

    protected boolean dispatchEvent(String evtType, EventTarget src) {
        evtType = AHtmlHelper.getCorrectType(evtType);
        IDomEventPublisher dispatcher = this.getEventDispatcher();
        if (dispatcher == null) {
            return false;
        }
        return dispatcher.publish(evtType, src);
    }

    private boolean isValidEvent(String type) {
        return !INVALID_EVENTS.contains(type = AHtmlHelper.getCorrectType(type));
    }

    public void detachEvent(String type, Object listener) {
        this.removeListener(type, listener, false);
    }

    @Override
    public String getNodeName() {
        if (this.m_browserType == null) {
            return super.getNodeName();
        }
        if (this.m_browserType.isFireFox()) {
            return "[object HTMLDocument]";
        }
        if (this.m_browserType.isIE()) {
            return "[object]";
        }
        return super.getNodeName();
    }

    public Object getOnClick() {
        return this.getListener(EventType.CLICK.getName());
    }

    public Object getOnclick() {
        return this.getOnClick();
    }

    public Object getOnDblClick() {
        return this.getListener(EventType.DBLCLICK.getName());
    }

    public Object getOndblclick() {
        return this.getOnDblClick();
    }

    public Object getOnKeyDown() {
        return this.getListener(EventType.KEYDOWN.getName());
    }

    public Object getOnkeydown() {
        return this.getOnKeyDown();
    }

    public Object getOnKeyPress() {
        return this.getListener(EventType.KEYPRESS.getName());
    }

    public Object getOnkeypress() {
        return this.getOnKeyPress();
    }

    public Object getOnKeyUp() {
        return this.getListener(EventType.KEYUP.getName());
    }

    public Object getOnkeyup() {
        return this.getOnKeyUp();
    }

    public Object getOnMouseDown() {
        return this.getListener(EventType.MOUSEDOWN.getName());
    }

    public Object getOnmousedown() {
        return this.getOnMouseDown();
    }

    public Object getOnMouseMove() {
        return this.getListener(EventType.MOUSEMOVE.getName());
    }

    public Object getOnmousemove() {
        return this.getOnMouseMove();
    }

    public Object getOnMouseOut() {
        return this.getListener(EventType.MOUSEOUT.getName());
    }

    public Object getOnmouseout() {
        return this.getOnMouseOut();
    }

    public Object getOnMouseOver() {
        return this.getListener(EventType.MOUSEOVER.getName());
    }

    public Object getOnmouseover() {
        return this.getOnMouseOver();
    }

    public Object getOnMouseUp() {
        return this.getListener(EventType.MOUSEUP.getName());
    }

    public Object getOnmouseup() {
        return this.getOnMouseUp();
    }

    public void setOnClick(Object functionRef) {
        this.registerAndBind(EventType.CLICK.getName(), functionRef);
    }

    public void setOnclick(Object functionRef) {
        this.setOnClick(functionRef);
    }

    public void setOnDblClick(Object functionRef) {
        this.registerAndBind(EventType.DBLCLICK.getName(), functionRef);
    }

    public void setOndblclick(Object functionRef) {
        this.setOnDblClick(functionRef);
    }

    public void setOnKeyDown(Object functionRef) {
        this.registerAndBind(EventType.KEYDOWN.getName(), functionRef);
    }

    public void setOnkeydown(Object functionRef) {
        this.setOnKeyDown(functionRef);
    }

    public void setOnKeyPress(Object functionRef) {
        this.registerAndBind(EventType.KEYPRESS.getName(), functionRef);
    }

    public void setOnkeypress(Object functionRef) {
        this.setOnKeyPress(functionRef);
    }

    public void setOnKeyUp(Object functionRef) {
        this.registerAndBind(EventType.KEYUP.getName(), functionRef);
    }

    public void setOnkeyup(Object functionRef) {
        this.setOnKeyUp(functionRef);
    }

    public void setOnMouseDown(Object functionRef) {
        this.registerAndBind(EventType.MOUSEDOWN.getName(), functionRef);
    }

    public void setOnmousedown(Object functionRef) {
        this.setOnMouseDown(functionRef);
    }

    public void setOnMouseMove(Object functionRef) {
        this.registerAndBind(EventType.MOUSEMOVE.getName(), functionRef);
    }

    public void setOnmousemove(Object functionRef) {
        this.setOnMouseMove(functionRef);
    }

    public void setOnMouseOut(Object functionRef) {
        this.registerAndBind(EventType.MOUSEOUT.getName(), functionRef);
    }

    public void setOnmouseout(Object functionRef) {
        this.setOnMouseOut(functionRef);
    }

    public void setOnMouseOver(Object functionRef) {
        this.registerAndBind(EventType.MOUSEOVER.getName(), functionRef);
    }

    public void setOnmouseover(Object functionRef) {
        this.setOnMouseOver(functionRef);
    }

    public void setOnMouseUp(Object functionRef) {
        this.registerAndBind(EventType.MOUSEUP.getName(), functionRef);
    }

    public void setOnmouseup(Object functionRef) {
        this.setOnMouseUp(functionRef);
    }

    public void registerAndBind(String type, Object handler) {
        this.addListener(type, handler, false, true, AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE.INLINE);
    }

    public Object getListener(String type) {
        Map<String, List<AJavaScriptHandlerHolder>> listeners = this.getListeners();
        List<AJavaScriptHandlerHolder> lst = listeners.get(type);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        AJavaScriptHandlerHolder h = lst.get(0);
        if (h == null || h.getHandlerType() != AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE.INLINE) {
            return null;
        }
        return h.getHandler();
    }

    public Map<ANode, List<String>> getDeferedANodeEventMap() {
        return this.m_deferedANodeEventMap;
    }

    public Object getOnReadyStateChange() {
        return this.getListener(EventType.READYSTATECHANGE.getName());
    }

    public void setOnReadyStateChange(Object functionRef) {
        this.registerAndBind(EventType.READYSTATECHANGE.getName(), functionRef);
    }

    public Object getOnreadystatechange() {
        return this.getOnReadyStateChange();
    }

    public void setOnreadystatechange(Object functionRef) {
        this.setOnReadyStateChange(functionRef);
    }

    public void __createStyleSheet(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (arg1 instanceof Undefined) {
            this.createStyleSheet();
        } else {
            this.createStyleSheet((String)arg1);
        }
    }

    public void createStyleSheet() {
        this.createStyleSheet(null, 0);
    }

    public void createStyleSheet(String url) {
        this.createStyleSheet(url, 0);
    }

    public void createStyleSheet(String url, int index) {
        HtmlHead head = (HtmlHead)this.getElementsByTagName("head").item(0);
        if (url != null) {
            HtmlLink link = (HtmlLink)this.createElement("link");
            link.setRel("stylesheet");
            link.setType("text/css");
            link.setHref(url);
            if (head != null) {
                head.appendChild((Node)link);
            }
        } else {
            HtmlStyle style = (HtmlStyle)this.createElement("style");
            if (head != null) {
                head.appendChild((Node)style);
            }
        }
    }

    public String getCompatMode() {
        return this.getValue(COMPAT_MODE, "BackCompat");
    }

    @Override
    public void setBgColor(String value) {
        this.setValue(BG_COLOR_PROPERTY, value);
    }

    @Override
    public void setFgColor(String value) {
        this.setValue(FG_COLOR_PROPERTY, value);
    }

    @Override
    public void setLinkColor(String value) {
        this.setValue(LINK_COLOR_PROPERTY, value);
    }

    public HtmlElement byId(String elementId) {
        return this.getElementById(elementId);
    }

    public HtmlElement getElementById(String elementId) {
        return (HtmlElement)super.getElementById(elementId);
    }

    private void setValue(String name, String value) {
        if (this.m_browserBinding != null) {
            if (!value.startsWith("'") || !value.startsWith("\"")) {
                value = "'" + value;
            }
            if (!value.endsWith("'") || !value.endsWith("\"")) {
                value = String.valueOf(value) + "'";
            }
            this.m_browserBinding.setDocumentProperty(name, value);
        }
    }

    public Node all(int index) {
        return this.getAll().item(index);
    }

    public NodeList all(String id) {
        ANodeList result = (ANodeList)this.getElementsByName(id);
        HtmlElement node = this.getElementById(id);
        if (node != null) {
            result.add((ANode)node);
        }
        return result;
    }

    public Node all(String id, int subIndex) {
        return this.all(id).item(subIndex);
    }

    public Event createEventObject() {
        return null;
    }

    public Event createEventObject(Event evt) {
        return null;
    }

    public Event createEventObject(String eventType) {
        return DapEventEngine.getInstance().createEvent(eventType);
    }

    public Event __createEventObject(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (arg1 == null) {
            return this.createEventObject();
        }
        if (arg1 instanceof String) {
            return this.createEventObject((String)arg1);
        }
        if (arg1 instanceof Event) {
            return this.createEventObject((Event)arg1);
        }
        return null;
    }

    public StyleSheetList getStyleSheets() {
        return null;
    }

    public Range createRange() {
        return null;
    }

    public HtmlDOMImplementation getHtmlImplementation() {
        return null;
    }
}

