/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.xerces.util.XMLChar;
import org.eclipse.vjet.dsf.active.client.AHtmlParser;
import org.eclipse.vjet.dsf.active.client.ALocation;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.dom.html.ADOMException;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlBody;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlButton;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlForm;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlFrame;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHead;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlIFrame;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlInput;
import org.eclipse.vjet.dsf.active.dom.html.AJavaScriptHandlerHolder;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.active.dom.html.AText;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.js.URLUtil;
import org.eclipse.vjet.dsf.jsnative.HtmlBody;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.HtmlElement;
import org.eclipse.vjet.dsf.jsnative.HtmlSelect;
import org.eclipse.vjet.dsf.jsnative.HtmlSpan;
import org.eclipse.vjet.dsf.jsnative.Node;
import org.eclipse.vjet.dsf.jsnative.NodeList;
import org.eclipse.vjet.dsf.jsnative.Text;
import org.eclipse.vjet.dsf.jsnative.events.EventTarget;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.Undefined;
import org.mozilla.mod.javascript.UniqueTag;
import org.w3c.dom.DOMException;

public class AHtmlHelper {
    private static final String DOCUMENT_DOT_BODY = "document.body";
    private static final String DOCUMENT_DOT_DOCUMENTELEMENT = "document.documentElement";
    private static List<String> m_jsNativeSpecialProps = new ArrayList<String>();

    static {
        m_jsNativeSpecialProps.add("NaN");
        m_jsNativeSpecialProps.add("Infinity");
        m_jsNativeSpecialProps.add("URLUnencoded");
    }

    public static ANode getElementByPath(HtmlDocument doc, String jsString) {
        if (doc == null || jsString == null) {
            return null;
        }
        if (!jsString.startsWith(DOCUMENT_DOT_BODY)) {
            throw new RuntimeException("Invalid JavaScript input statement");
        }
        StringTokenizer st = new StringTokenizer(jsString, ".");
        st.nextToken();
        st.nextToken();
        HtmlBody body = doc.getBody();
        if (body == null) {
            return null;
        }
        HtmlBody currNode = body;
        block0: while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("childNodes")) {
                int index = Integer.parseInt(token.substring(token.indexOf(91) + 1, token.indexOf(93)));
                NodeList nl = currNode.getChildNodes();
                if ((currNode = nl.item(index)) != null) continue;
                return null;
            }
            if (st.hasMoreTokens()) {
                throw new RuntimeException("Invalid JavaScript input statement");
            }
            Node child = currNode.getFirstChild();
            while (child != null) {
                if (child.getNodeName().equals(token)) {
                    currNode = child;
                    continue block0;
                }
                child = child.getNextSibling();
            }
        }
        return (ANode)currNode;
    }

    public static ANode getElementByPath(HtmlElement docElem, String jsString) {
        if (docElem == null || jsString == null) {
            return null;
        }
        if (!jsString.startsWith(DOCUMENT_DOT_DOCUMENTELEMENT)) {
            throw new RuntimeException("Invalid JavaScript input statement");
        }
        StringTokenizer st = new StringTokenizer(jsString, ".");
        st.nextToken();
        st.nextToken();
        if (docElem == null) {
            return null;
        }
        HtmlElement currNode = docElem;
        block0: while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("childNodes")) {
                int index = Integer.parseInt(token.substring(token.indexOf(91) + 1, token.indexOf(93)));
                NodeList nl = currNode.getChildNodes();
                if ((currNode = nl.item(index)) != null) continue;
                return null;
            }
            if (st.hasMoreTokens()) {
                throw new RuntimeException("Invalid JavaScript input statement");
            }
            Node child = currNode.getFirstChild();
            while (child != null) {
                if (child.getNodeName().equals(token)) {
                    currNode = child;
                    continue block0;
                }
                child = child.getNextSibling();
            }
        }
        return (ANode)currNode;
    }

    public static String getElementPath(AHtmlElement node) {
        if (node != null) {
            if (node.getId() != null && node.getId() != "") {
                return "document.getElementById('" + node.getId() + "')";
            }
            return AHtmlHelper.getPath(node);
        }
        return null;
    }

    public static String getFormPath(EventTarget target) {
        if (!(target instanceof AHtmlButton) && !(target instanceof AHtmlInput)) {
            return null;
        }
        ANode node = (ANode)target;
        AHtmlForm form = AHtmlHelper.getContainingForm(node);
        if (form == null) {
            return null;
        }
        if (node instanceof AHtmlButton || node instanceof AHtmlInput && ((AHtmlInput)node).getType().equals("submit")) {
            return AHtmlHelper.getElementPath(form);
        }
        return null;
    }

    public static AHtmlForm getContainingForm(ANode node) {
        while (node != null) {
            ANode parent = (ANode)node.getParentNode();
            if (parent != null && parent instanceof AHtmlForm) {
                return (AHtmlForm)parent;
            }
            node = parent;
        }
        return null;
    }

    private static String getPath(ANode node) {
        if (node instanceof AHtmlBody) {
            return DOCUMENT_DOT_BODY;
        }
        if (node instanceof AHtmlHead) {
            return "document.getElementsByTagName('head').item(0)";
        }
        int ind = AHtmlHelper.getIndex(node);
        String path = AHtmlHelper.getPath((AHtmlElement)node.getParentNode());
        path = String.valueOf(path) + ".childNodes[" + ind + "]";
        return path;
    }

    private static int getIndex(ANode node) {
        if (node.getPreviousSibling() == null) {
            return 0;
        }
        return AHtmlHelper.getIndex((ANode)node.getPreviousSibling()) + 1;
    }

    public static void setText(HtmlSpan span, String text) {
        Text textNode = AHtmlHelper.getTextNode((Node)span);
        if (text == null || text.length() == 0) {
            if (textNode == null) {
                return;
            }
            span.removeChild((Node)textNode);
        } else if (textNode == null) {
            AHtmlDocument doc = (AHtmlDocument)span.getOwnerDocument();
            textNode = doc.createTextNode(text);
            span.appendChild((Node)textNode);
        } else {
            textNode.setData(text);
        }
    }

    public static Text getTextNode(Node node) {
        NodeList children = node.getChildNodes();
        if (children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i) instanceof AText) {
                    return (AText)children.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static void removeAllOptions(HtmlSelect selectElem) {
        int i = selectElem.getLength() - 1;
        while (i >= 0) {
            selectElem.removeByIndex(i);
            --i;
        }
    }

    public static void setContentDocument(AHtmlFrame elem, AHtmlDocument doc) {
        elem.setContentDocument(doc);
    }

    public static void setContentDocument(AHtmlIFrame elem, AHtmlDocument doc) {
        elem.setContentDocument(doc);
    }

    public static boolean booleanValueOf(EHtmlAttr attr, String val) {
        if (val.equals(attr.getAttributeName())) {
            return true;
        }
        return Boolean.valueOf(val);
    }

    public static AHtmlDocument getContentDocument(AHtmlElement frame, String src) {
        AWindow frameWindow;
        URL url;
        if (frame == null) {
            return null;
        }
        AHtmlDocument doc = frame.getOwnerDocument();
        if (doc == null) {
            return null;
        }
        ALocation location = (ALocation)doc.getLocation();
        if (location == null) {
            return null;
        }
        AWindow ParentWindow = location.getWindow();
        if (ParentWindow == null) {
            return null;
        }
        String pageUrl = null;
        if (location.getHref() != null) {
            pageUrl = URLUtil.getBaseURL(location.getHref());
        }
        try {
            url = new URL(URLUtil.getAbsoluteURL(src, pageUrl));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        try {
            frameWindow = (AWindow)AHtmlParser.parse(url);
            frameWindow.setParent(ParentWindow);
            ParentWindow.addChildWindow(frameWindow);
            frameWindow.setName(frame.getAttribute(EHtmlAttr.name.name()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        AHtmlDocument frameDoc = (AHtmlDocument)frameWindow.getDocument();
        return frameDoc;
    }

    public static ANode getElementReference(String elementByPath, String elementId) {
        ANode elem = null;
        HtmlDocument doc = DapCtx.ctx().getWindow().getDocument();
        if (elementByPath != null && elementByPath.indexOf(DOCUMENT_DOT_BODY) != -1) {
            elem = AHtmlHelper.getElementByPath(doc, elementByPath);
        } else if (elementByPath != null && elementByPath.indexOf(DOCUMENT_DOT_DOCUMENTELEMENT) != -1) {
            elem = AHtmlHelper.getElementByPath(doc.getDocumentElement(), elementByPath);
        } else if (elementId != null) {
            elem = (ANode)doc.getElementById(elementId);
        }
        return elem;
    }

    public static ANode getElementByPath(String jsString) {
        HtmlDocument doc = DapCtx.ctx().getWindow().getDocument();
        return AHtmlHelper.getElementByPath(doc, jsString);
    }

    public static void checkQualifiedName(String qname) {
        int i;
        if (qname == null || qname.length() == 0) {
            throw new ADOMException(new DOMException(14, "QName has invalid format"));
        }
        int index = qname.indexOf(58);
        int lastIndex = qname.lastIndexOf(58);
        int length = qname.length();
        if (index == 0 || index == length - 1 || lastIndex != index) {
            throw new ADOMException(new DOMException(14, "QName has invalid format"));
        }
        int start = 0;
        if (index > 0) {
            if (!XMLChar.isNCNameStart((int)qname.charAt(start))) {
                throw new ADOMException(new DOMException(5, "QName has invalid format"));
            }
            i = 1;
            while (i < index) {
                if (!XMLChar.isNCName((int)qname.charAt(i))) {
                    throw new ADOMException(new DOMException(5, "QName has invalid format"));
                }
                ++i;
            }
            start = index + 1;
        }
        if (!XMLChar.isNCNameStart((int)qname.charAt(start))) {
            throw new ADOMException(new DOMException(5, "QName has invalid format"));
        }
        i = start + 1;
        while (i < length) {
            if (!XMLChar.isNCName((int)qname.charAt(i))) {
                throw new ADOMException(new DOMException(5, "QName has invalid format"));
            }
            ++i;
        }
    }

    public static String getOriginalPropertyName(String propName) {
        if (propName == null) {
            return null;
        }
        if (m_jsNativeSpecialProps.contains(propName)) {
            return propName;
        }
        if (AHtmlHelper.isNameAllCapitalized(propName)) {
            return propName;
        }
        return String.valueOf(propName.substring(0, 1).toLowerCase()) + propName.substring(1);
    }

    public static boolean isNameAllCapitalized(String name) {
        char[] chars;
        char[] cArray = chars = name.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isLetter(ch) && !Character.isUpperCase(ch)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String getCorrectType(String type) {
        if (type.substring(0, 2).equals("on")) {
            type = type.substring(2);
        }
        return type;
    }

    public static double getDoubleAttributeValue(String atrrName, Scriptable scriptableObject) {
        Object val = AHtmlHelper.getAttributeValue(atrrName, scriptableObject);
        if (val != null) {
            return (Double)val;
        }
        return 0.0;
    }

    public static String getStringAttributeValue(String atrrName, Scriptable scriptableObject) {
        Object val = AHtmlHelper.getAttributeValue(atrrName, scriptableObject);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public static boolean getBooleanAttributeValue(String atrrName, Scriptable scriptableObject) {
        Object val = AHtmlHelper.getAttributeValue(atrrName, scriptableObject);
        if (val != null) {
            return (Boolean)val;
        }
        return false;
    }

    public static long getLongAttributeValue(String atrrName, Scriptable scriptableObject) {
        Object val = AHtmlHelper.getAttributeValue(atrrName, scriptableObject);
        if (val != null) {
            try {
                Double dblVal = Double.parseDouble(val.toString());
                return dblVal.longValue();
            }
            catch (Exception exception) {}
        }
        return 0L;
    }

    public static int getIntAttributeValue(String atrrName, Scriptable scriptableObject) {
        Object val = AHtmlHelper.getAttributeValue(atrrName, scriptableObject);
        if (val != null) {
            String strVal = val.toString();
            int idx = strVal.indexOf(".");
            if (idx != -1) {
                strVal = strVal.substring(0, idx);
            }
            try {
                return Integer.parseInt(strVal);
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    public static Object getAttributeValue(String atrrName, Scriptable scriptableObject) {
        Object value;
        block3: {
            try {
                value = scriptableObject.get(atrrName, scriptableObject);
                if (!(value instanceof UniqueTag) && !(value instanceof Undefined)) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return value;
    }

    public static void addEventHandlerListeners(Map<String, List<AJavaScriptHandlerHolder>> listeners, String type, Object listener, AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE handlerType) {
        List<AJavaScriptHandlerHolder> lst = listeners.get(type = AHtmlHelper.getCorrectType(type));
        if (lst == null) {
            lst = new ArrayList<AJavaScriptHandlerHolder>(2);
            listeners.put(type, lst);
        }
        AJavaScriptHandlerHolder holder = new AJavaScriptHandlerHolder(listener, handlerType);
        if (handlerType.equals((Object)AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE.INLINE)) {
            if (lst.size() == 0) {
                lst.add(0, holder);
            } else {
                lst.set(0, holder);
            }
        } else {
            lst.add(holder);
        }
    }
}

