/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.util;

import org.eclipse.vjet.dsf.active.client.ScriptExecutor;
import org.eclipse.vjet.dsf.active.util.IAsyncTask;
import org.eclipse.vjet.dsf.active.util.WindowTaskManager;
import org.eclipse.vjet.dsf.dap.proxy.INativeJsFuncProxy;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.Scriptable;

public class WindowTask {
    private final int m_id;
    private final Object m_jsCode;
    private final Scriptable m_scope;
    private final Context m_ctx;
    protected final WindowTaskManager m_mgr;
    private final DapCtx m_savedCtx;
    private static final Object[] EMPTY_ARG = new Object[0];

    public WindowTask(Object jsCode, Scriptable scope, Context ctx, WindowTaskManager mgr) {
        this.m_jsCode = jsCode;
        this.m_scope = scope;
        this.m_ctx = ctx;
        this.m_mgr = mgr;
        this.m_id = this.m_mgr.createId();
        this.m_savedCtx = DapCtx.ctx();
        this.m_mgr.add(this);
    }

    public int getId() {
        return this.m_id;
    }

    public void execute() {
        if (this.m_mgr.isCanceled(this)) {
            return;
        }
        Context.enter();
        Object jsCode = this.m_jsCode;
        if (jsCode instanceof IAsyncTask) {
            jsCode = ((IAsyncTask)this.m_jsCode).getJsCode();
        }
        if (jsCode != null) {
            this.m_savedCtx.setSameCxtForCurrentThread();
            if (jsCode instanceof Function) {
                Function f = (Function)jsCode;
                f.call(this.m_ctx, this.m_scope, f.getParentScope(), EMPTY_ARG);
            } else if (jsCode instanceof INativeJsFuncProxy) {
                Function nativef;
                Function f = nativef = ((INativeJsFuncProxy)jsCode).getJsNative();
                f.call(this.m_ctx, this.m_scope, f.getParentScope(), EMPTY_ARG);
            } else {
                ScriptExecutor.executeScript(jsCode.toString(), this.m_scope, this.m_ctx);
            }
        }
        this.doneExec();
    }

    protected void doneExec() {
        this.m_mgr.cancel(this.getId());
    }
}

