/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.proxy;

import org.eclipse.vjet.dsf.dap.proxy.JFunction;
import org.eclipse.vjet.dsf.dap.proxy.JFunctionX;
import org.eclipse.vjet.dsf.dap.proxy.JType;
import org.eclipse.vjet.dsf.dap.proxy.NativeJsHelper;
import org.eclipse.vjet.dsf.dap.proxy.ScriptEngineCtx;
import org.mozilla.mod.javascript.BaseFunction;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.NativeArray;
import org.mozilla.mod.javascript.Scriptable;

class NoScopeFunc
extends BaseFunction {
    private static final long serialVersionUID = 1L;
    private final JFunction m_func;
    private static final Object[] EMPTY_ARGS = new Object[0];

    private NoScopeFunc(JFunction func) {
        this.m_func = func;
        this.defineProperty("call", (Object)this, 7);
        this.defineProperty("apply", (Object)this, 7);
        this.defineProperty("toString", (Object)this, 7);
    }

    static JFunction def(JType type, String funcName, Class returnType) {
        JFunction func = JFunctionX.def(type, funcName, returnType);
        NoScopeFunc wrapper = new NoScopeFunc(func);
        return new JFunction((Function)wrapper);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object passedInScope = null;
        if (args.length == 0) {
            return this.toString();
        }
        passedInScope = args[0];
        try {
            ScriptEngineCtx.ctx().pushScopeToStack(passedInScope);
            Object[] realArgs = EMPTY_ARGS;
            if (args.length > 1) {
                if (args.length == 2 && args[1] instanceof NativeArray) {
                    NativeArray nArr = (NativeArray)args[1];
                    int len = (int)nArr.getLength();
                    realArgs = new Object[len];
                    int i = 0;
                    while (i < len) {
                        realArgs[i] = nArr.get(i, (Scriptable)nArr);
                        ++i;
                    }
                } else {
                    realArgs = new Object[args.length - 1];
                    int i = 1;
                    while (i < args.length) {
                        realArgs[i - 1] = args[i];
                        ++i;
                    }
                }
            }
            Object object = NativeJsHelper.toNative(this.m_func.apply(null, realArgs));
            return object;
        }
        finally {
            ScriptEngineCtx.ctx().popScopeFromStack();
        }
    }

    public String toString() {
        return this.m_func.toString();
    }

    public Object getDefaultValue(Class typeHint) {
        if (typeHint == null || typeHint == String.class) {
            return this.toString();
        }
        if (typeHint == Boolean.class || typeHint == Boolean.TYPE) {
            return Boolean.TRUE;
        }
        return NoScopeFunc.getDefaultValue((Scriptable)this, (Class)typeHint);
    }
}

