/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.active.client.ANavigator;
import org.eclipse.vjet.dsf.active.client.APlugin;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlAnchor;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlButton;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlFactory;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.active.event.IDomChangeListener;
import org.eclipse.vjet.dsf.active.event.IDomEventBindingListener;
import org.eclipse.vjet.dsf.dap.event.DapEvent;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapDomChangeListener;
import org.eclipse.vjet.dsf.dap.rt.DapEventCreator;
import org.eclipse.vjet.dsf.dap.rt.DapEventDispatcher;
import org.eclipse.vjet.dsf.dap.rt.DapEventEngine;
import org.eclipse.vjet.dsf.dap.rt.DapFlashProxy;
import org.eclipse.vjet.dsf.dap.rt.DapWindowManager;
import org.eclipse.vjet.dsf.html.dom.DObject;
import org.eclipse.vjet.dsf.liveconnect.IDLCDispatcher;
import org.eclipse.vjet.dsf.liveconnect.client.DLCEvent;
import org.eclipse.vjet.dsf.liveconnect.client.simple.SimpleDLCEventTypes;

public class DapBrowserEngine {
    private static DapEventCreator s_eventGenerator = DapEventCreator.getInstance();
    private static DapEventDispatcher s_dapEventDispatcher = DapEventDispatcher.getInstance();
    private DapWindowManager m_windowManager;
    private IDLCDispatcher m_dlcDispatcher;
    private static Map<String, String> s_eventMap = new HashMap<String, String>();

    static {
        s_eventMap.put("linkClick", SimpleDLCEventTypes.CLICK);
        s_eventMap.put("linkDblClick", SimpleDLCEventTypes.DBLCLICK);
        s_eventMap.put("submitButtonClick", SimpleDLCEventTypes.CLICK);
        s_eventMap.put("imageLoad", SimpleDLCEventTypes.LOAD);
        s_eventMap.put("scriptLoad", SimpleDLCEventTypes.LOAD);
        s_eventMap.put("radioChange", SimpleDLCEventTypes.CLICK);
        s_eventMap.put("scriptReadyStateChange", SimpleDLCEventTypes.READY_STATE_CHANGE);
    }

    public DapBrowserEngine(String html, IBrowserBinding browserBinding, IDLCDispatcher dlcDispatcher, List<IDomChangeListener> domChangeListeners, IDomEventBindingListener domEventBindingListener) {
        this.m_dlcDispatcher = dlcDispatcher;
        if (domChangeListeners == null) {
            domChangeListeners = new ArrayList<IDomChangeListener>(1);
        }
        domChangeListeners.add(new DapDomChangeListener(this.m_dlcDispatcher));
        AWindow window = DapCtx.window();
        if (window != null) {
            window.finialize();
        }
        DapCtx.ctx().setEventDispatcher(s_dapEventDispatcher);
        this.m_windowManager = new DapWindowManager(html, domChangeListeners, DapEventEngine.getInstance(), domEventBindingListener, browserBinding);
        DapBrowserEngine.registerObjectType("flash_proxy", DapFlashProxy.class);
        window = DapCtx.ctx().getWindow();
        APlugin flashPlugin = new APlugin(window.getBrowserType());
        flashPlugin.setName("Shockwave Flash");
        flashPlugin.setDescription("Shockwave Flash 10.0 r12");
        ((ANavigator)window.getNavigator()).addPlugin(flashPlugin);
    }

    public AWindow getWindow() {
        return this.m_windowManager.getWindow();
    }

    public IDLCDispatcher getDispatcher() {
        return this.m_dlcDispatcher;
    }

    public void onReceive(DLCEvent event) {
        String eventType = event.getType();
        DapEvent dapEvent = this.getDapEvent(event);
        if (SimpleDLCEventTypes.SUBMIT.equals(eventType)) {
            dapEvent = this.getDapEvent(event);
            if (s_dapEventDispatcher.dispatchEvent(dapEvent)) {
                this.m_dlcDispatcher.send(String.valueOf(event.getSrcPath()) + ".submit()");
            }
            return;
        }
        if (SimpleDLCEventTypes.CLICK.equals(dapEvent.getType()) || SimpleDLCEventTypes.DBLCLICK.equals(dapEvent.getType())) {
            if (this.dispatchAnchorEvent(dapEvent, event)) {
                return;
            }
            if (this.dispatchSubmitBtnEvent(dapEvent, event)) {
                return;
            }
        }
        dapEvent = this.getDapEvent(event);
        this.m_windowManager.updateDDom(dapEvent, event);
        s_dapEventDispatcher.dispatchEvent(dapEvent);
    }

    public void shutdown() {
        this.m_windowManager.close();
    }

    public static void registerObjectType(String objId, Class<?> objType) {
        if (objId == null) {
            throw new RuntimeException("objId is null ");
        }
        if (objType == null) {
            throw new RuntimeException("objType is null ");
        }
        Class<DObject> dObjClz = DObject.class;
        Class[] args = new Class[]{AHtmlDocument.class, dObjClz};
        try {
            AHtmlFactory.setObjectConstructor(objId, objType.getDeclaredConstructor(args));
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to find constructor for " + objType.getName());
        }
    }

    private DapEvent getDapEvent(DLCEvent event) {
        String toType = s_eventMap.get(event.getType());
        if (toType == null) {
            return s_eventGenerator.createEvent(event);
        }
        DLCEvent toEvent = event.shallowCopy().setType(toType);
        return s_eventGenerator.createEvent(toEvent);
    }

    private boolean dispatchAnchorEvent(DapEvent dapEvent, DLCEvent event) {
        AHtmlElement elem = (AHtmlElement)dapEvent.getTarget();
        if (elem instanceof AHtmlAnchor) {
            if (s_dapEventDispatcher.dispatchEvent(dapEvent)) {
                this.m_dlcDispatcher.send("document.location.href=" + event.getSrcPath() + ".href");
            }
            return true;
        }
        return false;
    }

    private boolean dispatchSubmitBtnEvent(DapEvent dapEvent, DLCEvent event) {
        AHtmlElement elem = (AHtmlElement)dapEvent.getTarget();
        if (elem instanceof AHtmlButton) {
            String formPath;
            DLCEvent submit;
            DapEvent sbmtDapEvent;
            if (s_dapEventDispatcher.dispatchEvent(dapEvent) && "submit".equals(((AHtmlButton)elem).getType()) && s_dapEventDispatcher.dispatchEvent(sbmtDapEvent = s_eventGenerator.createEvent(submit = event.shallowCopy().setType(SimpleDLCEventTypes.SUBMIT))) && (formPath = AHtmlHelper.getFormPath(sbmtDapEvent.getTarget())) != null) {
                String elemRef = submit.getSrcPath();
                this.m_dlcDispatcher.send("DLC_onSubmitButtonClick(" + elemRef + ")");
                this.m_dlcDispatcher.send(String.valueOf(formPath) + ".submit()");
            }
            return true;
        }
        return false;
    }

    public void executeTask(String msg) {
        int id = Integer.parseInt(msg.substring("task".length() + 2));
        this.m_windowManager.executeTask(id);
    }
}

