/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import org.eclipse.vjet.dsf.active.client.WindowFactory;
import org.eclipse.vjet.dsf.dap.cnr.DapCapture;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.cnr.DapReplay;
import org.eclipse.vjet.dsf.dap.cnr.IDapCapture;
import org.eclipse.vjet.dsf.dap.cnr.ReplaySpeed;
import org.eclipse.vjet.dsf.dap.rt.DapBrowserEmulator;
import org.eclipse.vjet.dsf.dap.rt.DapBrowserEngine;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapSession;
import org.eclipse.vjet.dsf.liveconnect.client.DLCEvent;

public class DapCaptureReplay {
    private DapBrowserEmulator m_emulator;
    private DapSession m_session;
    private IDapCapture m_dapCapture;
    private ReplayControl m_replayControl;

    DapCaptureReplay(DapBrowserEmulator emulator, DapSession session) {
        this.m_emulator = emulator;
        this.m_session = session;
        this.m_dapCapture = new DapCapture();
        this.m_replayControl = new ReplayControl();
    }

    public void startCapture(String captureName) {
        this.m_dapCapture.start(captureName);
    }

    public void pauseCapture() {
        this.m_dapCapture.pause();
    }

    public void resumeCapture() {
        this.m_dapCapture.resume();
    }

    public void stopCapture() {
        this.m_dapCapture.stop();
    }

    public void replayCapture(ReplaySpeed speed) {
        this.replayCapture(this.m_dapCapture.getCapturedData(), speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayCapture(DapCaptureData data, ReplaySpeed speed) {
        this.m_dapCapture.pause();
        System.err.println("\nReplay ...");
        this.m_replayControl.m_state = ReplayState.enable;
        try {
            try {
                this.m_session.getDLCDispatcher().send("document.location.href='" + this.m_session.getCurrentView().getUrl() + "'");
                ReplayControl replayControl = this.m_replayControl;
                synchronized (replayControl) {
                    try {
                        this.m_replayControl.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.m_replayControl.m_state = ReplayState.started;
                DapBrowserEngine browserEngine = this.m_session.getCurrentView().getEngine();
                WindowFactory.contextSwitch(browserEngine.getWindow());
                DapCtx.ctx().setWindow(browserEngine.getWindow());
                new DapReplay(browserEngine, this.m_emulator.getDlcClient()).play(data, speed);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_replayControl.m_state = ReplayState.off;
                System.err.println("\nEnd replay");
                this.m_dapCapture.resume();
            }
        }
        finally {
            this.m_replayControl.m_state = ReplayState.off;
            System.err.println("\nEnd replay");
            this.m_dapCapture.resume();
        }
    }

    public boolean isReplay() {
        return this.m_replayControl.m_state != ReplayState.off;
    }

    public DapCaptureData getCapturedData() {
        return this.m_dapCapture.getCapturedData();
    }

    public String getCurrentCaptureName() {
        return this.m_dapCapture.currentCaptureName();
    }

    IDapCapture getCapture() {
        return this.m_dapCapture;
    }

    void connected() {
        if (this.m_replayControl.m_state == ReplayState.enable) {
            this.m_replayControl.m_state = ReplayState.ready;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean received(DLCEvent event) {
        if (this.m_replayControl.m_state == ReplayState.ready) {
            ReplayControl replayControl = this.m_replayControl;
            synchronized (replayControl) {
                this.m_replayControl.notifyAll();
            }
            return true;
        }
        if (this.m_replayControl.m_state != ReplayState.off) {
            return true;
        }
        this.m_dapCapture.receiveEvent(event);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executed(String msg) {
        if (this.m_replayControl.m_state == ReplayState.ready) {
            ReplayControl replayControl = this.m_replayControl;
            synchronized (replayControl) {
                this.m_replayControl.notifyAll();
            }
            return true;
        }
        if (this.m_replayControl.m_state != ReplayState.off) {
            return true;
        }
        this.m_dapCapture.receiveTask(msg);
        return false;
    }

    private static class ReplayControl {
        private ReplayState m_state = ReplayState.off;

        private ReplayControl() {
        }
    }

    private static enum ReplayState {
        off,
        enable,
        ready,
        started;

    }
}

