/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.dap.rt.DapHttpRequest;
import org.eclipse.vjet.dsf.dap.rt.DapHttpResponse;
import org.eclipse.vjet.dsf.dap.rt.IDapHttpClient;

public class DapHttpClient
implements IDapHttpClient {
    public static final int SOCKET_TIMEOUT = 50000;
    private static final String UTF8 = "utf-8";
    private List<IDapHttpClient.IDapHttpListener> m_listeners = new ArrayList<IDapHttpClient.IDapHttpListener>();
    public static final String HTTP_ERR = "HTTP ERROR: ";
    public static final String PAGE_LOAD_ERR = "Page Load Error: ";
    private static final String ERR_CONN = "Page Load Error: DapHttp can't establish a connection to remote server";
    private static final String ERR_TIMEOUT = "HTTP ERROR: 408 Request Timeout";
    public static final String ACTIVE_JS_MODE_HEADER = "ACTIVE_JS_MODE";

    @Override
    public DapHttpResponse send(DapHttpRequest request) {
        return this.execute(request);
    }

    @Override
    public void send(DapHttpRequest request, IDapHttpClient.IDapCallback callback) {
        AsyncRunner runner = new AsyncRunner(this, request, callback);
        Thread t = new Thread(runner);
        t.setDaemon(true);
        t.start();
        if (request.getTimeout() > 0L) {
            AsyncTimer timer = new AsyncTimer(runner, request.getTimeout());
            timer.start();
        }
    }

    @Override
    public void addListener(IDapHttpClient.IDapHttpListener listener) {
        if (listener != null) {
            this.m_listeners.add(listener);
        }
    }

    private String removeProtocol(String url) {
        int idx = url.indexOf("://");
        if ((idx = url.indexOf("/", idx + 3)) == -1) {
            return url;
        }
        return url.substring(idx);
    }

    private DapHttpResponse execute(DapHttpRequest dapRequest) {
        DapHttpResponse dapResponse = null;
        return dapResponse;
    }

    private DapHttpResponse buildDapResponse(Exception ex) {
        DapHttpResponse dapResponse = new DapHttpResponse();
        dapResponse.setStatusText(this.getHttpStatusText(dapResponse.getStatusCode()));
        return dapResponse;
    }

    private String getHttpStatusText(short status) {
        String text = null;
        switch (status) {
            case 200: {
                text = "200 OK";
                break;
            }
            case 400: {
                text = "400 Bad Request";
                break;
            }
            case 401: {
                text = "401 Unauthorized";
                break;
            }
            case 403: {
                text = "403 Forbidden";
                break;
            }
            case 404: {
                text = "404 Not Found";
                break;
            }
            case 408: {
                text = "408 Request Timeout";
                break;
            }
            case 500: {
                text = "500 Internal Server Error";
                break;
            }
            case 501: {
                text = "501 Not Implemented";
                break;
            }
            case 502: {
                text = "502 Bad Gateway";
                break;
            }
            case 503: {
                text = "503 Service Unavailable";
                break;
            }
            case 504: {
                text = "504 Gateway Timeout";
            }
        }
        return text;
    }

    private static class AsyncRunner
    implements Runnable {
        private DapHttpClient m_httpClient;
        private DapHttpRequest m_dapRequest;
        private IDapHttpClient.IDapCallback m_dapCallback;
        private boolean m_isComplete = false;
        private boolean m_isTimedOut = false;

        private AsyncRunner(DapHttpClient httpClient, DapHttpRequest dapRequest, IDapHttpClient.IDapCallback dapCallback) {
            this.m_dapRequest = dapRequest;
            this.m_httpClient = httpClient;
            this.m_dapCallback = dapCallback;
        }

        @Override
        public void run() {
            DapHttpResponse dapResponse = null;
            this.m_isComplete = false;
            dapResponse = this.m_httpClient.execute(this.m_dapRequest);
            this.onComplete(dapResponse);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isComplete() {
            AsyncRunner asyncRunner = this;
            synchronized (asyncRunner) {
                return this.m_isComplete;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onComplete(DapHttpResponse dapResponse) {
            AsyncRunner asyncRunner = this;
            synchronized (asyncRunner) {
                this.m_isComplete = true;
                if (this.m_isTimedOut) {
                    return;
                }
            }
            if (this.m_dapCallback != null) {
                this.m_dapCallback.onComplete(dapResponse);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onTimedOut() {
            AsyncRunner asyncRunner = this;
            synchronized (asyncRunner) {
                this.m_isTimedOut = true;
                if (this.m_isComplete) {
                    return;
                }
            }
            for (IDapHttpClient.IDapHttpListener listener : this.m_httpClient.m_listeners) {
                listener.onHttpTimedOut(this.m_dapRequest);
            }
            if (this.m_dapCallback != null) {
                this.m_dapCallback.onTimedOut();
            }
        }
    }

    private static class AsyncTimer
    extends Thread {
        private AsyncRunner m_runner;
        private long m_timeout;

        AsyncTimer(AsyncRunner runner, long timeout) {
            this.m_runner = runner;
            this.m_timeout = timeout > 0L ? timeout : 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AsyncTimer asyncTimer = this;
            synchronized (asyncTimer) {
                long start = System.currentTimeMillis();
                try {
                    this.wait(this.m_timeout);
                }
                catch (InterruptedException interruptedException) {}
                if (!this.m_runner.isComplete() && System.currentTimeMillis() - start >= this.m_timeout) {
                    this.m_runner.onTimedOut();
                }
            }
        }
    }
}

