/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ccil.cowan.tagsoup.Schema;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.dap.rt.DapBrowserEmulator;
import org.eclipse.vjet.dsf.dap.rt.DapConfig;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dom.DComment;
import org.eclipse.vjet.dsf.html.HtmlBuilderHelper;
import org.eclipse.vjet.dsf.html.HtmlWriterHelper;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DScript;
import org.eclipse.vjet.dsf.html.js.ActiveJsExecutionControlCtx;
import org.eclipse.vjet.dsf.html.sax.AHtmlSchema;
import org.eclipse.vjet.dsf.liveconnect.client.DLCClientHelper;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCClient;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;
import org.eclipse.vjet.dsf.service.client.IClientServiceHandlerRegistry;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DapIntercepter {
    public static final String DAP_MODE = "dapMode";
    private static int s_sessionCounter = 0;
    private static int s_reqCounter = 0;
    private String m_host;
    private DapCtx.ExeMode m_mode;
    private AHtmlSchema m_schema;
    private volatile DapBrowserEmulator m_emulator;
    private DapConfig m_dapConfig;
    private static Logger s_logger = Logger.getInstance(DapIntercepter.class);
    private static final String EMPTY = "";

    public DapIntercepter(String host, DapCtx.ExeMode mode) {
        this(host, mode, null);
    }

    public DapIntercepter(String host, DapCtx.ExeMode mode, DapConfig dapConfig) {
        this.m_host = host;
        this.m_mode = mode == null ? DapCtx.ExeMode.WEB : mode;
        this.m_dapConfig = dapConfig == null ? new DapConfig() : dapConfig;
    }

    public void setDapMode(DapCtx.ExeMode mode) {
        this.m_mode = mode == null ? DapCtx.ExeMode.WEB : mode;
    }

    public DapConfig getDapConfig() {
        return this.m_dapConfig;
    }

    public void handleRequest(HttpServletRequest request, IClientServiceHandlerRegistry svcHandlerRegistry) {
        DapCtx dapCtx = DapCtx.ctx();
        dapCtx.setExeMode(this.getMode(request));
        dapCtx.setDapConfig(this.m_dapConfig);
        dapCtx.setDsfSvcRegistry(svcHandlerRegistry);
        if (!dapCtx.isWebMode()) {
            ActiveJsExecutionControlCtx.ctx().setExecuteJavaScript(true);
        }
    }

    public void handleResponse(HttpServletRequest request, HttpServletResponse response, DHtmlDocument doc, IIndenter indent) throws IOException {
        if (!DapCtx.ctx().isWebMode()) {
            doc = this.processDapMode(request, response, doc);
        }
        String content = HtmlWriterHelper.asString((Node)doc, (IIndenter)indent);
        String contentType = this.getContentType(content);
        response.setContentType(String.valueOf(contentType) + ";charset=utf-8");
        response.setHeader("Cache-Control", "no-cache");
        ServletOutputStream os = response.getOutputStream();
        os.write(content.getBytes("utf-8"));
        os.flush();
        os.close();
    }

    private DHtmlDocument processDapMode(HttpServletRequest request, HttpServletResponse response, DHtmlDocument doc) {
        String reqId;
        String sessionId = DLCClientHelper.getSessionId((HttpServletRequest)request);
        if (sessionId == null || sessionId.trim().length() == 0) {
            sessionId = String.valueOf(++s_sessionCounter);
        }
        if ((reqId = DLCClientHelper.getRequestId((HttpServletRequest)request)) == null || reqId.trim().length() == 0) {
            reqId = String.valueOf(++s_reqCounter);
        }
        String html = this.getDapHtml(doc);
        this.getEmulator().addHtml(sessionId, reqId, this.getUrl(request), html);
        doc = this.removeScripts(html);
        DLCClientHelper.setSessionId((HttpServletResponse)response, (String)sessionId);
        return doc;
    }

    private String getContentType(String s) {
        int doctypeStartIndex = s.indexOf("<!DOCTYPE");
        if (doctypeStartIndex == -1) {
            return "text/html";
        }
        int doctypeEndIndex = s.indexOf(">", doctypeStartIndex);
        if (doctypeEndIndex == -1) {
            return "text/html";
        }
        String docType = s.substring(doctypeStartIndex, doctypeEndIndex);
        if (docType.contains("text/xml")) {
            return "text/xml";
        }
        if (docType.contains("xhtml") || docType.contains("XHTML")) {
            return "application/xhtml+xml;";
        }
        return "text/html";
    }

    public String getDapHtml(DHtmlDocument doc) {
        this.removeComments((Node)doc);
        DLCClientHelper.enableDLC((String)this.m_host, (int)this.getEmulator().getBrowserBridge().getPort(), (DHtmlDocument)doc, (IDLCClient)this.getEmulator().getDlcClient());
        return HtmlWriterHelper.asString((Node)doc);
    }

    private DapCtx.ExeMode getMode(HttpServletRequest request) {
        String dapMode = request.getParameter(DAP_MODE);
        if (dapMode != null) {
            this.m_mode = dapMode.startsWith(DapCtx.ExeMode.ACTIVE.name().substring(0, 1)) ? DapCtx.ExeMode.ACTIVE : (dapMode.startsWith(DapCtx.ExeMode.TRANSLATE.name().substring(0, 1)) ? DapCtx.ExeMode.TRANSLATE : DapCtx.ExeMode.WEB);
        }
        return this.m_mode;
    }

    private String getUrl(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer(request.getRequestURL());
        String query = request.getQueryString();
        if (query != null && query.length() > 0) {
            sb.append("?").append(query);
        }
        return sb.toString();
    }

    private AHtmlSchema getSchema() {
        if (this.m_schema == null) {
            this.m_schema = new AHtmlSchema();
        }
        return this.m_schema;
    }

    private void removeComments(Node node) {
        if (node == null || !node.hasChildNodes()) {
            return;
        }
        NodeList children = node.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child instanceof DComment) {
                node.removeChild(child);
            } else {
                this.removeComments(child);
            }
            --i;
        }
    }

    public DHtmlDocument removeScripts(String html) {
        DHtmlDocument doc = HtmlBuilderHelper.parseHtmlFragment((String)html, (boolean)true, (Schema)this.getSchema());
        this.removeScripts((Node)doc);
        return doc;
    }

    public void removeScripts(Node node) {
        if (node == null || !node.hasChildNodes()) {
            return;
        }
        NodeList children = node.getChildNodes();
        int i = children.getLength() - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (child instanceof DScript) {
                DScript script = (DScript)child;
                String src = script.getHtmlSrc();
                if ((src == null || src.length() == 0) && EMPTY.equals(script.getAttribute("dlc"))) {
                    script.setHtmlText(EMPTY);
                }
            } else {
                this.removeScripts(child);
            }
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DapBrowserEmulator getEmulator() {
        if (this.m_emulator == null) {
            DapIntercepter dapIntercepter = this;
            synchronized (dapIntercepter) {
                if (this.m_emulator == null) {
                    try {
                        this.m_emulator = new DapBrowserEmulator(this.m_dapConfig);
                    }
                    catch (IOException e) {
                        s_logger.log(LogLevel.ERROR, "Fail to instantiate browser bridge", (Throwable)e);
                    }
                }
            }
        }
        return this.m_emulator;
    }
}

