/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.dap.rt.DapBrowserEmulator;
import org.eclipse.vjet.dsf.dap.rt.DapCaptureReplay;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapView;
import org.eclipse.vjet.dsf.liveconnect.DLCDispatcher;
import org.eclipse.vjet.dsf.liveconnect.client.DLCEvent;

public final class DapSession {
    private static final String NAVIGATOR_USER_AGENT = "navigator.userAgent";
    private final String m_sessionId;
    private String m_userAgent;
    private Map<String, DapView> m_reqViews = new LinkedHashMap<String, DapView>();
    private List<DapView> m_viewList = new ArrayList<DapView>();
    private Iterator<DapView> m_replayIterator;
    private DapBrowserEmulator m_emulator;
    private DapCaptureReplay m_captureReplay;
    private DapView m_curView;
    private DLCDispatcher m_dlcDispatcher;

    DapSession(DapBrowserEmulator emulator, String sessionId) {
        this.m_emulator = emulator;
        this.m_sessionId = sessionId;
        if (this.m_emulator.getDapConfig().isCaptureReplayEnabled()) {
            this.m_captureReplay = new DapCaptureReplay(this.m_emulator, this);
        }
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public String getUserAgent() {
        return this.m_userAgent;
    }

    public DapCaptureReplay getCaptureReplay() {
        return this.m_captureReplay;
    }

    public boolean startReplay() {
        if (this.m_viewList.isEmpty()) {
            return false;
        }
        this.m_curView = this.m_viewList.get(0);
        this.m_replayIterator = this.m_viewList.iterator();
        return true;
    }

    public void endReplay() {
        this.m_replayIterator = null;
    }

    public Map<String, DapView> getViews() {
        return Collections.unmodifiableMap(this.m_reqViews);
    }

    void addView(String id, String url, String html, DapCtx dapCtx, DsfCtx dsfCtx) {
        if (this.m_captureReplay.isReplay()) {
            this.m_curView = this.m_replayIterator.next();
        } else {
            this.m_curView = new DapView(this, id, url, html, dapCtx, dsfCtx);
            this.m_viewList.add(this.m_curView);
        }
        this.m_reqViews.put(id, this.m_curView);
    }

    DapView getCurrentView() {
        return this.m_curView;
    }

    void onLoad(String reqId, SocketChannel channel) {
        this.m_dlcDispatcher = this.m_emulator.getBrowserBridge().getDLCDispatcher(channel);
        if (this.m_userAgent == null) {
            this.m_userAgent = this.m_emulator.getBrowserBridge().request(channel, NAVIGATOR_USER_AGENT);
            this.m_captureReplay.getCapture().getCapturedData().setUserAgent(this.m_userAgent);
        }
        this.m_curView = this.m_reqViews.get(reqId);
        this.m_curView.onLoad(this.m_dlcDispatcher, this.m_captureReplay.getCapture());
        this.m_captureReplay.getCapture().beginView(this.m_curView);
    }

    void onUnload() {
        this.m_dlcDispatcher = null;
        this.m_curView = null;
        this.m_captureReplay.getCapture().endView();
    }

    void onReceive(DLCEvent event) {
        if (this.m_curView != null) {
            this.m_curView.onReceive(event);
        }
    }

    DLCDispatcher getDLCDispatcher() {
        return this.m_dlcDispatcher;
    }
}

