/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.util.ArrayList;
import org.eclipse.vjet.dsf.active.event.IDomChangeListener;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.dap.cnr.IDapCapture;
import org.eclipse.vjet.dsf.dap.rt.DapBrowserBinding;
import org.eclipse.vjet.dsf.dap.rt.DapBrowserEngine;
import org.eclipse.vjet.dsf.dap.rt.DapConfig;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapDomEventBindingListener;
import org.eclipse.vjet.dsf.dap.rt.DapSession;
import org.eclipse.vjet.dsf.liveconnect.DLCDispatcher;
import org.eclipse.vjet.dsf.liveconnect.IDLCDispatcher;
import org.eclipse.vjet.dsf.liveconnect.IDLCDispatcherInfoCollector;
import org.eclipse.vjet.dsf.liveconnect.client.DLCEvent;

public class DapView {
    private String m_reqId;
    private String m_url;
    private String m_html;
    private DapCtx m_dapCtx;
    private DapBrowserEngine m_curBrowserEngine;

    public DapView(DapSession session, String reqId, String url, String html, DapCtx dapCtx, DsfCtx dsfCtx) {
        this.m_reqId = reqId;
        this.m_url = url;
        this.m_html = html;
        this.m_dapCtx = DapCtx.create().setDapConfig(dapCtx.getDapConfig()).setSession(session).setEventListenerRegistry(dapCtx.getEventListenerRegistry()).setDsfSvcRegistry(dapCtx.getDsfSvcRegistry()).setServiceEngine(dapCtx.getServiceEngine());
        DsfCtx.createCtx();
        DsfCtx.setCtx((DsfCtx)dsfCtx);
    }

    public String getId() {
        return this.m_reqId;
    }

    public String getUrl() {
        return this.m_url;
    }

    public String getHtml() {
        return this.m_html;
    }

    public DapBrowserEngine getEngine() {
        return this.m_curBrowserEngine;
    }

    public void onLoad(DLCDispatcher dlcDispatcher, IDapCapture dapCapture) {
        this.setupCtx();
        ArrayList<IDomChangeListener> domChangeListeners = new ArrayList<IDomChangeListener>();
        DapConfig config = this.m_dapCtx.getDapConfig();
        if (config.isCaptureReplayEnabled()) {
            domChangeListeners.add(dapCapture);
            dlcDispatcher.setInfoCollector((IDLCDispatcherInfoCollector)dapCapture);
            config.getHttpClient().addListener(dapCapture);
        }
        DapCtx.ctx().setWindow(null);
        this.m_curBrowserEngine = new DapBrowserEngine(this.getHtml(), new DapBrowserBinding((IDLCDispatcher)dlcDispatcher), (IDLCDispatcher)dlcDispatcher, domChangeListeners, new DapDomEventBindingListener((IDLCDispatcher)dlcDispatcher, config.getDlcClient()));
    }

    public void onReceive(DLCEvent event) {
        if (this.m_curBrowserEngine != null) {
            this.m_curBrowserEngine.onReceive(event);
        }
    }

    public DapCtx setupCtx() {
        DapCtx dapCtx = DapCtx.ctx().reset();
        dapCtx.setExeMode(DapCtx.ExeMode.ACTIVE);
        dapCtx.setDapConfig(this.m_dapCtx.getDapConfig());
        dapCtx.setSession(this.m_dapCtx.getSession());
        dapCtx.setEventListenerRegistry(this.m_dapCtx.getEventListenerRegistry());
        dapCtx.setDsfSvcRegistry(this.m_dapCtx.getDsfSvcRegistry());
        dapCtx.setServiceEngine(this.m_dapCtx.getServiceEngine());
        return dapCtx;
    }
}

