/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.client.AXmlParser;
import org.eclipse.vjet.dsf.active.client.ActiveObject;
import org.eclipse.vjet.dsf.active.client.WindowFactory;
import org.eclipse.vjet.dsf.active.dom.html.ADocument;
import org.eclipse.vjet.dsf.active.util.AsyncTask;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.proxy.INativeJsFuncProxy;
import org.eclipse.vjet.dsf.dap.proxy.JFunctionX;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapHttpRequest;
import org.eclipse.vjet.dsf.dap.rt.DapHttpResponse;
import org.eclipse.vjet.dsf.dap.rt.IDapHttpClient;
import org.eclipse.vjet.dsf.jsnative.Document;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.Location;
import org.eclipse.vjet.dsf.jsnative.XMLHttpRequest;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.services.ConnectionProtocolEnum;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.Undefined;

public final class XMLHttpRequestImpl
extends ActiveObject
implements XMLHttpRequest {
    private String m_method;
    private String m_url;
    private boolean m_async = true;
    private short m_readyState;
    private short m_status;
    private String m_responseText;
    private Map<String, String> m_requestHeaders;
    private Map<String, String> m_responseHeaders;
    private String m_user;
    private String m_password;
    private String m_statusText;
    private Function m_onreadystatechange;
    private AWindow m_window;
    private Function m_hitchFunc;
    private static final String[] InternalFuns = new String[]{"invokeCallback"};
    private IDapHttpClient m_client = DapCtx.ctx().getDapConfig().getHttpClient();
    private boolean m_sendFlag = false;
    private boolean m_errorFlag = false;
    private AsyncTask m_asyncTask;
    private IDapHttpClient.IDapCallback m_callback = new IDapHttpClient.IDapCallback(){

        @Override
        public void onComplete(DapHttpResponse resp) {
            if (XMLHttpRequestImpl.this.m_sendFlag) {
                XMLHttpRequestImpl.this.doResponse(resp);
            }
        }

        @Override
        public void onTimedOut() {
            if (XMLHttpRequestImpl.this.m_sendFlag) {
                XMLHttpRequestImpl.this.doResponse(null);
            }
        }
    };

    public XMLHttpRequestImpl() {
    }

    public XMLHttpRequestImpl(AWindow window) {
        this.m_window = window == null ? (AWindow)WindowFactory.createWindow() : window;
        this.populateScriptable(XMLHttpRequestImpl.class, this.m_window.getBrowserType());
        this.defineFunctionProperties(InternalFuns, XMLHttpRequestImpl.class, 0);
        DapCtx.ctx().setXmlHttpReq(this);
        this.m_hitchFunc = (Function)this.m_window.getContext().evaluateString(this.m_window.getScope(), "function(ctx, fn) {return function() {return fn.call(ctx);}}", "hitch", 0, null);
    }

    public void open(String method, String url, boolean async, String user, String password) {
        this.validateOpen(method, url);
        this.checkCrossDomain(url);
        this.m_url = url;
        this.m_method = method;
        this.m_async = async;
        this.m_user = user == null ? "" : user;
        this.m_password = password == null ? "" : password;
        this.m_readyState = 1;
    }

    public void send(Object request) {
        if (this.m_readyState != 1 || this.m_sendFlag) {
            throw new DsfRuntimeException("INVALID_STATE_ERR");
        }
        if (ConnectionProtocolEnum.GET.getName().equals(this.m_method) && request != null && !(request instanceof Undefined)) {
            throw new DsfRuntimeException("Invalid data");
        }
        this.m_sendFlag = true;
        DapHttpRequest dapReq = this.buildDapRequest(request);
        if (this.m_async) {
            this.m_asyncTask = new AsyncTask();
            this.m_window.addTask(this.m_asyncTask);
            this.m_client.send(dapReq, this.m_callback);
        } else {
            DapHttpResponse resp = this.m_client.send(dapReq);
            this.doResponse(resp);
        }
    }

    public void abort() {
        if (this.m_async) {
            this.m_errorFlag = true;
            if (this.m_requestHeaders != null) {
                this.m_requestHeaders.clear();
            }
            if (this.m_readyState == 0 || this.m_readyState == 1 && !this.m_sendFlag || this.m_readyState == 4) {
                this.m_readyState = 0;
            } else {
                this.m_readyState = (short)4;
                this.m_sendFlag = false;
                this.m_asyncTask.cancel();
            }
        }
    }

    public void sendAsBinary(String body) {
        int length;
        int n = length = body == null ? 0 : body.length();
        if (length > 0) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < body.length()) {
                char c = body.charAt(i);
                byte b = (byte)c;
                sb.append((char)b);
                ++i;
            }
            this.send(sb.toString());
        } else {
            this.send(null);
        }
    }

    public String getResponseHeader(String header) {
        if (this.m_responseHeaders == null) {
            return null;
        }
        return this.m_responseHeaders.get(header);
    }

    public void setRequestHeader(String name, String value) {
        if (this.m_readyState != 1 || this.m_sendFlag) {
            throw new DsfRuntimeException("INVALID_STATE_ERR");
        }
        if (this.m_requestHeaders == null) {
            this.m_requestHeaders = new HashMap<String, String>();
        }
        this.m_requestHeaders.put(name, value);
    }

    public short getReadyState() {
        return this.m_readyState;
    }

    public short getStatus() {
        return this.m_status;
    }

    public String getResponseText() {
        return this.m_responseText;
    }

    public String getAllResponseHeaders() {
        if (this.m_responseHeaders == null || this.m_responseHeaders.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String key : this.m_responseHeaders.keySet()) {
            sb.append(key).append(": ").append(this.m_responseHeaders.get(key)).append('\n');
        }
        return sb.toString();
    }

    public Document getResponseXML() {
        if (this.m_readyState != 4) {
            return null;
        }
        if (this.getResponseText() == null) {
            return null;
        }
        ADocument doc = AXmlParser.parse(this.getResponseText().getBytes());
        return doc;
    }

    public String getStatusText() {
        return this.m_statusText;
    }

    public org.eclipse.vjet.dsf.jsnative.global.Function getUpload() {
        throw new DsfRuntimeException("To be implemented");
    }

    public void setUpload(org.eclipse.vjet.dsf.jsnative.global.Function nsIXMLHttpRequestUpload) {
        throw new DsfRuntimeException("To be implemented");
    }

    public boolean getWithCredentials() {
        throw new DsfRuntimeException("To be implemented");
    }

    public void setWithCredentials(boolean value) {
        throw new DsfRuntimeException("To be implemented");
    }

    public Object getOnreadystatechange() {
        return this.m_onreadystatechange;
    }

    public void setOnreadystatechange(Object handler) {
        if (handler instanceof Function) {
            this.m_onreadystatechange = (Function)handler;
        } else if (handler instanceof INativeJsFuncProxy) {
            this.m_onreadystatechange = ((INativeJsFuncProxy)handler).getJsNative();
        }
    }

    public void invokeCallback() {
        if (this.m_onreadystatechange != null) {
            this.m_onreadystatechange.call(this.m_window.getContext(), (Scriptable)this.m_window, (Scriptable)this, new Object[]{this});
        }
    }

    private void validateOpen(String method, String url) {
        if (!ConnectionProtocolEnum.GET.getName().equals(method) && !ConnectionProtocolEnum.POST.getName().equals(method)) {
            throw new DsfRuntimeException("SYNTAX_ERR");
        }
        if (url == null || "".equals(url.trim()) || "null".equals(url.trim()) || "undefined".equals(url.trim())) {
            throw new DsfRuntimeException("SYNTAX_ERR");
        }
    }

    private void checkCrossDomain(String url) {
        String currentUrl;
        String tgtUrl = url;
        if (tgtUrl == null || tgtUrl.startsWith("/")) {
            return;
        }
        if (url.indexOf("://") <= 0) {
            tgtUrl = "http://" + tgtUrl;
        }
        String[] curDomain = new String[2];
        HtmlDocument doc = this.m_window.getDocument();
        if (doc != null) {
            Location loc = doc.getLocation();
            currentUrl = loc.getHref();
            if (currentUrl.startsWith("file:/") || currentUrl.startsWith("jar:file:/")) {
                return;
            }
        } else {
            return;
        }
        this.parseDomain(currentUrl, curDomain);
        String[] urlDomain = new String[2];
        this.parseDomain(tgtUrl, urlDomain);
        boolean isValid = true;
        if (!urlDomain[0].equalsIgnoreCase(curDomain[0])) {
            isValid = false;
        } else {
            BrowserType browser = DapCtx.ctx().getWindow().getBrowserType();
            if (!browser.isIE() && (browser.isFireFox() || browser.isSafari()) && !urlDomain[1].equalsIgnoreCase(curDomain[1])) {
                isValid = false;
            }
        }
        if (!isValid) {
            throw new DsfRuntimeException("Access to restricted URI denied");
        }
    }

    private void parseDomain(String url, String[] domain) {
        int idx = url.indexOf("://") + 3;
        idx = idx >= 0 ? idx : 0;
        int idxS = url.indexOf("/", idx);
        idxS = idxS >= 0 ? idxS : url.length();
        int idxC = url.indexOf(":", idx);
        if (idxC > 0) {
            domain[0] = url.substring(idx, idxC);
            domain[1] = url.substring(idxC + 1, idxS);
        } else {
            domain[0] = url.substring(idx, idxS);
            domain[1] = "80";
        }
    }

    private DapHttpRequest buildDapRequest(Object request) {
        DapHttpRequest dapReq = new DapHttpRequest(this.m_method, this.m_url, this.m_async);
        if (request != null) {
            dapReq.setRawData(request.toString());
        }
        if (this.m_requestHeaders != null) {
            for (Map.Entry<String, String> entry : this.m_requestHeaders.entrySet()) {
                dapReq.setRequestHeader(entry.getKey(), entry.getValue());
            }
        }
        return dapReq;
    }

    private void doResponse(DapHttpResponse resp) {
        if (resp != null) {
            this.m_responseHeaders = new HashMap<String, String>();
            if (resp.getResponseHeaders() != null) {
                this.m_responseHeaders.putAll(resp.getResponseHeaders());
            }
            this.m_responseText = resp.getResponseText();
            this.m_status = resp.getStatusCode();
            this.m_statusText = resp.getStatusText();
        }
        if (this.m_status == 0 || this.m_statusText == null) {
            this.m_errorFlag = true;
        }
        this.m_readyState = (short)4;
        if (this.m_onreadystatechange != null) {
            Function hitch = this.hitch("invokeCallback", Void.TYPE);
            if (this.m_async) {
                this.m_window.addTask(this.m_asyncTask);
            } else {
                this.m_window.addTask(hitch);
            }
        } else if (this.m_async) {
            this.m_asyncTask.cancel();
        }
    }

    private Function hitch(String methodName, Class<?> returnType) {
        return (Function)this.m_hitchFunc.call(this.m_window.getContext(), this.m_window.getScope(), null, new Object[]{this, JFunctionX.def(this, methodName, returnType)});
    }

    void setReadyState(short readyState) {
        this.m_readyState = readyState;
    }

    void setStatus(short status) {
        this.m_status = status;
    }

    void setResponseText(String responseText) {
        this.m_responseText = responseText;
    }

    public void XMLHttpRequest() {
    }
}

