/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.active.event.IDomChangeListener;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DBody;
import org.eclipse.vjet.dsf.html.dom.DButton;
import org.eclipse.vjet.dsf.html.dom.DDiv;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DInput;
import org.eclipse.vjet.dsf.html.dom.DLabel;
import org.eclipse.vjet.dsf.html.dom.DSelect;
import org.eclipse.vjet.dsf.html.dom.DSpan;
import org.eclipse.vjet.dsf.html.dom.util.HtmlBuilder;
import org.eclipse.vjet.dsf.html.js.ActiveJsExecutionControlCtx;
import org.eclipse.vjet.dsf.html.js.JSAllArray;
import org.eclipse.vjet.dsf.html.js.JSAnalysisListener;
import org.eclipse.vjet.dsf.html.js.JSBody;
import org.eclipse.vjet.dsf.html.js.JSBuilderListener;
import org.eclipse.vjet.dsf.html.js.JSButton;
import org.eclipse.vjet.dsf.html.js.JSDebug;
import org.eclipse.vjet.dsf.html.js.JSDiv;
import org.eclipse.vjet.dsf.html.js.JSDocument;
import org.eclipse.vjet.dsf.html.js.JSElement;
import org.eclipse.vjet.dsf.html.js.JSFrames;
import org.eclipse.vjet.dsf.html.js.JSHistory;
import org.eclipse.vjet.dsf.html.js.JSInput;
import org.eclipse.vjet.dsf.html.js.JSLabel;
import org.eclipse.vjet.dsf.html.js.JSListener;
import org.eclipse.vjet.dsf.html.js.JSLocation;
import org.eclipse.vjet.dsf.html.js.JSNavigator;
import org.eclipse.vjet.dsf.html.js.JSScreen;
import org.eclipse.vjet.dsf.html.js.JSSelect;
import org.eclipse.vjet.dsf.html.js.JSServerListener;
import org.eclipse.vjet.dsf.html.js.JSSpan;
import org.eclipse.vjet.dsf.html.js.JsHackDetectionCtx;
import org.eclipse.vjet.dsf.html.js.URLUtil;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.JavaScriptException;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleSheet;

public class JSWindow
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private URL m_url = null;
    private boolean m_isTopWindow = false;
    private Context m_cx = null;
    private Scriptable m_scope = null;
    private JSFrames m_frames = null;
    private JSListener m_listener;
    private DHtmlDocument m_doc = null;
    private CSSStyleSheet m_styleSheet = null;
    private String m_openWindowUrl = null;
    private String m_preTimeOutFunction = "";
    private Map<Node, JSElement> m_elements = new HashMap<Node, JSElement>(10);
    private IDomChangeListener m_domChangeListener;
    private Position m_topLeft;
    private int m_width;
    private int m_height;
    private HtmlBuilder baseBuilder = null;
    public boolean isRoot = true;
    private boolean m_closed = false;
    private String m_defaultStatus = "";
    private JSDocument m_document = null;
    private JSHistory m_history = null;
    private JSLocation m_location = null;
    private String name = "";
    private JSNavigator m_navigator = null;
    private String m_offscreenBuffering = "auto";
    private Object m_onblur = null;
    private Object m_ondragdrop = null;
    private Object m_onerror = null;
    private Object m_onfocus = null;
    private Object m_onload = null;
    private Object m_onmove = null;
    private Object m_onresize = null;
    private Object m_onunload = null;
    private Object m_opener = null;
    private JSWindow m_parent = null;
    private JSScreen m_screen = null;
    private String status = "";
    public JSWindow m_top = null;
    private boolean loading = true;
    public static int IN_LOADING = 0;
    public static int IN_ANALYSIS = 1;
    public static int IN_SERVER = 2;
    public static int IDLE = 3;
    public int windowState = IN_LOADING;
    static HashMap<String, String> constants = new HashMap(13);

    static {
        constants.put("Object", "Object");
        constants.put("layers", "layers");
        constants.put("getElementById", "getElementById");
        constants.put("SyntaxError", "SyntaxError");
        constants.put("ConversionError", "ConversionError");
        constants.put("TypeError", "TypeError");
        constants.put("ReferenceError", "ReferenceError");
    }

    public void jsConstructor() {
    }

    public String getClassName() {
        return "JSWindow";
    }

    public void init(JSWindow parent, Context cx, Scriptable scope) throws JavaScriptException {
        this.m_url = null;
        if (parent == null) {
            this.m_parent = this;
            this.m_top = this;
            this.m_opener = this;
            this.m_listener = new JSAnalysisListener();
            this.m_isTopWindow = true;
        } else {
            this.m_parent = parent;
            this.m_top = this.m_parent.getTop();
            this.m_listener = this.m_parent.m_listener;
            this.m_isTopWindow = false;
        }
        this.m_cx = cx;
        this.m_scope = scope;
        this.m_frames = new JSFrames(this);
        this.defineProperty("closed", JSWindow.class, 2);
        this.defineProperty("defaultStatus", JSWindow.class, 2);
        this.defineProperty("document", JSWindow.class, 2);
        this.defineProperty("frames", JSWindow.class, 2);
        this.defineProperty("history", JSWindow.class, 2);
        this.defineProperty("length", JSWindow.class, 2);
        this.defineProperty("location", JSWindow.class, 2);
        this.defineProperty("name", JSWindow.class, 2);
        this.defineProperty("navigator", JSWindow.class, 2);
        this.defineProperty("offscreenBuffering", JSWindow.class, 2);
        this.defineProperty("opener", JSWindow.class, 2);
        this.defineProperty("parent", JSWindow.class, 2);
        this.defineProperty("screen", JSWindow.class, 2);
        this.defineProperty("self", JSWindow.class, 2);
        this.defineProperty("status", JSWindow.class, 2);
        this.defineProperty("top", JSWindow.class, 2);
        this.defineProperty("window", JSWindow.class, 2);
        this.defineProperty("onload", JSWindow.class, 2);
        this.defineProperty("loading", JSWindow.class, 2);
        this.defineProperty("onblur", JSWindow.class, 2);
        this.defineProperty("ondragdrop", JSWindow.class, 2);
        this.defineProperty("onerror", JSWindow.class, 2);
        this.defineProperty("onfocus", JSWindow.class, 2);
        this.defineProperty("onmove", JSWindow.class, 2);
        this.defineProperty("onresize", JSWindow.class, 2);
        this.defineProperty("onunload", JSWindow.class, 2);
        String[] methodNames = new String[]{"alert", "blur", "clearInterval", "clearTimeout", "close", "confirm", "focus", "open", "prompt", "scroll", "scrollBy", "scrollTo", "setInterval", "setTimeout", "valueOf"};
        this.defineFunctionProperties(methodNames, JSWindow.class, 2);
        this.m_document = new JSDocument(this);
        this.m_history = new JSHistory(this);
        this.m_location = new JSLocation(this);
        this.m_navigator = new JSNavigator(this);
        this.m_screen = new JSScreen(this);
        this.baseBuilder = new HtmlBuilder();
        this.isRoot = true;
    }

    public Context getContext() {
        return this.m_cx;
    }

    public Scriptable getScope() {
        return this.m_scope;
    }

    public URL getURL() {
        return this.m_url;
    }

    public void setURL(URL url) {
        this.m_url = url;
    }

    public JSListener getJSListener() {
        return this.m_listener;
    }

    public CSSStyleSheet getCssStyleSheet() {
        return this.m_styleSheet;
    }

    public void setCssStyleSheet(CSSStyleSheet styleSheet) {
        this.m_styleSheet = styleSheet;
    }

    public void destroy() {
        Context.exit();
    }

    public void setHTMLDocument(DHtmlDocument doc) {
        this.m_doc = doc;
    }

    public DHtmlDocument getHTMLDocument() {
        if (this.m_doc != null) {
            return this.m_doc;
        }
        return this.baseBuilder.getHTMLDocument();
    }

    public HtmlBuilder getBaseBuilder() {
        return this.baseBuilder;
    }

    public void setCookie(String s) {
        this.m_document.setCookie2(s);
    }

    public String getCookie() {
        return this.m_document.getCookie2();
    }

    public String executeScript(String script) throws JavaScriptException {
        return this.executeScript(script, this.m_scope);
    }

    public String executeScript(String script, Scriptable scope) throws JavaScriptException {
        String s = script.trim();
        int numHiddenWindow = 0;
        if (this.m_parent != this) {
            numHiddenWindow = this.m_parent.m_frames.numHiddenWindow();
        }
        Object ret = null;
        if (ActiveJsExecutionControlCtx.ctx().needDebug()) {
            Map<String, String> fragments = this.getSourceFragments(s);
            for (Map.Entry<String, String> entry : fragments.entrySet()) {
                ret = this.m_cx.evaluateString(scope, entry.getValue(), entry.getKey(), 1, null);
            }
        } else {
            JSDebug.println("Executing JavaScript:\n" + s);
            String id = "TheScript_" + s.length() + "_" + s.hashCode();
            ret = this.m_cx.evaluateString(scope, s, id, 1, null);
        }
        if (this.m_parent != this && this.m_url != null) {
            this.m_parent.m_frames.fixHiddenWindowHref(URLUtil.getBaseURL(this.m_url.toString()), numHiddenWindow);
        }
        return Context.toString(ret);
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, String> getSourceFragments(String data) {
        block3: {
            fragments = new LinkedHashMap<String, String>();
            currentIndex = 0;
            tokenIndex = data.indexOf("//ACTIVE_JS_SRC:");
            if (tokenIndex != -1) ** GOTO lbl15
            fragments.put(JSWindow.createKey(data), data);
            break block3;
lbl-1000:
            // 1 sources

            {
                if (tokenIndex > currentIndex && (fragment = data.substring(currentIndex, tokenIndex).trim()).length() > 0) {
                    fragments.put(JSWindow.createKey(fragment), fragment);
                }
                currentIndex = JSWindow.processTokenValue(data, tokenIndex, fragments);
                tokenIndex = -1;
                if (currentIndex >= data.length()) continue;
                tokenIndex = data.indexOf("//ACTIVE_JS_SRC:", currentIndex);
lbl15:
                // 3 sources

                ** while (tokenIndex != -1)
            }
lbl16:
            // 1 sources

            if (currentIndex < data.length()) {
                fragment = data.substring(currentIndex).trim();
                fragments.put(JSWindow.createKey(fragment), fragment);
            }
        }
        return fragments;
    }

    private static int processTokenValue(String data, int tokenIndex, Map<String, String> fragments) {
        String url;
        int start = tokenIndex + "//ACTIVE_JS_SRC:".length() + 1;
        int end = data.indexOf("]", start);
        String fileName = url = data.substring(start, end);
        if (url.startsWith("file:")) {
            try {
                File file;
                int index = url.indexOf("/bin/");
                String srcUrl = url;
                if (index > 0) {
                    srcUrl = String.valueOf(url.substring(0, index)) + "/src/" + url.substring(index + 5);
                }
                if ((file = new File(new URL(srcUrl).getFile())).exists()) {
                    fileName = file.getAbsolutePath();
                    url = srcUrl;
                }
            }
            catch (MalformedURLException e) {
                throw new DsfRuntimeException(url, (Throwable)e);
            }
        }
        String text = JSWindow.getJsContent(url);
        fragments.put(fileName, text);
        return ++end;
    }

    private static String createKey(String data) {
        return "TheScript_" + data.length() + "_" + data.hashCode();
    }

    public static String getJsContent(String url) {
        InputStream inputStream;
        try {
            inputStream = new URL(url).openStream();
        }
        catch (IOException e) {
            throw new DsfRuntimeException(url, (Throwable)e);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        try {
            try {
                int numBytesXferred;
                while ((numBytesXferred = inputStream.read(buffer)) != -1) {
                    os.write(buffer, 0, numBytesXferred);
                }
            }
            finally {
                inputStream.close();
            }
            String scriptText = os.toString("utf-8");
            return scriptText;
        }
        catch (IOException e) {
            throw new DsfRuntimeException("can not load '" + url + "'", (Throwable)e);
        }
    }

    public String executeScript(Reader reader) throws JavaScriptException, IOException {
        Object ret = this.m_cx.evaluateReader(this.m_scope, reader, "TheScript", 1, null);
        return Context.toString((Object)ret);
    }

    public String getGeneratedContentFromScript() {
        return this.m_document.getGeneratedContent();
    }

    public Scriptable getClosed() {
        return Context.toObject((Object)(this.m_closed ? Boolean.TRUE : Boolean.FALSE), (Scriptable)this.m_scope);
    }

    public Scriptable getDefaultStatus() {
        return Context.toObject((Object)this.m_defaultStatus, (Scriptable)this.m_scope);
    }

    public void setDefaultStatus(Object defaultStatus) {
        this.m_defaultStatus = defaultStatus.toString();
    }

    public Scriptable getDocument() {
        return this.m_document;
    }

    public JSDocument getJSDocument() {
        return this.m_document;
    }

    public Scriptable getFrames() {
        return this.m_frames;
    }

    public void addChildWindow(JSWindow cw) {
        this.m_frames.addChildWindow(cw);
    }

    public void removeChildWindow(JSWindow cw) {
        this.m_frames.removeChildWindow(cw);
    }

    public JSWindow[] getChildWindow() {
        int size = this.m_frames.size();
        JSWindow[] windows = new JSWindow[size];
        int i = 0;
        while (i < size) {
            windows[i] = this.m_frames.at(i);
            ++i;
        }
        return windows;
    }

    public Scriptable getHistory() {
        return Context.toObject((Object)this.m_history, (Scriptable)this.m_scope);
    }

    public JSHistory getJSHistory() {
        return this.m_history;
    }

    public Scriptable getLength() {
        return Context.toObject((Object)new Integer(this.m_frames.size()), (Scriptable)this.m_scope);
    }

    public Scriptable getLocation() {
        return this.m_location;
    }

    public void setLocation(Object s) {
        JsHackDetectionCtx.ctx().setLocationChange(s.toString());
        this.m_location.replace(s);
    }

    public JSLocation getJSLocation() {
        return this.m_location;
    }

    public Scriptable getName() {
        return Context.toObject((Object)this.name, (Scriptable)this.m_scope);
    }

    public void setName(Object name) {
        this.name = name.toString();
    }

    public Scriptable getNavigator() {
        return Context.toObject((Object)this.m_navigator, (Scriptable)this.m_scope);
    }

    public JSNavigator getJSNavigator() {
        return this.m_navigator;
    }

    public Scriptable getOffscreenBuffering() {
        return Context.toObject((Object)this.m_offscreenBuffering, (Scriptable)this.m_scope);
    }

    public Object getOnblur() {
        return this.m_onblur;
    }

    public void setOnblur(Object o) {
        this.m_onblur = o;
    }

    public Object getOndragdrop() {
        return this.m_ondragdrop;
    }

    public void setOndragdrop(Object o) {
        this.m_ondragdrop = o;
    }

    public Object getOnerror() {
        return this.m_onerror;
    }

    public void setOnerror(Object o) {
        this.m_onerror = o;
    }

    public Object getOnfocus() {
        return this.m_onfocus;
    }

    public void setOnfocus(Object o) {
        this.m_onfocus = o;
    }

    public Object getOnload() {
        return this.m_onload;
    }

    public void setOnload(Object o) {
        this.m_onload = o;
    }

    public void executeOnload() {
        if (this.m_onload == null) {
            return;
        }
        if (this.m_onload instanceof Function) {
            try {
                ((Function)this.m_onload).call(this.m_cx, this.m_scope, (Scriptable)this, new Object[0]);
            }
            catch (Exception e) {
                JSDebug.println(e.getMessage());
            }
        }
    }

    public Object getOnmove() {
        return this.m_onmove;
    }

    public void setOnmove(Object o) {
        this.m_onmove = o;
    }

    public Object getOnresize() {
        return this.m_onresize;
    }

    public void setOnresize(Object o) {
        this.m_onresize = o;
    }

    public Object getOnunload() {
        return this.m_onunload;
    }

    public void setOnunload(Object o) {
        this.m_onunload = o;
    }

    public Object getOpener() {
        return this.m_opener;
    }

    public void setOpener(Object o) {
        this.m_opener = o;
    }

    public Scriptable getParent() {
        return this.m_parent;
    }

    public Scriptable getScreen() {
        return Context.toObject((Object)this.m_screen, (Scriptable)this.m_scope);
    }

    public Scriptable getSelf() {
        return this;
    }

    public Scriptable getStatus() {
        return Context.toObject((Object)this.status, (Scriptable)this.m_scope);
    }

    public void setStatus(Object status) {
        this.status = status.toString();
    }

    public JSWindow getTop() {
        JSWindow m_top = this;
        while (m_top != null && !m_top.m_isTopWindow) {
            m_top = m_top.m_parent;
        }
        return m_top;
    }

    public JSWindow getWindow() {
        return this;
    }

    public void jsFunction_alert(Object s) {
        JSDebug.println("jsFunction_alert:" + s);
    }

    public void alertFunction(Object[] s) {
        JSDebug.println("alertFunction:" + s);
    }

    public static void alert(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).alertFunction(args);
    }

    public void jsFunction_blur() {
        JSDebug.println("jsFunction_blur:");
    }

    public void blurFunction() {
        JSDebug.println("blurFunction:");
    }

    public static void blur(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).blurFunction();
    }

    public void jsFunction_captureEvents(Object id) {
        JSDebug.println("jsFunction_captureEvents:");
    }

    public void captureEventsFunction(Object[] args) {
        JSDebug.println("captureEventsFunction:" + args);
    }

    public static void captureEvents(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).captureEventsFunction(args);
    }

    public void jsFunction_clearInterval(Object id) {
        JSDebug.println("jsFunction_clearInterval:");
    }

    public void clearIntervalFunction(Object[] args) {
        JSDebug.println("clearIntervalFunction:" + args);
    }

    public static void clearInterval(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).clearIntervalFunction(args);
    }

    public void jsFunction_clearTimeout(Object id) {
        JSDebug.println("jsFunction_clearTimeout:");
    }

    public void clearTimeoutFunction(Object[] args) {
        JSDebug.println("clearTimeoutFunction:" + args);
    }

    public static void clearTimeout(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).clearTimeoutFunction(args);
    }

    public void jsFunction_close() {
        JSDebug.println("jsFunction_close:");
        this.m_closed = true;
    }

    public void closeFunction() {
        JSDebug.println("closeFunction:");
        this.m_closed = true;
        this.m_listener.doAction(6, "window", null, null);
    }

    public static void close(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).closeFunction();
    }

    public void jsFunction_confirm(Object s) {
        JSDebug.println("jsFunction_confirm:" + s);
    }

    public void confirmFunction(Object[] s) {
        JSDebug.println("confirmFunction:" + s);
    }

    public static Scriptable confirm(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).confirmFunction(args);
        return Context.toObject((Object)Boolean.TRUE, (Scriptable)thisObj);
    }

    public void jsFunction_focus() {
        JSDebug.println("jsFunction_focus:");
    }

    public void focusFunction() {
        JSDebug.println("focusFunction:");
    }

    public static void focus(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).focusFunction();
    }

    public void jsFunction_open(Object url, Object name, Object features, Object replace) {
        JSDebug.println("jsFunction_open(...):");
    }

    public void openFunction(Object[] args) {
        this.m_openWindowUrl = (String)args[0];
        if (this.windowState == IN_LOADING) {
            String iframe = "<IFRAME src=\"" + this.m_openWindowUrl + "\">";
            this.m_document.writeln(iframe);
        }
        this.m_listener.doAction(5, "window", this.m_openWindowUrl, null);
    }

    public static Scriptable open(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).openFunction(args);
        return thisObj;
    }

    public void jsFunction_prompt(Object message, Object def) {
        JSDebug.println("jsFunction_prompt:");
    }

    public void promptFunction(Object[] args) {
        JSDebug.println("promptFunction:" + args);
    }

    public static Scriptable prompt(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).promptFunction(args);
        return Context.toObject((Object)"", (Scriptable)thisObj);
    }

    public void jsFunction_scroll(Object x, Object y) {
        JSDebug.println("jsFunction_scroll:");
    }

    public void scrollFunction(Object[] args) {
        JSDebug.println("scrollFunction:" + args);
    }

    public static void scroll(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).scrollFunction(args);
    }

    public void jsFunction_scrollBy(Object x, Object y) {
        JSDebug.println("jsFunction_scrollBy:");
    }

    public void scrollByFunction(Object[] args) {
        JSDebug.println("scrollByFunction:" + args);
    }

    public static void scrollBy(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).scrollByFunction(args);
    }

    public void jsFunction_scrollTo(Object x, Object y) {
        JSDebug.println("jsFunction_scrollTo:");
    }

    public void scrollToFunction(Object[] args) {
        JSDebug.println("scrollToFunction:" + args);
    }

    public static void scrollTo(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).scrollToFunction(args);
    }

    public void jsFunction_setInterval(Object code, Object interval) {
        JSDebug.println("jsFunction_setInterval:");
    }

    public void setIntervalFunction(Object[] args) {
        JSDebug.println("setIntervalFunction:" + args);
    }

    public static Scriptable setInterval(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).setIntervalFunction(args);
        return Context.toObject((Object)new Integer(100), (Scriptable)thisObj);
    }

    public void jsFunction_setTimeout(Object code, Object delay) {
        JSDebug.println("jsFunction_setTimeout:");
    }

    public void setTimeoutFunction(Object[] args) {
        JSDebug.println("setTimeoutFunction");
        if (args == null || args.length == 0) {
            return;
        }
        String timeOutFunction = args[0].toString();
        if (this.m_preTimeOutFunction.equals(timeOutFunction)) {
            return;
        }
        this.m_preTimeOutFunction = timeOutFunction;
        try {
            this.executeScript(timeOutFunction);
        }
        catch (Exception e) {
            JSDebug.println(e.getMessage());
        }
    }

    public static Scriptable setTimeout(Context cxt, Scriptable thisObj, Object[] args, Function funObj) {
        ((JSWindow)thisObj).setTimeoutFunction(args);
        return Context.toObject((Object)new Integer(100), (Scriptable)thisObj);
    }

    public Object jsFunction_valueOf(String type) {
        return this.valueOf(type);
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return this.getURL().toExternalForm();
        }
        if (type.equals("object")) {
            return this;
        }
        if (type.equals("number")) {
            return "0";
        }
        return null;
    }

    public boolean getLoading() {
        return this.loading;
    }

    public void setLoading(Object loading) {
        this.loading = loading.toString().equalsIgnoreCase("true");
    }

    public void setState(int state) {
        this.setState(state, null);
        this.loading = state == IN_LOADING;
    }

    public void setState(int state, String urlSource) {
        if (state != this.windowState && state == IN_SERVER) {
            this.m_listener = new JSServerListener(urlSource, this);
        } else if (this.windowState == IN_SERVER && state != IN_SERVER && this.m_listener != null && this.m_listener instanceof JSServerListener) {
            this.m_listener.reset();
            this.m_listener = null;
        }
        this.windowState = state;
        this.loading = state == IN_LOADING;
        int size = this.m_frames.size();
        int i = 0;
        while (i < size) {
            this.m_frames.at(i).setState(state);
            this.m_frames.at((int)i).m_listener = this.m_listener;
            ++i;
        }
    }

    public int getState() {
        return this.windowState;
    }

    public Object get(String name, Scriptable start) {
        JSDebug.println("JSWindow:get... " + name);
        Object obj = super.get(name, start);
        if (obj == NOT_FOUND) {
            obj = this.getParentScope().get(name, start);
            if (obj != NOT_FOUND) {
                return obj;
            }
            if (constants.get(name) != null) {
                return NOT_FOUND;
            }
            int size = this.m_frames.size();
            int i = 0;
            while (i < size) {
                JSWindow child = this.m_frames.at(i);
                if (child.name.equals(name)) {
                    return child;
                }
                obj = child.get(name, start);
                if (obj != NOT_FOUND) {
                    return obj;
                }
                ++i;
            }
            obj = this.m_document.findHtmlObjectById(name, start);
            if (obj == NOT_FOUND) {
                obj = this.m_document.findFormObject(name);
            }
        }
        if (obj == NOT_FOUND) {
            JSDebug.println("****** NOT_FOUND : " + name);
        }
        return obj;
    }

    public void put(String name, Scriptable start, Object value) {
        super.put(name, start, value);
        JSDebug.println("-------- JSWindow:put... " + name + " : " + value);
    }

    public Scriptable findFormElement(String formId, String name) {
        Scriptable obj = this.m_document.findFormElement(formId, name);
        if (obj == null) {
            int size = this.m_frames.size();
            int i = 0;
            while (i < size) {
                obj = this.m_frames.at((int)i).m_document.findFormElement(formId, name);
                if (obj != null) {
                    return obj;
                }
                ++i;
            }
        } else {
            return obj;
        }
        return this.m_scope;
    }

    public String getSelectedIndex(String formId, String name, String optionValue) {
        return this.m_document.getSelectedIndex(formId, name, optionValue);
    }

    public void setJsBuilderListener(JSBuilderListener builderListener) {
        this.m_document.setJsBuilderListener(builderListener);
    }

    public JSBuilderListener getJsBuilderListener() {
        return this.m_document.getJsBuilderListener();
    }

    public Scriptable getScopeById(String name) {
        if (name == null || name.length() == 0) {
            return this.m_scope;
        }
        Object obj = ((JSAllArray)this.m_document.getAll()).findObjById(name);
        if (obj == null) {
            int size = this.m_frames.size();
            int i = 0;
            while (i < size) {
                obj = ((JSAllArray)this.m_frames.at((int)i).m_document.getAll()).findObjById(name);
                if (obj != null) {
                    return (Scriptable)obj;
                }
                ++i;
            }
        } else {
            return (Scriptable)obj;
        }
        return this.m_scope;
    }

    public JSWindow getHiddenWindow(String name) {
        return this.m_frames.getHiddenWindow(name, false);
    }

    public JSWindow getHiddenWindow() {
        return this.m_frames.getHiddenWindow();
    }

    public DNode getDNode() {
        return null;
    }

    public void setListener(IDomChangeListener listener) {
        this.m_domChangeListener = listener;
    }

    IDomChangeListener getListener() {
        return this.m_domChangeListener;
    }

    public JSElement getElementById(String id) {
        Element node = this.getHTMLDocument().getElementById(id);
        return this.getWrapper(node, true);
    }

    public JSElement getWrapper(Node node, boolean create) {
        JSElement elem = this.m_elements.get(node);
        if (elem == null && create) {
            elem = this.createWrapper(node);
            this.addWrapper(node, elem);
        }
        return elem;
    }

    void addWrapper(Node node, JSElement element) {
        this.m_elements.put(node, element);
    }

    private JSElement createWrapper(Node node) {
        if (node instanceof DBody) {
            return new JSBody(this, (DBody)node);
        }
        if (node instanceof DInput) {
            return new JSInput(this, (DInput)node);
        }
        if (node instanceof DSelect) {
            return new JSSelect(this, (DSelect)node);
        }
        if (node instanceof DButton) {
            return new JSButton(this, (DButton)node);
        }
        if (node instanceof DLabel) {
            return new JSLabel(this, (DLabel)node);
        }
        if (node instanceof DDiv) {
            return new JSDiv(this, (DDiv)node);
        }
        if (node instanceof DSpan) {
            return new JSSpan(this, (DSpan)node);
        }
        return new JSElement(this, (BaseHtmlElement)node);
    }

    public Position getTopLeft() {
        return this.m_topLeft;
    }

    public void setTopLeft(Position topLeft) {
        this.m_topLeft = topLeft;
    }

    public int getHeight() {
        return this.m_height;
    }

    public void setHeight(int hight) {
        this.m_height = hight;
    }

    public int getWidth() {
        return this.m_width;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    public static class Position {
        private int x;
        private int y;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }
    }
}

